/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.icpac.custom.resulthandler;

import com.jxdinfo.idp.duplicatecheck.api.entity.po.DuplicateCheckIgnoreLibrary;
import com.jxdinfo.idp.icpac.core.entity.DuplicateCheckInfo;
import com.jxdinfo.idp.icpac.core.entity.DuplicateCheckResult;
import com.jxdinfo.idp.icpac.core.handler.DuplicateCheckResultHandler;
import com.jxdinfo.idp.icpac.core.rmi.resp.DuplicateCheckIgnoreResponse;
import com.jxdinfo.idp.icpac.service.DuplicateCheckIgnoreLibraryService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IgnoreResultHandler
implements DuplicateCheckResultHandler {
    private static final Logger log = LoggerFactory.getLogger(IgnoreResultHandler.class);
    private DuplicateCheckIgnoreLibraryService libraryService;

    public IgnoreResultHandler(DuplicateCheckIgnoreLibraryService libraryService) {
        this.libraryService = libraryService;
    }

    @Override
    public void handleResult(DuplicateCheckResult checkResult) {
        DuplicateCheckInfo checkInfo = checkResult.getInfo();
        if (!checkResult.isSuccess()) {
            log.error("\u5f53\u524d\u5ffd\u7565\u51fa\u9519\u4e0d\u9700\u8981\u6267\u884c\u540e\u7eed\u7ed3\u679c");
            return;
        }
        Object executionResult = checkResult.getExecutionResult();
        if (executionResult == null) {
            log.info("\u7ed3\u679c\u4e3a\u7a7a");
            return;
        }
        if (!(executionResult instanceof DuplicateCheckIgnoreResponse)) {
            log.info("\u5f53\u524d\u7684reponse\u4e0d\u662fDuplicateCheckIgnoreResponse\u7c7b\u578b\u7684\uff0c\u65e0\u6cd5\u89e3\u6790");
            return;
        }
        DuplicateCheckIgnoreResponse response = (DuplicateCheckIgnoreResponse)executionResult;
        log.info("\u5ffd\u7565\u7684\u7ed3\u679c\u96c6\u4e3a\uff1a{}", (Object)response);
        String aiTextId = response.getText_id();
        DuplicateCheckIgnoreLibrary ignoreLibrary = new DuplicateCheckIgnoreLibrary();
        ignoreLibrary.setSentenceId(checkInfo.getAttachment("sentenceId", String.class));
        ignoreLibrary.setAiTextId(aiTextId);
        this.libraryService.updateBySentenceId(ignoreLibrary);
    }
}

