/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.icpac.core.context;

import com.jxdinfo.idp.icpac.core.entity.DuplicateCheckTask;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.LockSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DuplicateCheckContext {
    private static final Logger log = LoggerFactory.getLogger(DuplicateCheckContext.class);
    private final DuplicateCheckTask task;
    private final List<Thread> waitThread = new ArrayList<Thread>();
    private volatile AtomicInteger vectorizationCount = new AtomicInteger(0);

    public DuplicateCheckContext(DuplicateCheckTask task) {
        this.task = task;
    }

    public void increment() {
        int vectorizationCountInt;
        boolean isContinue;
        while (isContinue = !this.vectorizationCount.compareAndSet(vectorizationCountInt = this.vectorizationCount.get(), vectorizationCountInt + 1)) {
        }
    }

    public void decrement() {
        int vectorizationCountInt;
        boolean isContinue;
        while (isContinue = !this.vectorizationCount.compareAndSet(vectorizationCountInt = this.vectorizationCount.get(), vectorizationCountInt - 1)) {
        }
        vectorizationCountInt = this.vectorizationCount.get();
        this.waitThread.add(Thread.currentThread());
        if (vectorizationCountInt == 0) {
            this.notifyWait();
        }
    }

    public boolean isCheck() {
        this.decrement();
        int vectorizationCountInt = this.vectorizationCount.get();
        if (vectorizationCountInt == 0) {
            return true;
        }
        log.info("\u5f53\u524d\u7ebf\u7a0b\u963b\u585e");
        LockSupport.parkNanos(10800000000000L);
        return true;
    }

    private void notifyWait() {
        for (Thread thread : this.waitThread) {
            LockSupport.unpark(thread);
            log.info("\u5f53\u524d\u7ebf\u7a0b\u88ab\u5524\u9192{}", (Object)thread.getName());
        }
    }
}

