/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.icpac.utils;

import cn.hutool.core.util.IdUtil;
import com.jxdinfo.idp.common.util.file.LibreOfficePDFConvert;
import com.jxdinfo.idp.icpac.utils.FilenameUtils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import org.apache.commons.io.IOUtils;
import org.jodconverter.office.OfficeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.mock.web.MockMultipartFile;
import org.springframework.web.multipart.MultipartFile;

public class FileConverterUtils {
    private static final Logger log = LoggerFactory.getLogger(FileConverterUtils.class);
    public static final String DOC_MAGIC_CODE = "d0cf11e0";

    protected static boolean isDoc(MultipartFile file) throws Exception {
        byte[] code = file.getBytes();
        StringBuilder codeSb = new StringBuilder();
        for (int i = 0; i < 4; ++i) {
            codeSb.append(String.format("%02x", code[i]));
        }
        return DOC_MAGIC_CODE.equalsIgnoreCase(codeSb.toString());
    }

    public static MultipartFile word2Pdf(MultipartFile file) throws Exception {
        long l = System.currentTimeMillis();
        String filePath = System.getProperty("user.dir");
        String filename = file.getOriginalFilename();
        File tmpFile = new File(filePath + File.separator + IdUtil.simpleUUID() + filename);
        File target = new File(filePath + File.separator + IdUtil.simpleUUID() + FilenameUtils.getFileSuffix(filename) + ".pdf");
        return FileConverterUtils.fileConvert(file, l, tmpFile, target, FilenameUtils.getFileSuffix(filename) + ".docx");
    }

    public static MultipartFile doc2Docx(MultipartFile file) throws Exception {
        if (!FileConverterUtils.isDoc(file)) {
            return file;
        }
        long l = System.currentTimeMillis();
        String filePath = System.getProperty("user.dir");
        String fileName = file.getOriginalFilename();
        File tmpFile = new File(filePath + File.separator + IdUtil.simpleUUID() + fileName);
        File target = new File(filePath + File.separator + IdUtil.simpleUUID() + FilenameUtils.getFileSuffix(fileName) + ".docx");
        return FileConverterUtils.fileConvert(file, l, tmpFile, target, FilenameUtils.getFileSuffix(fileName) + ".docx");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static MockMultipartFile fileConvert(MultipartFile file, long l, File tmpFile, File target, String fileName) throws IOException {
        try {
            tmpFile = LibreOfficePDFConvert.convert((File)tmpFile, (File)target);
        }
        catch (OfficeException e) {
            log.error("\u6587\u4ef6\u8f6c\u6362\u5931\u8d25", (Throwable)e);
            throw new RuntimeException(e);
        }
        BufferedOutputStream bos = null;
        BufferedInputStream bis = null;
        try {
            bos = new BufferedOutputStream(Files.newOutputStream(tmpFile.toPath(), new OpenOption[0]));
            IOUtils.copy((InputStream)file.getInputStream(), (OutputStream)bos);
            bos.flush();
            bis = new BufferedInputStream(Files.newInputStream(target.toPath(), new OpenOption[0]));
            MockMultipartFile mockMultipartFile = new MockMultipartFile(fileName, fileName, null, (InputStream)bis);
            return mockMultipartFile;
        }
        finally {
            log.info("doc\u8f6cdocx\u7528\u65f6\u4e3a\uff1a" + (System.currentTimeMillis() - l) / 1000L + "s");
            if (bos != null) {
                try {
                    bos.close();
                }
                catch (IOException iOException) {}
            }
            if (bis != null) {
                try {
                    bis.close();
                }
                catch (IOException iOException) {}
            }
            if (tmpFile.exists()) {
                tmpFile.delete();
            }
            if (target.exists()) {
                target.delete();
            }
        }
    }
}

