/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.icpac.custom.sentencehandler;

import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.idp.common.entity.util.docparse.location.ParaLocation;
import com.jxdinfo.idp.common.entity.util.docparse.location.TableLocation;
import com.jxdinfo.idp.common.entity.util.docparse.word.WordCellInfo;
import com.jxdinfo.idp.common.entity.util.docparse.word.WordChapterInfo;
import com.jxdinfo.idp.common.entity.util.docparse.word.WordElementInfo;
import com.jxdinfo.idp.common.entity.util.docparse.word.WordParagraphInfo;
import com.jxdinfo.idp.common.entity.util.docparse.word.WordRowInfo;
import com.jxdinfo.idp.common.entity.util.docparse.word.WordTableInfo;
import com.jxdinfo.idp.duplicatecheck.api.entity.dto.DuplicateCheckChapterDto;
import com.jxdinfo.idp.icpac.core.entity.DuplicateCheckCandidateSentence;
import com.jxdinfo.idp.icpac.core.entity.DuplicateCheckInfo;
import com.jxdinfo.idp.icpac.core.handler.SentenceHandler;
import com.jxdinfo.idp.icpac.custom.sentencehandler.SentenceHandlerSupport;
import com.jxdinfo.idp.icpac.utils.FilenameUtils;
import com.jxdinfo.idp.icpac.utils.SentenceStrUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.multipart.MultipartFile;

public class WordSentenceHandler
implements SentenceHandlerSupport,
SentenceHandler {
    private static final Logger log = LoggerFactory.getLogger(WordSentenceHandler.class);
    private static final int MIN_SENTENCE_LENGTH = 15;
    private static final int MAX_SENTENCE_LENGTH = 50;
    private static final String VIRTUAL_CHAPTER = "virtualChapter";
    private static final Pattern NO_PATTERN = Pattern.compile("(\\d\\.?)+");
    private final ThreadLocal<Integer> index = new ThreadLocal();

    @Override
    public boolean support(MultipartFile file) {
        if (file == null) {
            return false;
        }
        String filename = file.getOriginalFilename();
        String fileSuffix = FilenameUtils.getFileSuffix(filename);
        return Objects.equals(fileSuffix, "docx") || Objects.equals(fileSuffix, "doc");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<DuplicateCheckCandidateSentence> handleSentence(Object text, DuplicateCheckInfo checkInfo) {
        try {
            if (text == null) {
                List<DuplicateCheckCandidateSentence> list = null;
                return list;
            }
            if (!(text instanceof List)) {
                throw new RuntimeException("\u5f53\u524dword\u7684\u65ad\u53e5\u5904\u7406\u5668\u4e0d\u80fd\u5904\u7406\u5f53\u524d\u7684\u7c7b\u578b\uff1a" + text.getClass());
            }
            List chapterInfoList = (List)text;
            List chapterConfig = checkInfo.getAttachment("chapterConfig", List.class);
            chapterConfig = chapterConfig == null ? Collections.emptyList() : chapterConfig;
            List tableConfig = checkInfo.getAttachment("tableConfig", List.class);
            tableConfig = tableConfig == null ? Collections.emptyList() : tableConfig;
            ArrayList<DuplicateCheckCandidateSentence> candidateSentence = new ArrayList<DuplicateCheckCandidateSentence>();
            this.index.set(0);
            this.getCandidateWordElement(chapterInfoList, chapterConfig, tableConfig, candidateSentence, "");
            ArrayList<DuplicateCheckCandidateSentence> arrayList = candidateSentence;
            return arrayList;
        }
        finally {
            this.index.remove();
        }
    }

    public void getCandidateWordElement(List<WordChapterInfo> chapterInfoList, List<DuplicateCheckChapterDto> chapterConfig, List<Map<String, Object>> tableConfig, List<DuplicateCheckCandidateSentence> candidateSentenceList, String parentTitleName) {
        for (WordChapterInfo chapterInfo : chapterInfoList) {
            DuplicateCheckChapterDto chapterDto;
            String titleName = chapterInfo.getTitleName();
            Matcher matcher = NO_PATTERN.matcher(titleName);
            if (matcher.find()) {
                String no = matcher.group();
                titleName = titleName.replaceAll(no, "");
            }
            if ((chapterDto = this.canAssertSentence(titleName = SentenceStrUtils.format(titleName), chapterConfig)) != null) {
                this.getCandidateWordElement(chapterInfo, chapterDto, tableConfig, candidateSentenceList);
                continue;
            }
            if (StringUtils.isNotEmpty((CharSequence)parentTitleName)) {
                StringBuilder sb = new StringBuilder();
                titleName = sb.append(parentTitleName).append("/").append(titleName).toString();
            }
            if ((chapterDto = this.canAssertSentence(titleName, chapterConfig)) != null) {
                this.getCandidateWordElement(chapterInfo, chapterDto, tableConfig, candidateSentenceList);
                continue;
            }
            this.getCandidateWordElement(chapterInfo.getChildChapterList(), chapterConfig, tableConfig, candidateSentenceList, titleName);
        }
    }

    private void getCandidateWordElement(WordChapterInfo chapterInfo, DuplicateCheckChapterDto chapterConfig, List<Map<String, Object>> tableConfig, List<DuplicateCheckCandidateSentence> candidateSentence) {
        if (Objects.equals(VIRTUAL_CHAPTER, chapterConfig.getChapterConfigName())) {
            this.getCandidateSentence(chapterInfo, tableConfig, candidateSentence);
            return;
        }
        ArrayList<WordElementInfo> maybeElementList = new ArrayList<WordElementInfo>();
        ArrayList<WordElementInfo> certainElementList = new ArrayList<WordElementInfo>();
        List eInfoList = chapterInfo.getEInfoList();
        if (CollectionUtils.isNotEmpty((Collection)eInfoList)) {
            certainElementList.addAll(eInfoList);
            maybeElementList.addAll(eInfoList);
        }
        this.tryFindCandidateWorElement(chapterInfo.getChildChapterList(), chapterConfig, maybeElementList, certainElementList);
        WordChapterInfo virtualChapterInfo = new WordChapterInfo();
        virtualChapterInfo.setTitleName(VIRTUAL_CHAPTER);
        if (CollectionUtils.isNotEmpty(certainElementList)) {
            virtualChapterInfo.setEInfoList(certainElementList);
        } else if (CollectionUtils.isNotEmpty(maybeElementList)) {
            virtualChapterInfo.setEInfoList(maybeElementList);
        } else {
            log.info("\u6ca1\u6709\u627e\u5230\u4efb\u4f55\u53ef\u4ee5\u5339\u914d\u7684\u6bb5\u843d...............");
            return;
        }
        this.getCandidateSentence(virtualChapterInfo, tableConfig, candidateSentence);
    }

    private void tryFindCandidateWorElement(List<WordChapterInfo> childChapterList, DuplicateCheckChapterDto chapterConfig, List<WordElementInfo> maybeElementList, List<WordElementInfo> certainElementList) {
        if (CollectionUtils.isEmpty(childChapterList)) {
            return;
        }
        for (WordChapterInfo chapterInfo : childChapterList) {
            String titleName = chapterInfo.getTitleName();
            boolean include = false;
            boolean exclude = false;
            List keyWordList = chapterConfig.getKeyWordList();
            for (Object keyWord : keyWordList) {
                if (!StringUtils.isNotEmpty((CharSequence)keyWord) || !titleName.contains((CharSequence)keyWord)) continue;
                include = true;
                for (WordElementInfo elementInfo : chapterInfo.getChildParagraphList()) {
                    elementInfo.setBelongChapter(chapterInfo.getTitleName());
                    certainElementList.add(elementInfo);
                }
                this.excludeNoKeyWord(chapterInfo.getChildChapterList(), chapterConfig, maybeElementList, certainElementList);
                break;
            }
            if (!include) {
                Object keyWord;
                List noKeyWordList = chapterConfig.getNoKeyWordList();
                keyWord = noKeyWordList.iterator();
                while (keyWord.hasNext()) {
                    String noKeyWord = (String)keyWord.next();
                    if (!titleName.contains(noKeyWord)) continue;
                    exclude = true;
                    break;
                }
            }
            if (include || exclude) continue;
            if (CollectionUtils.isEmpty((Collection)keyWordList)) {
                for (WordElementInfo elementInfo : chapterInfo.getChildParagraphList()) {
                    elementInfo.setBelongChapter(chapterInfo.getTitleName());
                    maybeElementList.add(elementInfo);
                }
            }
            this.tryFindCandidateWorElement(chapterInfo.getChildChapterList(), chapterConfig, maybeElementList, certainElementList);
        }
    }

    private void excludeNoKeyWord(List<WordChapterInfo> childChapterList, DuplicateCheckChapterDto chapterConfig, List<WordElementInfo> maybeElementList, List<WordElementInfo> certainElementList) {
        if (CollectionUtils.isEmpty(childChapterList)) {
            return;
        }
        for (WordChapterInfo chapterInfo : childChapterList) {
            boolean exclude = false;
            List noKeyWordList = chapterConfig.getNoKeyWordList();
            String titleName = chapterInfo.getTitleName();
            for (String noKeyWord : noKeyWordList) {
                if (!StringUtils.isNotEmpty((CharSequence)titleName) || !titleName.contains(noKeyWord)) continue;
                exclude = true;
                break;
            }
            if (exclude) continue;
            log.info("\u5f53\u524d\u627e\u5230\u7684\u540d\u79f0\u4e3a\uff1a{}", (Object)titleName);
            for (WordElementInfo elementInfo : chapterInfo.getChildParagraphList()) {
                elementInfo.setBelongChapter(chapterInfo.getTitleName());
                certainElementList.add(elementInfo);
            }
            this.excludeNoKeyWord(chapterInfo.getChildChapterList(), chapterConfig, maybeElementList, certainElementList);
        }
    }

    private void getCandidateSentence(WordChapterInfo chapterInfo, List<Map<String, Object>> tableConfig, List<DuplicateCheckCandidateSentence> candidateSentence) {
        List eInfoList = chapterInfo.getChildParagraphList();
        for (WordElementInfo elementInfo : eInfoList) {
            String type = elementInfo.getType();
            if (Objects.equals("para", type)) {
                WordParagraphInfo paragraphInfo = (WordParagraphInfo)elementInfo;
                this.handleParagraph(paragraphInfo, candidateSentence);
                continue;
            }
            if (!Objects.equals("table", type)) continue;
            WordTableInfo tableInfo = (WordTableInfo)elementInfo;
            this.handleTable(tableInfo, tableConfig, candidateSentence);
        }
        List childChapterList = chapterInfo.getChildChapterList();
        for (WordChapterInfo wordChapterInfo : childChapterList) {
            this.getCandidateSentence(wordChapterInfo, tableConfig, candidateSentence);
        }
    }

    private void handleTable(WordTableInfo tableInfo, List<Map<String, Object>> tableConfig, List<DuplicateCheckCandidateSentence> candidateSentenceList) {
        List cells;
        HashMap<String, TableTextInfo> coor = new HashMap<String, TableTextInfo>();
        List rows = tableInfo.getRows();
        int rLen = rows.size();
        for (int i = 0; i < rLen; ++i) {
            WordRowInfo wordRowInfo = (WordRowInfo)rows.get(i);
            cells = wordRowInfo.getCells();
            int cLen = cells.size();
            for (int j = 0; j < cLen; ++j) {
                WordCellInfo cellInfo = (WordCellInfo)cells.get(j);
                Integer type = cellInfo.getType();
                if (type != null && type == 2) {
                    coor.put(i + "," + j, null);
                    continue;
                }
                String text = cellInfo.getText();
                text = text == null ? "" : text;
                coor.put(i + "," + j, new TableTextInfo(text, wordRowInfo, cellInfo));
            }
        }
        List<Integer> specialColInt = this.canAssertTable(coor, tableConfig);
        if (specialColInt == null) {
            return;
        }
        if (CollectionUtils.isNotEmpty(specialColInt)) {
            for (Integer coorCol : specialColInt) {
                int rLen2 = rows.size();
                for (int i = 0; i < rLen2; ++i) {
                    TableTextInfo tableTextInfo = (TableTextInfo)coor.get(i + "," + coorCol);
                    for (int k = i - 1; k > 0 && tableTextInfo == null; --k) {
                        tableTextInfo = (TableTextInfo)coor.get(k + "," + coorCol);
                    }
                    if (!StringUtils.isNotEmpty((CharSequence)tableTextInfo.getText()) || tableTextInfo.getText().length() <= 10) continue;
                    DuplicateCheckCandidateSentence candidateSentence = this.toCandidateSentence(tableTextInfo.getText(), tableInfo, tableTextInfo.wordCellInfo, tableTextInfo.getWordRowInfo());
                    candidateSentenceList.add(candidateSentence);
                }
            }
        } else {
            for (WordRowInfo wordRowInfo : rows) {
                cells = wordRowInfo.getCells();
                for (WordCellInfo cellInfo : cells) {
                    String text;
                    Integer type = cellInfo.getType();
                    if (type != null && type == 2 || !StringUtils.isNotEmpty((CharSequence)(text = cellInfo.getText())) || text.length() <= 10) continue;
                    DuplicateCheckCandidateSentence candidateSentence = this.toCandidateSentence(text, tableInfo, cellInfo, wordRowInfo);
                    candidateSentenceList.add(candidateSentence);
                }
            }
        }
    }

    private DuplicateCheckCandidateSentence toCandidateSentence(String tableTextInfo, WordTableInfo tableInfo, WordCellInfo cellInfo, WordRowInfo rowInfo) {
        DuplicateCheckCandidateSentence candidateSentence = new DuplicateCheckCandidateSentence();
        candidateSentence.setText(tableTextInfo);
        TableLocation tableLocation = new TableLocation();
        tableLocation.setPoiIndexList(tableInfo.getTableIndices());
        tableLocation.setPoiIndex(tableInfo.getPoiIndex());
        tableLocation.setCellIndex(cellInfo.getIndex());
        tableLocation.setRowIndex(rowInfo.getIndex());
        candidateSentence.addAttachment("location", JSONObject.toJSONString((Object)tableLocation));
        int index = this.index.get();
        this.index.set(index + 1);
        candidateSentence.addAttachment("index", index);
        candidateSentence.addAttachment("belongUser", tableInfo.getBelongChapter());
        return candidateSentence;
    }

    private List<Integer> canAssertTable(Map<String, TableTextInfo> coor, List<Map<String, Object>> tableConfig) {
        if (CollectionUtils.isEmpty(tableConfig)) {
            return new ArrayList<Integer>();
        }
        for (Map<String, Object> tabConfig : tableConfig) {
            int i;
            ArrayList<Integer> specialCol = new ArrayList<Integer>();
            Object tableHeaderObj = tabConfig.get("table_header");
            if (tableHeaderObj == null) continue;
            List specialRow = null;
            Object specialRowObj = tabConfig.get("special_row");
            if (specialRowObj != null) {
                specialRow = (List)specialRowObj;
            }
            List tableHeader = (List)tableHeaderObj;
            int rLen = tableHeader.size();
            block1: for (i = 0; i < rLen; ++i) {
                List cells = (List)tableHeader.get(i);
                int cLen = cells.size();
                for (int j = 0; j < cLen; ++j) {
                    String text = (String)cells.get(j);
                    TableTextInfo tableTextInfo = coor.get(i + "," + j);
                    for (int k = i + 1; k < rLen && tableTextInfo == null; ++k) {
                        tableTextInfo = coor.get(k + "," + j);
                    }
                    if (!Objects.equals(text, tableTextInfo.getText())) break block1;
                    if (!CollectionUtils.isNotEmpty((Collection)specialRow) || !specialRow.contains(text)) continue;
                    specialCol.add(j);
                }
            }
            if (i != tableHeader.size()) continue;
            return specialCol;
        }
        return null;
    }

    private void handleParagraph(WordParagraphInfo paragraphInfo, List<DuplicateCheckCandidateSentence> candidateSentenceList) {
        String text = paragraphInfo.getText();
        if (StringUtils.isEmpty((CharSequence)text)) {
            return;
        }
        text = text.trim();
        int length = text.length();
        if (text.replaceAll(" ", "").length() < 15) {
            return;
        }
        if (length < 15) {
            return;
        }
        if (length <= 50) {
            DuplicateCheckCandidateSentence candidateSentence = this.toCandidateSentence(text, text, paragraphInfo);
            candidateSentenceList.add(candidateSentence);
        } else {
            StringBuilder sb = new StringBuilder();
            String punc = "";
            int sentenceIndex = 0;
            String beforePunc = "";
            int index = 0;
            while (index < length) {
                DuplicateCheckCandidateSentence candidateSentence;
                DuplicateCheckCandidateSentence candidateSentence2;
                String candidateSentenceStr;
                int periodIndex = text.indexOf("\u3002", index);
                int semicolonIndex = text.indexOf("\uff1b", index);
                if (periodIndex == -1 && semicolonIndex == -1) {
                    candidateSentenceStr = text.substring(index);
                    if (StringUtils.isNotEmpty((CharSequence)candidateSentenceStr) && !Objects.equals("\n", text)) {
                        if (sb.length() != 0) {
                            candidateSentenceStr = sb.append(punc).append(candidateSentenceStr).toString();
                        }
                        if (candidateSentenceStr.length() > 15) {
                            candidateSentence2 = this.toCandidateSentence(text, candidateSentenceStr, paragraphInfo);
                            candidateSentenceList.add(candidateSentence2);
                        }
                    }
                    return;
                }
                if (periodIndex - index > 50 && semicolonIndex - index > 50) {
                    if (periodIndex > semicolonIndex) {
                        sentenceIndex = semicolonIndex;
                        punc = "\uff1b";
                    } else {
                        sentenceIndex = periodIndex;
                        punc = "\u3002";
                    }
                } else if (periodIndex > semicolonIndex) {
                    sentenceIndex = periodIndex;
                    punc = "\u3002";
                } else {
                    sentenceIndex = semicolonIndex;
                    punc = "\uff1b";
                }
                if (sentenceIndex - index >= 50) {
                    if (sb.length() > 0) {
                        if (sb.length() > 15) {
                            candidateSentence = this.toCandidateSentence(text, sb.toString(), paragraphInfo);
                            candidateSentenceList.add(candidateSentence);
                        }
                        sb = new StringBuilder();
                    }
                    candidateSentenceStr = text.substring(index, sentenceIndex);
                    candidateSentence2 = this.toCandidateSentence(text, candidateSentenceStr, paragraphInfo);
                    candidateSentenceList.add(candidateSentence2);
                } else {
                    if (sb.length() != 0) {
                        sb.append(beforePunc);
                    }
                    sb.append(text, index, sentenceIndex);
                    if (sb.length() >= 50) {
                        candidateSentence = this.toCandidateSentence(text, sb.toString(), paragraphInfo);
                        candidateSentenceList.add(candidateSentence);
                        sb = new StringBuilder();
                    }
                }
                if (sentenceIndex + 1 < length) {
                    beforePunc = punc;
                }
                index = sentenceIndex + 1;
            }
            if (sb.length() > 0) {
                DuplicateCheckCandidateSentence candidateSentence = candidateSentenceList.get(candidateSentenceList.size() - 1);
                String candidateSentenceStr = candidateSentence.getText() + beforePunc + sb;
                candidateSentence = this.toCandidateSentence(text, candidateSentenceStr, paragraphInfo);
                candidateSentenceList.set(candidateSentenceList.size() - 1, candidateSentence);
            }
        }
    }

    private DuplicateCheckCandidateSentence toCandidateSentence(String text, String candidateSentenceStr, WordParagraphInfo paragraphInfo) {
        DuplicateCheckCandidateSentence candidateSentence = new DuplicateCheckCandidateSentence();
        candidateSentence.setText(candidateSentenceStr);
        ParaLocation paraLocation = new ParaLocation();
        paraLocation.setPoiIndex(paragraphInfo.getPoiIndex());
        paraLocation.setTextIndex(Integer.valueOf(text.indexOf(candidateSentenceStr)));
        paraLocation.setTextLength(Integer.valueOf(candidateSentenceStr.length()));
        candidateSentence.addAttachment("location", JSONObject.toJSONString((Object)paraLocation));
        int index = this.index.get();
        this.index.set(index + 1);
        candidateSentence.addAttachment("index", index);
        candidateSentence.addAttachment("belongChapter", paragraphInfo.getBelongChapter());
        return candidateSentence;
    }

    private DuplicateCheckChapterDto canAssertSentence(String titleName, List<DuplicateCheckChapterDto> chapterConfig) {
        if (CollectionUtils.isEmpty(chapterConfig)) {
            DuplicateCheckChapterDto chapterDto = new DuplicateCheckChapterDto();
            chapterDto.setChapterConfigName(VIRTUAL_CHAPTER);
            return chapterDto;
        }
        if (StringUtils.isEmpty((CharSequence)titleName)) {
            return null;
        }
        for (DuplicateCheckChapterDto chapterDto : chapterConfig) {
            int i;
            String[] contentChapterArr;
            String chapterConfigName = chapterDto.getChapterConfigName();
            if (StringUtils.isEmpty((CharSequence)chapterConfigName)) {
                return null;
            }
            String[] baseChapterArr = chapterConfigName.split("/");
            if (baseChapterArr.length != (contentChapterArr = titleName.split("/")).length) continue;
            int length = baseChapterArr.length;
            for (i = 0; i < length && contentChapterArr[i].contains(baseChapterArr[i]); ++i) {
            }
            if (i != baseChapterArr.length) continue;
            log.info("\u5f53\u524d\u6267\u884c\u7684\u8def\u5f84\u4e3a\uff1a{}", (Object)chapterDto.getChapterConfigName());
            return chapterDto;
        }
        return null;
    }

    private class TableTextInfo {
        private String text;
        private WordRowInfo wordRowInfo;
        private WordCellInfo wordCellInfo;

        public TableTextInfo(String text, WordRowInfo wordRowInfo, WordCellInfo wordCellInfo) {
            this.text = text;
            this.wordRowInfo = wordRowInfo;
            this.wordCellInfo = wordCellInfo;
        }

        public TableTextInfo() {
        }

        public String getText() {
            return this.text;
        }

        public WordRowInfo getWordRowInfo() {
            return this.wordRowInfo;
        }

        public WordCellInfo getWordCellInfo() {
            return this.wordCellInfo;
        }

        public void setText(String text) {
            this.text = text;
        }

        public void setWordRowInfo(WordRowInfo wordRowInfo) {
            this.wordRowInfo = wordRowInfo;
        }

        public void setWordCellInfo(WordCellInfo wordCellInfo) {
            this.wordCellInfo = wordCellInfo;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TableTextInfo)) {
                return false;
            }
            TableTextInfo other = (TableTextInfo)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$text = this.getText();
            String other$text = other.getText();
            if (this$text == null ? other$text != null : !this$text.equals(other$text)) {
                return false;
            }
            WordRowInfo this$wordRowInfo = this.getWordRowInfo();
            WordRowInfo other$wordRowInfo = other.getWordRowInfo();
            if (this$wordRowInfo == null ? other$wordRowInfo != null : !this$wordRowInfo.equals(other$wordRowInfo)) {
                return false;
            }
            WordCellInfo this$wordCellInfo = this.getWordCellInfo();
            WordCellInfo other$wordCellInfo = other.getWordCellInfo();
            return !(this$wordCellInfo == null ? other$wordCellInfo != null : !this$wordCellInfo.equals(other$wordCellInfo));
        }

        protected boolean canEqual(Object other) {
            return other instanceof TableTextInfo;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $text = this.getText();
            result = result * 59 + ($text == null ? 43 : $text.hashCode());
            WordRowInfo $wordRowInfo = this.getWordRowInfo();
            result = result * 59 + ($wordRowInfo == null ? 43 : $wordRowInfo.hashCode());
            WordCellInfo $wordCellInfo = this.getWordCellInfo();
            result = result * 59 + ($wordCellInfo == null ? 43 : $wordCellInfo.hashCode());
            return result;
        }

        public String toString() {
            return "WordSentenceHandler.TableTextInfo(text=" + this.getText() + ", wordRowInfo=" + this.getWordRowInfo() + ", wordCellInfo=" + this.getWordCellInfo() + ")";
        }
    }
}

