/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.icpac.core.pdfparser.thirdparty;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.graphics.color.PDColor;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotation;
import org.apache.pdfbox.rendering.PageDrawer;
import org.apache.pdfbox.rendering.PageDrawerParameters;
import org.apache.pdfbox.util.Matrix;
import org.apache.pdfbox.util.Vector;

public class CustomPageDrawer
extends PageDrawer {
    private List<Shape> tableLines = new ArrayList<Shape>();
    private List<Shape> strokeLines = new ArrayList<Shape>();
    private List<Shape> fillLines = new ArrayList<Shape>();
    private List<Shape> fillAndStrokeLine = new ArrayList<Shape>();
    int countlines = 0;

    public List<Shape> getFillAndStrokeLine() {
        return this.fillAndStrokeLine;
    }

    public List<Shape> getStrokeLines() {
        return this.strokeLines;
    }

    public List<Shape> getFillLines() {
        return this.fillLines;
    }

    public List<Shape> getTableLines() {
        return this.tableLines;
    }

    public void setTableLines(List<Shape> tableLines) {
        this.tableLines = tableLines;
    }

    CustomPageDrawer(PageDrawerParameters parameters) throws IOException {
        super(parameters);
    }

    protected Paint getPaint(PDColor color) throws IOException {
        try {
            if (this.getGraphicsState().getNonStrokingColor() == color && color.toRGB() == (Color.RED.getRGB() & 0xFFFFFF)) {
                return Color.BLUE;
            }
        }
        catch (Exception e) {
            return super.getPaint(color);
        }
        return super.getPaint(color);
    }

    protected void showGlyph(Matrix textRenderingMatrix, PDFont font, int code, String unicode, Vector displacement) throws IOException {
        super.showGlyph(textRenderingMatrix, font, code, unicode, displacement);
        Shape bbox = new Rectangle2D.Float(0.0f, 0.0f, font.getWidth(code) / 1000.0f, 1.0f);
        AffineTransform at = textRenderingMatrix.createAffineTransform();
        bbox = at.createTransformedShape(bbox);
        Graphics2D graphics = this.getGraphics();
        Color color = graphics.getColor();
        Stroke stroke = graphics.getStroke();
        Shape clip = graphics.getClip();
        graphics.setClip(graphics.getDeviceConfiguration().getBounds());
        graphics.setColor(Color.BLACK);
        graphics.setStroke(new BasicStroke(0.5f));
        graphics.draw(bbox);
        graphics.setStroke(stroke);
        graphics.setColor(color);
        graphics.setClip(clip);
    }

    public void fillPath(int windingRule) throws IOException {
        Rectangle2D bbox = this.getLinePath().getBounds2D();
        if (bbox.getBounds2D().getWidth() > 1.0 || bbox.getBounds2D().getHeight() > 1.0) {
            this.fillLines.add(bbox);
        }
        super.fillPath(windingRule);
        Graphics2D graphics = this.getGraphics();
        Color color = graphics.getColor();
        Stroke stroke = graphics.getStroke();
        Shape clip = graphics.getClip();
        graphics.setClip(graphics.getDeviceConfiguration().getBounds());
        graphics.setColor(Color.RED);
        graphics.setStroke(new BasicStroke(0.5f));
        if (bbox.getBounds2D().getWidth() > 1.0 || bbox.getBounds2D().getHeight() > 1.0) {
            graphics.draw(bbox);
        }
        graphics.setStroke(stroke);
        graphics.setColor(color);
        graphics.setClip(clip);
        this.getLinePath().reset();
    }

    public void strokePath() throws IOException {
        Rectangle2D bbox = this.getLinePath().getBounds2D();
        if (bbox.getBounds2D().getWidth() > 1.0 || bbox.getBounds2D().getHeight() > 1.0) {
            this.strokeLines.add(bbox);
        }
        Graphics2D graphics = this.getGraphics();
        Color color = graphics.getColor();
        Stroke stroke = graphics.getStroke();
        Shape clip = graphics.getClip();
        graphics.setClip(graphics.getDeviceConfiguration().getBounds());
        graphics.setColor(Color.RED);
        graphics.setStroke(new BasicStroke(0.5f));
        graphics.draw(bbox);
        graphics.setStroke(stroke);
        graphics.setColor(color);
        graphics.setClip(clip);
        this.getLinePath().reset();
    }

    public void closePath() {
        Rectangle2D bbox = this.getLinePath().getBounds2D();
        if (bbox.getBounds2D().getWidth() > 1.0 || bbox.getBounds2D().getHeight() > 1.0) {
            this.fillAndStrokeLine.add(bbox);
        }
        Graphics2D graphics = this.getGraphics();
        Color color = graphics.getColor();
        Stroke stroke = graphics.getStroke();
        Shape clip = graphics.getClip();
        graphics.setClip(graphics.getDeviceConfiguration().getBounds());
        graphics.setColor(Color.RED);
        graphics.setStroke(new BasicStroke(0.5f));
        graphics.draw(bbox);
        graphics.setStroke(stroke);
        graphics.setColor(color);
        graphics.setClip(clip);
        this.getLinePath().reset();
    }

    public void showAnnotation(PDAnnotation annotation) throws IOException {
        this.saveGraphicsState();
        this.getGraphicsState().setNonStrokeAlphaConstants(0.35);
        super.showAnnotation(annotation);
        this.restoreGraphicsState();
    }

    void printPath() {
        GeneralPath path = this.getLinePath();
        PathIterator pathIterator = path.getPathIterator(null);
        double x = 0.0;
        double y = 0.0;
        double[] coords = new double[6];
        while (!pathIterator.isDone()) {
            ++this.countlines;
            switch (pathIterator.currentSegment(coords)) {
                case 0: {
                    x = coords[0];
                    y = coords[1];
                    break;
                }
                case 1: {
                    double width = this.getEffectiveWidth(coords[0] - x, coords[1] - y);
                    x = coords[0];
                    y = coords[1];
                    break;
                }
                case 2: {
                    x = coords[2];
                    y = coords[3];
                    break;
                }
                case 3: {
                    x = coords[4];
                    y = coords[5];
                    break;
                }
                case 4: {
                    System.out.println("Close path");
                }
            }
            pathIterator.next();
        }
    }

    double getEffectiveWidth(double dirX, double dirY) {
        if (dirX == 0.0 && dirY == 0.0) {
            return 0.0;
        }
        Matrix ctm = this.getGraphicsState().getCurrentTransformationMatrix();
        double widthX = dirY;
        double widthY = -dirX;
        double widthXTransformed = widthX * (double)ctm.getValue(0, 0) + widthY * (double)ctm.getValue(1, 0);
        double widthYTransformed = widthX * (double)ctm.getValue(0, 1) + widthY * (double)ctm.getValue(1, 1);
        double factor = Math.sqrt((widthXTransformed * widthXTransformed + widthYTransformed * widthYTransformed) / (widthX * widthX + widthY * widthY));
        return (double)this.getGraphicsState().getLineWidth() * factor;
    }
}

