/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.icpac.core.pdfparser.core;

import com.jxdinfo.idp.icpac.core.pdfparser.core.ParaStrategy;
import com.jxdinfo.idp.icpac.core.pdfparser.core.UnTaggedAnalyser;
import com.jxdinfo.idp.icpac.core.pdfparser.core.UnTaggedContext;
import com.jxdinfo.idp.icpac.core.pdfparser.pojo.ContentPojo;
import com.jxdinfo.idp.icpac.core.pdfparser.pojo.Language;
import com.jxdinfo.idp.icpac.core.pdfparser.pojo.LineStatus;
import com.jxdinfo.idp.icpac.core.pdfparser.pojo.Tu;
import com.jxdinfo.idp.icpac.core.pdfparser.table.CellAnalyser;
import com.jxdinfo.idp.icpac.core.pdfparser.tools.RenderInfo;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.text.TextPosition;

public class BirdViewer {
    public static void mergeTableElements(List<ContentPojo.contentElement> outList, PDDocument pdd) throws IOException {
        if (outList.size() == 0) {
            return;
        }
        ArrayList<Integer> indexes = new ArrayList<Integer>();
        ArrayList<Tu.Tuple2<Integer, ContentPojo.contentElement>> continuousList = new ArrayList<Tu.Tuple2<Integer, ContentPojo.contentElement>>();
        for (int k = 0; k < outList.size() - 1; ++k) {
            int index;
            int i;
            ContentPojo.contentElement contentElement2;
            ContentPojo.contentElement pre = outList.get(k);
            ContentPojo.contentElement post = outList.get(k + 1);
            if (!pre.getElementType().equals("table") || !post.getElementType().equals("table")) continue;
            if (continuousList.size() == 0) {
                if (!BirdViewer.ifNeedMerge(pre, post)) continue;
                continuousList.add(new Tu.Tuple2<Integer, ContentPojo.contentElement>(pre.getPageNumber(), pre));
                continuousList.add(new Tu.Tuple2<Integer, ContentPojo.contentElement>(post.getPageNumber(), post));
                indexes.add(k);
                indexes.add(k + 1);
                continue;
            }
            if (pre == ((Tu.Tuple2)continuousList.get(continuousList.size() - 1)).getValue()) {
                if (BirdViewer.ifNeedMerge(pre, post)) {
                    continuousList.add(new Tu.Tuple2<Integer, ContentPojo.contentElement>(post.getPageNumber(), post));
                    indexes.add(k + 1);
                    continue;
                }
                contentElement2 = BirdViewer.mergeTableElementsInner(continuousList, pdd);
                if (contentElement2 != null) {
                    for (i = indexes.size() - 1; i >= 0; --i) {
                        index = (Integer)indexes.get(i);
                        outList.set(index, null);
                    }
                    outList.set((Integer)indexes.get(0), contentElement2);
                }
                continuousList.clear();
                indexes.clear();
                continue;
            }
            contentElement2 = BirdViewer.mergeTableElementsInner(continuousList, pdd);
            if (contentElement2 != null) {
                for (i = indexes.size() - 1; i >= 0; --i) {
                    index = (Integer)indexes.get(i);
                    outList.set(index, null);
                }
                outList.set((Integer)indexes.get(0), contentElement2);
            }
            continuousList.clear();
            indexes.clear();
            if (!BirdViewer.ifNeedMerge(pre, post)) continue;
            continuousList.add(new Tu.Tuple2<Integer, ContentPojo.contentElement>(pre.getPageNumber(), pre));
            continuousList.add(new Tu.Tuple2<Integer, ContentPojo.contentElement>(post.getPageNumber(), post));
            indexes.add(k);
            indexes.add(k + 1);
        }
        if (continuousList.size() != 0) {
            ContentPojo.contentElement contentElement3 = BirdViewer.mergeTableElementsInner(continuousList, pdd);
            if (contentElement3 != null) {
                for (int i = indexes.size() - 1; i >= 0; --i) {
                    int index = (Integer)indexes.get(i);
                    outList.set(index, null);
                }
                outList.set((Integer)indexes.get(0), contentElement3);
            }
            continuousList.clear();
            indexes.clear();
        }
        for (int i = outList.size() - 1; i >= 0; --i) {
            if (outList.get(i) != null) continue;
            outList.remove(i);
        }
    }

    private static ContentPojo.contentElement mergeTableElementsInner(List<Tu.Tuple2<Integer, ContentPojo.contentElement>> continuousList, PDDocument pdd) throws IOException {
        ArrayList<Shape> newSpecifyShapes = new ArrayList<Shape>();
        Double preStartPoint = null;
        ArrayList<ContentPojo.contentElement.InnerCell> allCells = new ArrayList<ContentPojo.contentElement.InnerCell>();
        for (int i = 0; i < continuousList.size(); ++i) {
            allCells.addAll(continuousList.get(i).getValue().getCells());
            Tu.Tuple2<Integer, ContentPojo.contentElement> tu = continuousList.get(i);
            Integer pageNum = tu.getKey();
            List<Shape> shapes = CellAnalyser.getShapes(pdd, pageNum);
            Tu.Tuple2<Tu.Tuple2<Double, Double>, CellAnalyser.TableInfo> tableInfo = i == 0 ? CellAnalyser.getLastTableInfo(CellAnalyser.getTableInfos(shapes)) : CellAnalyser.getFirstTableInfo(CellAnalyser.getTableInfos(shapes));
            if (tableInfo == null) continue;
            Double startPoint = tableInfo.getValue().getYStart();
            Double yStart = tableInfo.getKey().getKey();
            Double yEnd = tableInfo.getValue().getYEnd();
            List<Shape> specifyShapes0 = CellAnalyser.getSpecifyShapes(shapes, yStart, yEnd);
            for (Shape shape : specifyShapes0) {
                double y;
                double height = shape.getBounds2D().getHeight();
                double width = shape.getBounds2D().getWidth();
                double x = shape.getBounds2D().getX();
                double newY = y = shape.getBounds2D().getY();
                if (preStartPoint != null) {
                    newY = y - yEnd + preStartPoint;
                }
                newSpecifyShapes.add(new Rectangle2D.Float((float)x, (float)newY, (float)width, (float)height));
            }
            preStartPoint = preStartPoint == null ? startPoint : Double.valueOf(startPoint - yEnd + preStartPoint);
        }
        List<Tu.Tuple2<Tu.Tuple2<Double, Double>, CellAnalyser.TableInfo>> tableInfos = CellAnalyser.getTableInfos(newSpecifyShapes);
        if (CollectionUtils.isEmpty(tableInfos) || tableInfos.size() != 1) {
            return null;
        }
        List<CellAnalyser.Cell> cellList = tableInfos.get(0).getValue().getCells();
        Integer colNum = tableInfos.get(0).getValue().getColNum();
        Integer rowNum = tableInfos.get(0).getValue().getRowNum();
        if (allCells.size() != cellList.size()) {
            return null;
        }
        ContentPojo.contentElement result = continuousList.get(0).getValue();
        int size = continuousList.get(0).getValue().getCells().size();
        for (int i = 0; i < allCells.size(); ++i) {
            ((ContentPojo.contentElement.InnerCell)allCells.get(i)).setRow_index(cellList.get(i).getRowIndex());
            ((ContentPojo.contentElement.InnerCell)allCells.get(i)).setCol_index(cellList.get(i).getColIndex());
            ((ContentPojo.contentElement.InnerCell)allCells.get(i)).setCol_span(cellList.get(i).getColSpan());
            if (i <= size) continue;
            ((ContentPojo.contentElement.InnerCell)allCells.get(i)).setIsNextPage(true);
        }
        result.setCol_num(colNum);
        result.setRow_num(rowNum);
        result.setCells(allCells);
        return result;
    }

    private static boolean ifNeedMerge(ContentPojo.contentElement preP, ContentPojo.contentElement p) {
        Integer row_num = preP.getRow_num();
        Integer tmp_row_num = p.getRow_num();
        if (row_num == null || row_num == 0 || tmp_row_num == null || tmp_row_num == 0) {
            return false;
        }
        List<ContentPojo.contentElement.InnerCell> cells = preP.getCells();
        List filterCells = cells.stream().filter(x -> x.getRow_index() == 1).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(filterCells)) {
            return false;
        }
        Float xStart = ((ContentPojo.contentElement.InnerCell)filterCells.get(0)).getXStart();
        float xEnd = ((ContentPojo.contentElement.InnerCell)filterCells.get(filterCells.size() - 1)).getXStart().floatValue() + ((ContentPojo.contentElement.InnerCell)filterCells.get(filterCells.size() - 1)).getWidth().floatValue();
        List<ContentPojo.contentElement.InnerCell> tmpCells = p.getCells();
        List tmpFilterCells = tmpCells.stream().filter(x -> x.getRow_index() == 1).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(tmpFilterCells)) {
            return false;
        }
        Float tmpXStart = ((ContentPojo.contentElement.InnerCell)tmpFilterCells.get(0)).getXStart();
        float tmpXEnd = ((ContentPojo.contentElement.InnerCell)tmpFilterCells.get(tmpFilterCells.size() - 1)).getXStart().floatValue() + ((ContentPojo.contentElement.InnerCell)tmpFilterCells.get(tmpFilterCells.size() - 1)).getWidth().floatValue();
        return !(Math.abs(xStart.floatValue() - tmpXStart.floatValue()) > 2.0f) && !(Math.abs(xEnd - tmpXEnd) > 2.0f);
    }

    private static ContentPojo.contentElement mergePElement(ContentPojo.contentElement lastE, ContentPojo.contentElement firstE) {
        ArrayList<ContentPojo.PdfStyleStruct> newStyleStruct = new ArrayList<ContentPojo.PdfStyleStruct>();
        String lastEText = lastE.getText();
        String firstEText = firstE.getText();
        String finalText = lastEText + "\n" + firstEText;
        newStyleStruct.addAll(lastE.getPdfStyleStructs());
        newStyleStruct.addAll(firstE.getPdfStyleStructs());
        lastE.setText(finalText);
        lastE.setPdfStyleStructs(newStyleStruct);
        return lastE;
    }

    public static void mergePElement(List<List<ContentPojo.contentElement>> docPages, UnTaggedContext unTaggedContext) {
        if (docPages == null || docPages.size() <= 1) {
            return;
        }
        for (int i = 0; i < docPages.size() - 1; ++i) {
            ArrayList<ContentPojo.contentElement> list;
            ContentPojo.contentElement e;
            boolean content1;
            boolean flag10;
            boolean flag8;
            boolean flag7;
            boolean flag3;
            List<ContentPojo.contentElement> curPage = docPages.get(i);
            List<ContentPojo.contentElement> nextPage = docPages.get(i + 1);
            if (CollectionUtils.isEmpty(curPage) || CollectionUtils.isEmpty(nextPage)) {
                return;
            }
            ContentPojo.contentElement lastE = curPage.get(curPage.size() - 1);
            ContentPojo.contentElement firstE = nextPage.get(0);
            String lastEType = lastE.getElementType();
            String firstEType = firstE.getElementType();
            if (!lastEType.equals("text") || !firstEType.equals("text")) continue;
            LineStatus endLineStatus = lastE.getEndLineStatus();
            LineStatus startLineStatus = firstE.getStartLineStatus();
            List<Tu.Tuple2<TextPosition, RenderInfo>> endLine = lastE.getEndLine();
            List<Tu.Tuple2<TextPosition, RenderInfo>> startLine = firstE.getStartLine();
            if (CollectionUtils.isEmpty(endLine) || CollectionUtils.isEmpty(startLine)) continue;
            float deltaLength = Math.min(UnTaggedAnalyser.calAvgDeltaLength(endLine), UnTaggedAnalyser.calAvgDeltaLength(startLine));
            Language language = unTaggedContext.getLanguage();
            if (language == Language.CHINESE) {
                flag3 = ParaStrategy.strategy3(endLine, startLine);
                flag7 = false;
                flag8 = ParaStrategy.strategy8(endLine, startLine, unTaggedContext, deltaLength);
                flag10 = ParaStrategy.strategy10(endLine, unTaggedContext, deltaLength);
                content1 = ParaStrategy.referParaEndByContent1(endLine, unTaggedContext);
                if (flag3 || flag7 || flag8 || flag10 || content1) continue;
                e = BirdViewer.mergePElement(lastE, firstE);
                list = new ArrayList<ContentPojo.contentElement>();
                firstE.setText(null);
                list.add(firstE);
                e.setCrossPageList(list);
                curPage.set(curPage.size() - 1, e);
                nextPage.remove(0);
                continue;
            }
            if (language != Language.ENGLISH) continue;
            flag3 = ParaStrategy.strategy3(endLine, startLine);
            flag7 = false;
            flag8 = ParaStrategy.strategy8(endLine, startLine, unTaggedContext, deltaLength);
            flag10 = ParaStrategy.strategy10(endLine, unTaggedContext, deltaLength);
            content1 = ParaStrategy.referParaEndByContent1(endLine, unTaggedContext);
            if (flag3 || flag7 || flag8 || flag10 || content1) continue;
            e = BirdViewer.mergePElement(lastE, firstE);
            list = new ArrayList();
            list.add(firstE);
            e.setCrossPageList(list);
            curPage.set(curPage.size() - 1, e);
            nextPage.remove(0);
        }
    }
}

