/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.icpac.core.pdfparser.table;

public class TableLine {
    public static VerticalLine connectVLine(VerticalLine v1, VerticalLine v2) {
        return new VerticalLine(v1.getX(), v1.getYStart(), Math.max(v1.getYEnd(), v2.getYEnd()));
    }

    public static HorizonLine connectHLine(HorizonLine h1, HorizonLine h2) {
        return new HorizonLine(h1.getY(), h1.getXStart(), Math.max(h1.getXEnd(), h2.getXEnd()));
    }

    public static class HorizonLine
    implements Comparable<HorizonLine> {
        public double y;
        public double xStart;
        public double xEnd;
        public double length;

        public HorizonLine(double y, double xStart, double xEnd) {
            this.y = y;
            this.xStart = xStart;
            this.xEnd = xEnd;
            this.length = xEnd - xStart;
        }

        @Override
        public int compareTo(HorizonLine h) {
            double y = h.getY();
            double xStart = h.getXStart();
            if (this.y > y) {
                return -1;
            }
            if (this.y < y) {
                return 1;
            }
            return Double.compare(this.xStart, xStart);
        }

        public double getY() {
            return this.y;
        }

        public double getXStart() {
            return this.xStart;
        }

        public double getXEnd() {
            return this.xEnd;
        }

        public double getLength() {
            return this.length;
        }

        public void setY(double y) {
            this.y = y;
        }

        public void setXStart(double xStart) {
            this.xStart = xStart;
        }

        public void setXEnd(double xEnd) {
            this.xEnd = xEnd;
        }

        public void setLength(double length) {
            this.length = length;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof HorizonLine)) {
                return false;
            }
            HorizonLine other = (HorizonLine)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (Double.compare(this.getY(), other.getY()) != 0) {
                return false;
            }
            if (Double.compare(this.getXStart(), other.getXStart()) != 0) {
                return false;
            }
            if (Double.compare(this.getXEnd(), other.getXEnd()) != 0) {
                return false;
            }
            return Double.compare(this.getLength(), other.getLength()) == 0;
        }

        protected boolean canEqual(Object other) {
            return other instanceof HorizonLine;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $y = Double.doubleToLongBits(this.getY());
            result = result * 59 + (int)($y >>> 32 ^ $y);
            long $xStart = Double.doubleToLongBits(this.getXStart());
            result = result * 59 + (int)($xStart >>> 32 ^ $xStart);
            long $xEnd = Double.doubleToLongBits(this.getXEnd());
            result = result * 59 + (int)($xEnd >>> 32 ^ $xEnd);
            long $length = Double.doubleToLongBits(this.getLength());
            result = result * 59 + (int)($length >>> 32 ^ $length);
            return result;
        }

        public String toString() {
            return "TableLine.HorizonLine(y=" + this.getY() + ", xStart=" + this.getXStart() + ", xEnd=" + this.getXEnd() + ", length=" + this.getLength() + ")";
        }

        public HorizonLine() {
        }
    }

    public static class VerticalLine
    implements Comparable<VerticalLine> {
        public double x;
        public double yStart;
        public double yEnd;
        public double length;

        public VerticalLine(double x, double yStart, double yEnd) {
            this.x = x;
            this.yStart = yStart;
            this.yEnd = yEnd;
            this.length = yEnd - yStart;
        }

        @Override
        public int compareTo(VerticalLine v) {
            double x = v.getX();
            double yStart = v.getYStart();
            if (this.x < x) {
                return -1;
            }
            if (this.x > x) {
                return 1;
            }
            return -Double.compare(yStart, this.yStart);
        }

        public double getX() {
            return this.x;
        }

        public double getYStart() {
            return this.yStart;
        }

        public double getYEnd() {
            return this.yEnd;
        }

        public double getLength() {
            return this.length;
        }

        public void setX(double x) {
            this.x = x;
        }

        public void setYStart(double yStart) {
            this.yStart = yStart;
        }

        public void setYEnd(double yEnd) {
            this.yEnd = yEnd;
        }

        public void setLength(double length) {
            this.length = length;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof VerticalLine)) {
                return false;
            }
            VerticalLine other = (VerticalLine)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (Double.compare(this.getX(), other.getX()) != 0) {
                return false;
            }
            if (Double.compare(this.getYStart(), other.getYStart()) != 0) {
                return false;
            }
            if (Double.compare(this.getYEnd(), other.getYEnd()) != 0) {
                return false;
            }
            return Double.compare(this.getLength(), other.getLength()) == 0;
        }

        protected boolean canEqual(Object other) {
            return other instanceof VerticalLine;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $x = Double.doubleToLongBits(this.getX());
            result = result * 59 + (int)($x >>> 32 ^ $x);
            long $yStart = Double.doubleToLongBits(this.getYStart());
            result = result * 59 + (int)($yStart >>> 32 ^ $yStart);
            long $yEnd = Double.doubleToLongBits(this.getYEnd());
            result = result * 59 + (int)($yEnd >>> 32 ^ $yEnd);
            long $length = Double.doubleToLongBits(this.getLength());
            result = result * 59 + (int)($length >>> 32 ^ $length);
            return result;
        }

        public String toString() {
            return "TableLine.VerticalLine(x=" + this.getX() + ", yStart=" + this.getYStart() + ", yEnd=" + this.getYEnd() + ", length=" + this.getLength() + ")";
        }

        public VerticalLine() {
        }
    }
}

