/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.icpac.core.pdfparser.arrange;

import com.jxdinfo.idp.icpac.core.pdfparser.pojo.ContentPojo;
import com.jxdinfo.idp.icpac.core.pdfparser.pojo.ExtractPojo;
import com.jxdinfo.idp.icpac.core.pdfparser.pojo.Tu;
import com.jxdinfo.idp.icpac.core.pdfparser.tools.SettingReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class PdfXml {
    private static String formContent(ContentPojo contentPojo, String indexStr) {
        Integer startIndex = Integer.parseInt(indexStr.split(":")[0]);
        Integer endIndex = Integer.parseInt(indexStr.split(":")[1]);
        return PdfXml.formContent(contentPojo, startIndex, endIndex);
    }

    private static String formContent(ContentPojo contentPojo, Integer startIndex, Integer endIndex) {
        if (startIndex < 0 || endIndex < 0 || endIndex - startIndex < 0) {
            return "";
        }
        List<ContentPojo.contentElement> outList = contentPojo.getOutList();
        StringBuilder sb = new StringBuilder();
        for (int i = startIndex.intValue(); i <= endIndex; ++i) {
            ContentPojo.contentElement p = outList.get(i);
            if (p.getElementType().equals("text") || p.getElementType().equals("title")) {
                sb.append("<p>");
                sb.append(p.getText().replaceAll("\n", ""));
                sb.append("</p>");
                sb.append("\n");
                continue;
            }
            if (!p.getElementType().equals("table")) continue;
            sb.append("<table border=\"1\">");
            List<ContentPojo.contentElement.InnerCell> cells = p.getCells();
            Map<Integer, List<ContentPojo.contentElement.InnerCell>> collect = cells.stream().collect(Collectors.groupingBy(ContentPojo.contentElement.InnerCell::getRow_index));
            collect.entrySet().stream().forEach(x -> {
                sb.append("<tr>").append("\n");
                List rowCells = (List)x.getValue();
                for (ContentPojo.contentElement.InnerCell innerCell : rowCells) {
                    Integer row_span = innerCell.getRow_span();
                    Integer col_span = innerCell.getCol_span();
                    sb.append(String.format(" <td colspan=\"%s\" rowspan=\"%s\">", col_span, row_span));
                    sb.append(innerCell.getText());
                    sb.append("</td>");
                }
                sb.append("</tr>").append("\n");
            });
            sb.append("</table>").append("\n").append("<br/>").append("\n");
        }
        return sb.toString();
    }

    public static List<Tu.Tuple2<String, String>> extract(Document doc, ContentPojo contentPojo, ExtractPojo extractPojo) {
        ArrayList<Tu.Tuple2<String, String>> resultList = new ArrayList<Tu.Tuple2<String, String>>();
        Element root = doc.getRootElement();
        List elements = root.elements();
        if (elements.size() == 0) {
            List<ContentPojo.contentElement> outList = contentPojo.getOutList();
            resultList.add(new Tu.Tuple2<String, String>("", PdfXml.formContent(contentPojo, 0, outList.size() - 1)));
            return resultList;
        }
        Element rootElement = doc.getRootElement();
        if (extractPojo == null) {
            extractPojo = SettingReader.getPdfExtract();
        }
        Integer depth = extractPojo.getDepth();
        PdfXml.search(resultList, new ArrayList<String>(), rootElement, 0, depth + 1, contentPojo);
        return resultList;
    }

    private static void search(List<Tu.Tuple2<String, String>> list, List<String> path, Element curE, int curDepth, int maxDepth, ContentPojo contentPojo) {
        block25: {
            String name;
            block27: {
                block26: {
                    block24: {
                        Integer endIndex;
                        Integer startIndex;
                        if (++curDepth > maxDepth) {
                            return;
                        }
                        name = curE.getName();
                        if (!name.equals("content")) break block24;
                        List nextElements = curE.elements();
                        for (Element element : nextElements) {
                            boolean b = PdfXml.verifyIfSplitTitle(contentPojo, element);
                            if (b) continue;
                            curDepth = maxDepth;
                            break;
                        }
                        Integer titleIndex = Integer.parseInt(curE.attribute("key").getValue());
                        String title = PdfXml.formContent(contentPojo, titleIndex, titleIndex);
                        String titlePrefix = contentPojo.getOutList().get(titleIndex).getTitlePrefix();
                        String titleBody = contentPojo.getOutList().get(titleIndex).getTitleBody();
                        title = title.replaceAll("\n", "").replaceAll("<p>", "").replaceAll("</p>", "");
                        String showTitle = titlePrefix + "&&" + titleBody;
                        String extraContent = "";
                        int threshold = 25;
                        if (title.length() >= threshold) {
                            int i;
                            char[] charArray = title.toCharArray();
                            for (i = 0; i < charArray.length && charArray[i] != '\u3002' && charArray[i] != ':' && charArray[i] != '\uff1a'; ++i) {
                            }
                            if (i <= charArray.length - 1 && i <= threshold) {
                                String tmpTitle = title;
                                title = title.substring(0, i + 1);
                                if (i + 1 <= tmpTitle.length() - 1) {
                                    extraContent = tmpTitle.substring(i + 1, tmpTitle.length());
                                }
                            }
                        }
                        if (!extraContent.equals("")) {
                            extraContent = "<p>" + extraContent + "</p>";
                        }
                        int threshold2 = 27;
                        if (showTitle.length() >= threshold2) {
                            int i;
                            char[] charArray = showTitle.toCharArray();
                            for (i = 0; i < charArray.length && charArray[i] != '\u3002' && charArray[i] != ':' && charArray[i] != '\uff1a'; ++i) {
                            }
                            if (i <= charArray.length - 1 && i <= threshold2) {
                                showTitle = showTitle.substring(0, i + 1);
                            }
                        }
                        String finalTitle = path.size() == 0 ? showTitle : String.join((CharSequence)"|", path) + "|" + showTitle;
                        if (curE.attribute("value") != null && curE.attribute("value").getValue() != null) {
                            String indexStr = curE.attribute("value").getValue();
                            if (curDepth != maxDepth) {
                                String content = extraContent + PdfXml.formContent(contentPojo, indexStr);
                                if (!PdfXml.verifyEmptyContent(content).booleanValue()) {
                                    list.add(new Tu.Tuple2<String, String>(finalTitle, content));
                                }
                            } else {
                                Integer startIndex2 = Integer.parseInt(indexStr.split(":")[0]);
                                Integer endIndex2 = PdfXml.findEndIndex(curE);
                                String content = extraContent + PdfXml.formContent(contentPojo, startIndex2, endIndex2);
                                if (!PdfXml.verifyEmptyContent(content).booleanValue()) {
                                    list.add(new Tu.Tuple2<String, String>(finalTitle, content));
                                }
                            }
                        } else if (extraContent.equals("")) {
                            String content;
                            if (curDepth == maxDepth && !PdfXml.verifyEmptyContent(content = PdfXml.formContent(contentPojo, startIndex = Integer.valueOf(titleIndex + 1), endIndex = PdfXml.findEndIndex(curE))).booleanValue()) {
                                list.add(new Tu.Tuple2<String, String>(finalTitle, PdfXml.formContent(contentPojo, startIndex, endIndex)));
                            }
                        } else if (curDepth != maxDepth) {
                            list.add(new Tu.Tuple2<String, String>(finalTitle, extraContent));
                        } else {
                            startIndex = titleIndex + 1;
                            endIndex = PdfXml.findEndIndex(curE);
                            list.add(new Tu.Tuple2<String, String>(finalTitle, extraContent + PdfXml.formContent(contentPojo, startIndex, endIndex)));
                        }
                        path.add(showTitle);
                        if (curDepth == maxDepth) break block25;
                        for (Element element : nextElements) {
                            PdfXml.search(list, new ArrayList<String>(path), element, curDepth, maxDepth, contentPojo);
                        }
                        break block25;
                    }
                    if (!name.equals("head")) break block26;
                    String indexStr = curE.attribute("value").getValue();
                    String content = PdfXml.formContent(contentPojo, indexStr);
                    if (PdfXml.verifyEmptyContent(content).booleanValue()) break block25;
                    list.add(new Tu.Tuple2<String, String>("\u5934\u90e8\u6587\u672c", PdfXml.formContent(contentPojo, indexStr)));
                    break block25;
                }
                if (!name.equals("tail")) break block27;
                String indexStr = curE.attribute("value").getValue();
                String content = PdfXml.formContent(contentPojo, indexStr);
                if (PdfXml.verifyEmptyContent(content).booleanValue()) break block25;
                list.add(new Tu.Tuple2<String, String>("\u5c3e\u90e8\u6587\u672c", PdfXml.formContent(contentPojo, indexStr)));
                break block25;
            }
            if (name.equals("root")) {
                List nextElements = curE.elements();
                for (Element element : nextElements) {
                    PdfXml.search(list, new ArrayList<String>(path), element, curDepth, maxDepth, contentPojo);
                }
            }
        }
    }

    public static Boolean verifyEmptyContent(String content) {
        if (content == null) {
            return true;
        }
        String s = content.replaceAll("<p>", "").replaceAll("</p>", "").replaceAll("\n", "");
        if (s.trim().equals("")) {
            return true;
        }
        return false;
    }

    public static boolean verifyHiddenLayer(Float level) {
        String s = (level + "").split("\\.")[1];
        return s.equals("5");
    }

    public static boolean verifyIfSplitTitle(ContentPojo contentPojo, Element curE) {
        String name = curE.getName();
        Float level = Float.valueOf(-1.0f);
        Attribute levelA = curE.attribute("level");
        if (levelA != null) {
            level = Float.valueOf(Float.parseFloat(levelA.getValue()));
        }
        if (name.equals("content")) {
            Integer titleIndex = Integer.parseInt(curE.attribute("key").getValue());
            String title = PdfXml.formContent(contentPojo, titleIndex, titleIndex);
            title = title.replaceAll("\n", "").replaceAll("<p>", "").replaceAll("</p>", "");
            String extraContent = "";
            if (!PdfXml.verifyHiddenLayer(level)) {
                int threshold = 25;
                if (title.length() >= threshold) {
                    int i;
                    char[] charArray = title.toCharArray();
                    for (i = 0; i < charArray.length && charArray[i] != '\u3002' && charArray[i] != ':' && charArray[i] != '\uff1a'; ++i) {
                    }
                    if (i <= charArray.length - 1 && i <= threshold) {
                        String tmpTitle = title;
                        title = title.substring(0, i + 1);
                        if (i + 1 <= charArray.length - 1) {
                            extraContent = tmpTitle.substring(i + 1, tmpTitle.length());
                        }
                    }
                }
                if (!extraContent.equals("")) {
                    extraContent = "<p>" + extraContent + "</p>";
                }
            } else {
                return true;
            }
            return title.length() < 25;
        }
        return true;
    }

    public static Document buildXml(ContentPojo contentPojo) {
        List<ContentPojo.contentElement> outList = contentPojo.getOutList();
        Float firstLevel = Float.valueOf(Float.MAX_VALUE);
        for (ContentPojo.contentElement t : outList) {
            String levelStr = t.getLevel();
            if (levelStr == null) continue;
            Float level = Float.valueOf(Float.parseFloat(levelStr));
            firstLevel = Float.valueOf(Math.min(firstLevel.floatValue(), level.floatValue()));
        }
        if (firstLevel.floatValue() == 2.1474836E9f) {
            return null;
        }
        Document doc = DocumentHelper.createDocument();
        Element root = doc.addElement("root");
        root.addAttribute("level", "0");
        int pos = 0;
        Element curE = null;
        Float curLevel = Float.valueOf(0.0f);
        boolean firstFind = false;
        while (pos != outList.size()) {
            ContentPojo.contentElement p = outList.get(pos);
            String element_type = p.getElementType();
            if (element_type.equals("text")) {
                ++pos;
                continue;
            }
            if (element_type.equals("title")) {
                Float level = Float.valueOf(Float.parseFloat(p.getLevel()));
                if (!firstFind) {
                    if (firstLevel.equals(level)) {
                        Element freeE = root.addElement("head");
                        freeE.addAttribute("value", "0:" + (pos - 1));
                        curE = root.addElement("content");
                        curE.addAttribute("level", level + "");
                        curE.addAttribute("key", pos + "");
                        curLevel = level;
                        firstFind = true;
                    }
                } else {
                    Integer titleIndex = Integer.parseInt(curE.attribute("key").getValue());
                    if (pos - titleIndex > 1) {
                        curE.addAttribute("value", titleIndex + 1 + ":" + (pos - 1));
                    }
                    if (level.floatValue() > curLevel.floatValue()) {
                        curE = curE.addElement("content");
                        curE.addAttribute("level", level + "");
                        curE.addAttribute("key", pos + "");
                        curLevel = level;
                    } else {
                        while (level.floatValue() <= curLevel.floatValue()) {
                            curE = curE.getParent();
                            curLevel = Float.valueOf(Float.parseFloat(curE.attribute("level").getValue()));
                        }
                        curE = curE.addElement("content");
                        curE.addAttribute("level", level + "");
                        curE.addAttribute("key", pos + "");
                        curLevel = level;
                    }
                }
            }
            ++pos;
        }
        if (curE != null) {
            int tailIndex = 0;
            Integer titleIndex = Integer.parseInt(curE.attribute("key").getValue());
            block3: for (int i = outList.size() - 1; i > titleIndex; --i) {
                ContentPojo.contentElement cur = outList.get(i);
                ContentPojo.contentElement pre = outList.get(i - 1);
                if (cur.getPageNumber().equals(pre.getPageNumber())) {
                    float curYEnd = cur.getYStart().floatValue() + cur.getHeight().floatValue();
                    float preYEnd = pre.getYStart().floatValue();
                    if (!(preYEnd - curYEnd > 60.0f)) continue;
                    if (cur.getElementType().equals("text")) {
                        tailIndex = i;
                    }
                    if (!cur.getElementType().equals("table")) break;
                    List<ContentPojo.contentElement.InnerCell> cells = cur.getCells();
                    for (ContentPojo.contentElement.InnerCell cell : cells) {
                        String text = cell.getText();
                        if (!text.contains("\u6284\u9001")) continue;
                        tailIndex = i;
                        break block3;
                    }
                } else {
                    float v = pre.getYStart().floatValue() + pre.getPageHeight().floatValue() - cur.getYStart().floatValue() - cur.getHeight().floatValue();
                    if (!(v > 60.0f)) continue;
                    if (cur.getElementType().equals("text")) {
                        tailIndex = i;
                    }
                    if (!cur.getElementType().equals("table")) break;
                    List<ContentPojo.contentElement.InnerCell> cells = cur.getCells();
                    for (ContentPojo.contentElement.InnerCell cell : cells) {
                        String text = cell.getText();
                        if (!text.contains("\u9001")) continue;
                        tailIndex = i;
                        break block3;
                    }
                }
                break;
            }
            if (tailIndex == 0) {
                if (pos - titleIndex > 1) {
                    curE.addAttribute("value", titleIndex + 1 + ":" + (pos - 1));
                }
            } else if (tailIndex - titleIndex >= 1) {
                curE.addAttribute("value", titleIndex + 1 + ":" + (tailIndex - 1));
                Element tailE = root.addElement("tail");
                tailE.addAttribute("value", tailIndex + ":" + (pos - 1));
            }
        }
        return doc;
    }

    private static Integer findEndIndex(Element curE) {
        List elements = curE.elements();
        if (elements.size() == 0) {
            Attribute value = curE.attribute("value");
            if (value != null) {
                return Integer.parseInt(value.getValue().split(":")[1]);
            }
            Attribute key = curE.attribute("key");
            return Integer.parseInt(key.getValue());
        }
        int curMax = 0;
        for (Element e : elements) {
            curMax = Math.max(curMax, PdfXml.findEndIndex(e));
        }
        return curMax;
    }
}

