/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.icpac.service.data;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.idp.duplicatecheck.api.entity.dto.DuplicateCheckResultDto;
import com.jxdinfo.idp.duplicatecheck.api.entity.dto.DuplicateCheckSentenceDto;
import com.jxdinfo.idp.duplicatecheck.api.entity.dto.DuplicateCheckSimilarSentenceDto;
import com.jxdinfo.idp.duplicatecheck.api.entity.query.DuplicateCheckResultQuery;
import com.jxdinfo.idp.duplicatecheck.api.entity.query.DuplicateCheckSentenceQuery;
import com.jxdinfo.idp.duplicatecheck.api.entity.query.DuplicateCheckSimilarSentenceQuery;
import com.jxdinfo.idp.icpac.entity.query.SentenceDataQuery;
import com.jxdinfo.idp.icpac.service.DuplicateCheckResultService;
import com.jxdinfo.idp.icpac.service.DuplicateCheckSentenceService;
import com.jxdinfo.idp.icpac.service.DuplicateCheckSimilarSentenceService;
import com.jxdinfo.idp.icpac.service.data.SentenceSelectData;
import java.util.Collections;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

@Component
public class DefaultSentenceSelectData
implements SentenceSelectData {
    @Resource
    private DuplicateCheckResultService resultService;
    @Resource
    private DuplicateCheckSentenceService sentenceService;
    @Resource
    private DuplicateCheckSimilarSentenceService similarSentenceService;

    @Override
    public Page<DuplicateCheckSentenceDto> getSentence(SentenceDataQuery query) {
        String resultId = this.getResultId(query);
        DuplicateCheckSentenceQuery sentenceQuery = new DuplicateCheckSentenceQuery();
        sentenceQuery.setDocId(query.getDocumentId());
        sentenceQuery.setResultId(resultId);
        sentenceQuery.setSimilarity(Double.valueOf(query.getSimilarity()));
        sentenceQuery.setCurrent(query.getCurrent());
        sentenceQuery.setSize(query.getSize());
        return this.sentenceService.getSentenceList(sentenceQuery);
    }

    @Override
    public Page<DuplicateCheckSentenceDto> getSentenceWithMaxSimiSentence(SentenceDataQuery query) {
        DuplicateCheckSentenceQuery sentenceQuery = new DuplicateCheckSentenceQuery();
        sentenceQuery.setDocId(query.getDocumentId());
        sentenceQuery.setPageFlag(query.isPageFlag());
        sentenceQuery.setCurrent(query.getCurrent());
        sentenceQuery.setSize(query.getSize());
        return this.sentenceService.getSentenceWithMaxSimiSentence(sentenceQuery);
    }

    @Override
    public Page<DuplicateCheckSimilarSentenceDto> getSimilaritySentence(SentenceDataQuery query) {
        String resultId = this.getResultId(query);
        DuplicateCheckSimilarSentenceQuery similarSentenceQuery = new DuplicateCheckSimilarSentenceQuery();
        similarSentenceQuery.setPageFlag(query.isPageFlag());
        similarSentenceQuery.setResultId(resultId);
        similarSentenceQuery.setSentenceId(query.getSentenceId());
        similarSentenceQuery.setSimilarity(Double.valueOf(query.getSimilarity()));
        similarSentenceQuery.setSize(query.getSize());
        similarSentenceQuery.setCurrent(query.getCurrent());
        return this.similarSentenceService.getSimilaritySentenceNoPage(similarSentenceQuery);
    }

    private String getResultId(SentenceDataQuery query) {
        String resultId = "";
        if (StringUtils.isNotEmpty((CharSequence)query.getSimilarDocId())) {
            DuplicateCheckResultQuery resultQuery = new DuplicateCheckResultQuery();
            resultQuery.setUploadDocIds(Collections.singletonList(query.getDocumentId()));
            resultQuery.setSimilarDocIds(Collections.singletonList(query.getSimilarDocId()));
            List<DuplicateCheckResultDto> resultDtoList = this.resultService.list(resultQuery);
            if (CollectionUtils.isEmpty(resultDtoList) || resultDtoList.size() > 2) {
                throw new RuntimeException(String.format("\u67e5\u8be2\u76f8\u4f3c\u6587\u6863\u7ed3\u679c\u9519\u8bef\uff0c\u4e0a\u4f20\u7684\u6587\u6863id\u4e3a\uff1a%s\uff0c\u5e93\u4e2d\u7684\u6587\u6863id\u4e3a\uff1a%s", query.getDocumentId(), query.getSimilarDocId()));
            }
            resultId = resultDtoList.get(0).getId();
        }
        return resultId;
    }
}

