/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.icpac.service.impl;

import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.jxdinfo.idp.duplicatecheck.api.entity.dto.DuplicateCheckSentenceDto;
import com.jxdinfo.idp.duplicatecheck.api.entity.dto.DuplicateCheckSimilarSentenceDto;
import com.jxdinfo.idp.duplicatecheck.api.entity.dto.GroupDuplicateCheckResponseDto;
import com.jxdinfo.idp.duplicatecheck.api.entity.dto.GroupDuplicateDocResponseDto;
import com.jxdinfo.idp.duplicatecheck.api.entity.dto.GroupDuplicateRequestDto;
import com.jxdinfo.idp.duplicatecheck.api.entity.dto.GroupQueryDto;
import com.jxdinfo.idp.duplicatecheck.api.entity.dto.SimilarGroupListDto;
import com.jxdinfo.idp.duplicatecheck.api.entity.dto.SimilarTextDto;
import com.jxdinfo.idp.duplicatecheck.api.entity.po.DuplicateCheckResult;
import com.jxdinfo.idp.duplicatecheck.api.entity.po.DuplicateCheckSentence;
import com.jxdinfo.idp.duplicatecheck.api.entity.query.DuplicateCheckSentenceQuery;
import com.jxdinfo.idp.duplicatecheck.api.entity.query.DuplicateCheckSimilarSentenceQuery;
import com.jxdinfo.idp.icpac.entity.query.DuplicateGroupQuery;
import com.jxdinfo.idp.icpac.mapper.DuplicateCheckResultMapper;
import com.jxdinfo.idp.icpac.mapper.DuplicateCheckSentenceMapper;
import com.jxdinfo.idp.icpac.service.DuplicateCheckResultService;
import com.jxdinfo.idp.icpac.service.DuplicateCheckSentenceService;
import com.jxdinfo.idp.icpac.service.DuplicateCheckSimilarSentenceService;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.ibatis.session.SqlSession;
import org.apache.ibatis.session.SqlSessionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class DuplicateCheckSentenceServiceImpl
extends ServiceImpl<DuplicateCheckSentenceMapper, DuplicateCheckSentence>
implements DuplicateCheckSentenceService {
    private static final Logger log = LoggerFactory.getLogger(DuplicateCheckSentenceServiceImpl.class);
    @Resource
    private DuplicateCheckSentenceMapper mapper;
    @Resource
    private DuplicateCheckSimilarSentenceService ssService;
    @Resource
    private SqlSessionFactory sqlSessionFactory;
    @Resource
    private DuplicateCheckResultMapper duplicateCheckResultMapper;
    @Resource
    private DuplicateCheckResultService duplicateCheckResultService;

    @Override
    public void saveBatch(List<DuplicateCheckSentenceDto> sentenceDtoList) {
        if (CollectionUtils.isEmpty(sentenceDtoList)) {
            return;
        }
        ArrayList<DuplicateCheckSimilarSentenceDto> similarSentenceList = new ArrayList<DuplicateCheckSimilarSentenceDto>();
        for (DuplicateCheckSentenceDto sentenceDto : sentenceDtoList) {
            similarSentenceList.addAll(sentenceDto.getSimilarSentenceList());
        }
        List baseResults = DuplicateCheckSentence.toEntity(sentenceDtoList);
        this.insertBatch(baseResults);
        this.ssService.saveBatch(similarSentenceList);
    }

    private void insertBatch(List<DuplicateCheckSentence> baseResults) {
        long startTime = System.currentTimeMillis();
        String prefix = "SELECT 1";
        SqlSession sqlSession = null;
        Connection connection = null;
        Statement statement = null;
        int size = baseResults.size();
        int commitSize = 3000;
        int commitCount = size / commitSize + 1;
        try {
            sqlSession = this.sqlSessionFactory.openSession();
            connection = sqlSession.getConnection();
            connection.setAutoCommit(false);
            statement = connection.prepareStatement(prefix);
            int index = 0;
            for (int i = 0; i < commitCount; ++i) {
                StringBuilder sql = new StringBuilder("INSERT INTO idp_icpac_duplicate_check_sentence (id, doc_id, sentence,location,sentence_index,file_name,ignore_flag,belong_chapter) values");
                int baseSqlLen = sql.length();
                int newCommitSize = commitSize * (i + 1);
                while (index < size && index < newCommitSize) {
                    DuplicateCheckSentence checkSentence = baseResults.get(index);
                    String sentence = checkSentence.getSentence();
                    if (sentence.contains("'")) {
                        sentence = sentence.replaceAll("'", "\\\\'");
                    }
                    sql.append("('").append(checkSentence.getId()).append("','").append(checkSentence.getDocId()).append("','").append(sentence).append("','").append(checkSentence.getLocation()).append("','").append(checkSentence.getSentenceIndex()).append("','").append(checkSentence.getFileName()).append("','").append(checkSentence.getIgnoreFlag()).append("','").append(checkSentence.getBelongChapter()).append("'),");
                    ++index;
                }
                if (sql.length() <= baseSqlLen) continue;
                statement.addBatch(sql.substring(0, sql.lastIndexOf(",")));
                statement.executeBatch();
                statement.clearBatch();
                connection.commit();
            }
        }
        catch (SQLException e) {
            log.error("\u63d2\u5165\u51fa\u9519,", (Throwable)e);
            throw new RuntimeException(e);
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException sQLException) {}
            }
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException sQLException) {}
            }
            if (sqlSession != null) {
                sqlSession.close();
            }
            log.info("\u63d2\u5165\u7ed3\u675f,\u8017\u8d39\u65f6\u95f4\uff1a{}", (Object)((System.currentTimeMillis() - startTime) / 1000L));
        }
    }

    @Override
    public List<String> deleteByDocIds(List<String> docIds) {
        if (CollectionUtils.isEmpty(docIds)) {
            return new ArrayList<String>();
        }
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.in(DuplicateCheckSentence::getDocId, docIds);
        List sentenceList = this.list((Wrapper)wrapper);
        List<String> ids = sentenceList.stream().map(DuplicateCheckSentence::getId).collect(Collectors.toList());
        this.removeByIds(ids);
        return ids;
    }

    @Override
    public Page<DuplicateCheckSentenceDto> getSentenceList(DuplicateCheckSentenceQuery query) {
        if (query.isPageFlag()) {
            Page page = query.getPage(DuplicateCheckSentenceDto.class);
            List<DuplicateCheckSentenceDto> list = this.mapper.getSentenceList(query, (Page<DuplicateCheckSentenceDto>)page);
            page.setRecords(list);
            return page;
        }
        Page page = new Page();
        List<DuplicateCheckSentenceDto> list = this.mapper.getSentenceList(query, null);
        page.setRecords(list);
        page.setTotal((long)list.size());
        return page;
    }

    @Override
    public Page<DuplicateCheckSentenceDto> getSentenceListWithTopn(DuplicateCheckSentenceQuery query) {
        if (query.isPageFlag()) {
            Page page = query.getPage(DuplicateCheckSentenceDto.class);
            List<DuplicateCheckSentenceDto> list = this.mapper.getSentenceListWithTopN(query, (Page<DuplicateCheckSentenceDto>)page);
            page.setRecords(list);
            return page;
        }
        Page page = new Page();
        List<DuplicateCheckSentenceDto> list = this.mapper.getSentenceListWithTopN(query, null);
        page.setRecords(list);
        page.setSize((long)list.size());
        return page;
    }

    @Override
    public List<GroupDuplicateCheckResponseDto> getSimilarityWithGroup(GroupDuplicateRequestDto requestDto) {
        DuplicateGroupQuery query = new DuplicateGroupQuery(requestDto);
        List<DuplicateCheckSentenceDto> list = this.mapper.getSimilarityWithGroup(query);
        List results = this.duplicateCheckResultService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(DuplicateCheckResult::getUploadDocId, query.getDocIds())).or()).in(DuplicateCheckResult::getSimilarDocId, query.getDocIds()));
        return this.handleSentenceList(this.handleResult(requestDto, list, results), requestDto.getTopm());
    }

    private List<GroupDuplicateCheckResponseDto> handleSentenceList(List<GroupDuplicateCheckResponseDto> list, int topm) {
        if (topm < 1) {
            topm = 3;
        }
        int finalTopm = topm;
        list.stream().forEach(s -> {
            s.setMaxSimilarity(Double.valueOf(s.getSimilarGroupMap().values().stream().mapToDouble(SimilarGroupListDto::similarityDouble).max().orElse(0.0)));
            s.setSimilarGroupList(s.getSimilarGroupMap().values().stream().sorted(Comparator.comparing(SimilarGroupListDto::similarityDouble).reversed()).limit(finalTopm).collect(Collectors.toList()));
        });
        return list;
    }

    private List<GroupDuplicateCheckResponseDto> handleResult(GroupDuplicateRequestDto requestDto, List<DuplicateCheckSentenceDto> sentenceList, List<DuplicateCheckResult> results) {
        Map map = GroupDuplicateCheckResponseDto.initList((GroupDuplicateRequestDto)requestDto);
        if (ObjectUtil.isNotNull((Object)requestDto.getGroupQueryDtoList())) {
            this.handleSentenceList(requestDto.getGroupQueryDtoList(), sentenceList, map, this.getDocIdSimilarityMap(results));
        }
        return map.values().stream().collect(Collectors.toList());
    }

    private Map<String, Map<String, Double>> getDocIdSimilarityMap(List<DuplicateCheckResult> results) {
        HashMap<String, Map<String, Double>> docIdSimilarityMap = new HashMap<String, Map<String, Double>>();
        results.stream().forEach(r -> {
            Map map = docIdSimilarityMap.computeIfAbsent(r.getUploadDocId(), k -> new HashMap());
            map.put(r.getSimilarDocId(), r.getSimilarity());
            Map maps = docIdSimilarityMap.computeIfAbsent(r.getSimilarDocId(), k -> new HashMap());
            maps.put(r.getUploadDocId(), r.getSimilarity());
        });
        return docIdSimilarityMap;
    }

    private Map<String, String> getDocIdGroupIdMap(List<GroupQueryDto> groupQueryDtoList) {
        HashMap<String, String> map = new HashMap<String, String>();
        groupQueryDtoList.stream().forEach(g -> {
            if (ObjectUtil.isNotNull((Object)g.getDocIds())) {
                g.getDocIds().stream().forEach(d -> map.put((String)d, g.getGroupId()));
            }
        });
        return map;
    }

    private void handleSentenceList(List<GroupQueryDto> groupQueryDtoList, List<DuplicateCheckSentenceDto> sentenceList, Map<String, GroupDuplicateCheckResponseDto> map, Map<String, Map<String, Double>> docIdSimilarityMap) {
        Map<String, String> docIdGroupIdMap = this.getDocIdGroupIdMap(groupQueryDtoList);
        sentenceList.stream().forEach(s -> {
            String groupId = (String)docIdGroupIdMap.get(s.getDocId());
            GroupDuplicateCheckResponseDto groupDuplicateCheckResponseDto = (GroupDuplicateCheckResponseDto)map.get(groupId);
            groupDuplicateCheckResponseDto.getSimilarSentenceList().add(new SimilarTextDto(s));
            GroupDuplicateDocResponseDto doc = groupDuplicateCheckResponseDto.getDocMap().computeIfAbsent(s.getDocId(), k -> new GroupDuplicateDocResponseDto(s.getDocId(), s.getAttachment(), new Double(0.0), null, new ArrayList()));
            doc.getSimilarSentenceList().add(new SimilarTextDto(s));
            doc.toMaxSimilarity(s.getSimilarity(), s.getSimilarDocId());
            String similarDocId = s.getSimilarDocId();
            String similarGroupId = (String)docIdGroupIdMap.get(similarDocId);
            if (ObjectUtil.isNotNull((Object)similarGroupId) && !groupId.equals(similarGroupId)) {
                SimilarGroupListDto similarGroupListDto = groupDuplicateCheckResponseDto.getSimilarGroupMap().computeIfAbsent(similarGroupId, k -> new SimilarGroupListDto(similarGroupId));
                similarGroupListDto.getSimilarTextList().add(new SimilarTextDto(s));
                similarGroupListDto.addSimilarity((Double)((Map)docIdSimilarityMap.get(s.getDocId())).get(similarDocId), similarDocId);
            }
        });
    }

    @Override
    public DuplicateCheckSentence updateIgnoreSentence(String sentenceId, String ingoreFlag) {
        DuplicateCheckSentence sentence = new DuplicateCheckSentence();
        sentence.setIgnoreFlag(ingoreFlag);
        sentence.setId(sentenceId);
        this.updateById(sentence);
        return (DuplicateCheckSentence)this.getById((Serializable)((Object)sentenceId));
    }

    @Override
    public Page<DuplicateCheckSentenceDto> getSentenceWithMaxSimiSentence(DuplicateCheckSentenceQuery sentenceQuery) {
        Page<DuplicateCheckSentenceDto> page = this.getSentenceList(sentenceQuery);
        List sentenceList = page.getRecords();
        if (CollectionUtils.isEmpty((Collection)sentenceList)) {
            return page;
        }
        this.getMaxSimilaritySentence(sentenceList, sentenceQuery.getResultIdList());
        return page;
    }

    private void getMaxSimilaritySentence(List<DuplicateCheckSentenceDto> sentenceList, List<String> resultIdList) {
        ArrayList<String> sentenceIdList = new ArrayList<String>();
        HashMap<String, DuplicateCheckSentenceDto> idObjMap = new HashMap<String, DuplicateCheckSentenceDto>();
        for (DuplicateCheckSentenceDto sentenceDto : sentenceList) {
            sentenceIdList.add(sentenceDto.getId());
            idObjMap.put(sentenceDto.getId(), sentenceDto);
        }
        DuplicateCheckSimilarSentenceQuery similarSentenceQuery = new DuplicateCheckSimilarSentenceQuery();
        similarSentenceQuery.setSentenceIds(sentenceIdList);
        similarSentenceQuery.setResultIdList(resultIdList);
        List<DuplicateCheckSimilarSentenceDto> similarSentenceList = this.ssService.getMaxSimilaritySentence(similarSentenceQuery);
        for (DuplicateCheckSimilarSentenceDto similarSentenceDto : similarSentenceList) {
            String sentenceId = similarSentenceDto.getSentenceId();
            DuplicateCheckSentenceDto sentence = (DuplicateCheckSentenceDto)idObjMap.get(sentenceId);
            if (sentence == null || sentence.getSimilarSentenceList().size() != 0) continue;
            sentence.addSimilarSentence(similarSentenceDto);
        }
    }
}

