/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.icpac.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.jxdinfo.idp.common.util.SnowFlakeUtil;
import com.jxdinfo.idp.common.util.user.UserUtils;
import com.jxdinfo.idp.duplicatecheck.api.entity.dto.DuplicateCheckChapterDto;
import com.jxdinfo.idp.duplicatecheck.api.entity.dto.DuplicateCheckProjectDto;
import com.jxdinfo.idp.duplicatecheck.api.entity.po.DuplicateCheckProject;
import com.jxdinfo.idp.duplicatecheck.api.entity.query.DuplicateCheckProjectQuery;
import com.jxdinfo.idp.icpac.listen.baseinfo.DuplicateCheckProjectChain;
import com.jxdinfo.idp.icpac.listen.event.DuplicateCheckEvent;
import com.jxdinfo.idp.icpac.listen.event.MultiSimilarityEventType;
import com.jxdinfo.idp.icpac.mapper.DuplicateCheckProjectMapper;
import com.jxdinfo.idp.icpac.paramconfig.DefaultParamConfig;
import com.jxdinfo.idp.icpac.service.DuplicateCheckChapterService;
import com.jxdinfo.idp.icpac.service.DuplicateCheckProjectService;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class DuplicateCheckProjectServiceImpl
extends ServiceImpl<DuplicateCheckProjectMapper, DuplicateCheckProject>
implements DuplicateCheckProjectService {
    private static final String TMP_PROJECT_NAME = "tmp_duplicate_document_lib";
    private static final String SPECIAL_CHAPTER = "1";
    private static final String NO_SPECIAL_CHAPTER = "0";
    @Resource
    private DuplicateCheckProjectMapper mapper;
    @Resource
    private DuplicateCheckChapterService duplicateCheckChapterService;

    @Override
    public DuplicateCheckProjectDto insertOrUpdate(DuplicateCheckProjectDto baseInfoDto) {
        if (CollectionUtils.isEmpty((Collection)baseInfoDto.getChapterList())) {
            baseInfoDto.setSpecialChapter(NO_SPECIAL_CHAPTER);
        }
        if (StringUtils.isEmpty((CharSequence)baseInfoDto.getId())) {
            return this.insert(baseInfoDto);
        }
        return this.update(baseInfoDto);
    }

    @Override
    public List<DuplicateCheckProjectDto> listDocLibrary(DuplicateCheckProjectQuery projectQuery) {
        return this.listNoPage(projectQuery);
    }

    @Override
    public Boolean delete(List<String> ids) {
        this.removeByIds(ids);
        DuplicateCheckProjectChain.publish(new DuplicateCheckEvent(ids, MultiSimilarityEventType.DELETE));
        return true;
    }

    @Override
    public Page<? extends DuplicateCheckProject> list(DuplicateCheckProjectQuery query) {
        Page page = query.getPage(DuplicateCheckProjectDto.class);
        List<DuplicateCheckProjectDto> list = this.mapper.list(query, (Page<DuplicateCheckProjectDto>)page);
        page.setRecords(list);
        return page;
    }

    @Override
    public List<DuplicateCheckProjectDto> listNoPage(DuplicateCheckProjectQuery query) {
        return this.mapper.list(query, null);
    }

    @Override
    public DuplicateCheckProjectDto detail(String id) {
        return DuplicateCheckProjectDto.toDto((DuplicateCheckProject)((DuplicateCheckProject)this.getById((Serializable)((Object)id))));
    }

    @Override
    public DuplicateCheckProjectDto detailWithConfigInfo(String id) {
        DuplicateCheckProjectDto projectDto = this.detail(id);
        if (Objects.equals(projectDto.getSpecialChapter(), NO_SPECIAL_CHAPTER)) {
            return projectDto;
        }
        List<DuplicateCheckChapterDto> chapterDtoList = this.duplicateCheckChapterService.getByProjectId(id);
        if (chapterDtoList != null && !chapterDtoList.isEmpty()) {
            projectDto.setChapterList(chapterDtoList);
        }
        return projectDto;
    }

    private DuplicateCheckProjectDto insert(DuplicateCheckProjectDto projectDto) {
        if (StringUtils.isEmpty((CharSequence)projectDto.getProjectName())) {
            projectDto.setProjectName(TMP_PROJECT_NAME);
        }
        if (projectDto.getWordLength() == null) {
            projectDto.setWordLength(Integer.valueOf(10));
        }
        if (projectDto.getSimilarityBounds() == null) {
            projectDto.setSimilarityBounds(Double.valueOf(DefaultParamConfig.defaultSimilarity));
        }
        projectDto.setCreator(String.valueOf(UserUtils.getLoginUserId()));
        projectDto.setCreateTime(LocalDateTime.now());
        projectDto.setUpdateTime(LocalDateTime.now());
        projectDto.setId(String.valueOf(SnowFlakeUtil.getFlowIdInstance().nextId()));
        this.duplicateCheckChapterService.insert(projectDto.getChapterList(), projectDto.getId());
        this.save(DuplicateCheckProject.toEntity((DuplicateCheckProject)projectDto));
        return projectDto;
    }

    private DuplicateCheckProjectDto update(DuplicateCheckProjectDto projectDto) {
        if (StringUtils.isEmpty((CharSequence)projectDto.getProjectName())) {
            projectDto.setProjectName(TMP_PROJECT_NAME);
        }
        projectDto.setUpdateTime(LocalDateTime.now());
        this.duplicateCheckChapterService.update(projectDto.getChapterList(), projectDto.getId(), null);
        this.updateById(DuplicateCheckProject.toEntity((DuplicateCheckProject)projectDto));
        return projectDto;
    }

    @Override
    public List<DuplicateCheckProjectDto> getTmpDocumentLib() {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(DuplicateCheckProject::getProjectName, (Object)TMP_PROJECT_NAME);
        return DuplicateCheckProjectDto.toDto((List)this.list((Wrapper)wrapper));
    }

    @Override
    public List<DuplicateCheckProject> uniqueName(DuplicateCheckProjectDto projectInfo) {
        if (projectInfo == null || StringUtils.isEmpty((CharSequence)projectInfo.getProjectName())) {
            return new ArrayList<DuplicateCheckProject>();
        }
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)wrapper.eq(DuplicateCheckProject::getProjectName, (Object)projectInfo.getProjectName())).ne(DuplicateCheckProject::getId, (Object)projectInfo.getId());
        return this.list((Wrapper)wrapper);
    }
}

