/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.icpac.api;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.idp.duplicatecheck.api.entity.dto.DuplicateCheckDocDto;
import com.jxdinfo.idp.duplicatecheck.api.entity.dto.DuplicateCheckResultDto;
import com.jxdinfo.idp.duplicatecheck.api.entity.dto.DuplicateCheckSentenceDto;
import com.jxdinfo.idp.duplicatecheck.api.entity.dto.DuplicateCheckSimilarSentenceDto;
import com.jxdinfo.idp.duplicatecheck.api.entity.dto.DuplicateCheckSimilarityInfo;
import com.jxdinfo.idp.duplicatecheck.api.entity.dto.GroupDuplicateCheckResponseDto;
import com.jxdinfo.idp.duplicatecheck.api.entity.dto.GroupDuplicateRequestDto;
import com.jxdinfo.idp.duplicatecheck.api.entity.po.DuplicateCheckResult;
import com.jxdinfo.idp.duplicatecheck.api.entity.query.DuplicateCheckDocQuery;
import com.jxdinfo.idp.duplicatecheck.api.entity.query.DuplicateCheckResultQuery;
import com.jxdinfo.idp.duplicatecheck.api.entity.query.DuplicateCheckSentenceQuery;
import com.jxdinfo.idp.duplicatecheck.api.entity.query.DuplicateCheckSimilarSentenceQuery;
import com.jxdinfo.idp.duplicatecheck.api.entity.query.DuplicateCheckSimilarityInfoQuery;
import com.jxdinfo.idp.duplicatecheck.api.entity.query.SentenceQuery;
import com.jxdinfo.idp.duplicatecheck.api.service.IDuplicateCheckDataService;
import com.jxdinfo.idp.icpac.service.DuplicateCheckDocService;
import com.jxdinfo.idp.icpac.service.DuplicateCheckResultService;
import com.jxdinfo.idp.icpac.service.DuplicateCheckSentenceService;
import com.jxdinfo.idp.icpac.service.DuplicateCheckSimilarSentenceService;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Component;

@Component
@Primary
public class IDuplicateCheckDataServiceImpl
implements IDuplicateCheckDataService {
    @Resource
    private DuplicateCheckSentenceService sentenceService;
    @Resource
    private DuplicateCheckDocService docService;
    @Resource
    private DuplicateCheckSentenceService duplicateCheckSentenceService;
    @Resource
    private DuplicateCheckResultService resultService;
    @Resource
    private DuplicateCheckSimilarSentenceService similarSentenceService;

    public DuplicateCheckSimilarityInfo getSimilarityInfo(DuplicateCheckSimilarityInfoQuery checkInfoQuery) {
        String documentId = checkInfoQuery.getDocumentId();
        if (StringUtils.isEmpty((CharSequence)documentId)) {
            return new DuplicateCheckSimilarityInfo();
        }
        DuplicateCheckSimilarityInfo similarityInfo = new DuplicateCheckSimilarityInfo();
        DuplicateCheckDocDto detail = this.docService.detail(documentId);
        similarityInfo.setMaxSimilarity(detail.getMaxSimilarity());
        similarityInfo.setDocSimilarity(detail.getDocSimilarity());
        similarityInfo.setCandidateSentenceNum(detail.getCandidateSentenceNum());
        List resultList = detail.getResultList();
        if (CollectionUtils.isEmpty((Collection)resultList)) {
            similarityInfo.setRepeatDocCount(0);
        } else {
            similarityInfo.setRepeatDocCount(resultList.size());
        }
        DuplicateCheckSentenceQuery sentenceDataQuery = new DuplicateCheckSentenceQuery();
        sentenceDataQuery.setDocumentId(documentId);
        sentenceDataQuery.setIgnoreFlag("0");
        sentenceDataQuery.setPageFlag(false);
        Page<DuplicateCheckSentenceDto> sentencePage = this.sentenceService.getSentenceList(sentenceDataQuery);
        List records = sentencePage.getRecords();
        similarityInfo.setIgnoreSentenceCount(records == null ? 0 : records.size());
        sentenceDataQuery = new DuplicateCheckSentenceQuery();
        sentenceDataQuery.setDocumentId(documentId);
        sentenceDataQuery.setSimilarity(Double.valueOf(checkInfoQuery.getSimilarity()));
        sentenceDataQuery.setIgnoreFlag("1");
        sentenceDataQuery.setPageFlag(false);
        List sentenceList = this.sentenceService.getSentenceList(sentenceDataQuery).getRecords();
        sentenceList = CollectionUtils.isEmpty((Collection)sentenceList) ? Collections.emptyList() : sentenceList;
        similarityInfo.setLe80PreCount(sentenceList.size());
        similarityInfo.setLe80PreProportion(sentenceList.size() + "/" + detail.getCandidateSentenceNum());
        return similarityInfo;
    }

    private List<String> getResultIdList(SentenceQuery query) {
        List resultIdList = null;
        List similarDocIdList = query.getSimilarDocIdList();
        if (CollectionUtils.isNotEmpty((Collection)similarDocIdList)) {
            DuplicateCheckResultQuery resultQuery = new DuplicateCheckResultQuery();
            resultQuery.setUploadDocIds(Collections.singletonList(query.getDocumentId()));
            resultQuery.setSimilarDocIds(similarDocIdList);
            List<DuplicateCheckResultDto> resultDtoList = this.resultService.list(resultQuery);
            if (CollectionUtils.isEmpty(resultDtoList)) {
                throw new RuntimeException(String.format("\u67e5\u8be2\u76f8\u4f3c\u6587\u6863\u7ed3\u679c\u9519\u8bef\uff0c\u4e0a\u4f20\u7684\u6587\u6863id\u4e3a\uff1a%s\uff0c\u5e93\u4e2d\u7684\u6587\u6863id\u4e3a\uff1a%s", query.getDocumentId(), query.getSimilarDocIdList()));
            }
            resultIdList = resultDtoList.stream().map(DuplicateCheckResult::getId).collect(Collectors.toList());
        }
        return resultIdList;
    }

    public Page<DuplicateCheckSentenceDto> getSentence(SentenceQuery sentenceQuery) {
        DuplicateCheckSentenceQuery sentenceDataQuery = new DuplicateCheckSentenceQuery();
        sentenceDataQuery.setDocumentId(sentenceQuery.getDocumentId());
        sentenceDataQuery.setSimilarity(sentenceQuery.getSimilarity());
        sentenceDataQuery.setResultIdList(this.getResultIdList(sentenceQuery));
        sentenceDataQuery.setIgnoreFlag(sentenceQuery.getIgnoreFlag());
        sentenceDataQuery.setPageFlag(sentenceQuery.isPageFlag());
        sentenceDataQuery.setCurrent(sentenceQuery.getCurrent());
        sentenceDataQuery.setSize(sentenceQuery.getSize());
        return this.sentenceService.getSentenceList(sentenceDataQuery);
    }

    public Page<DuplicateCheckSentenceDto> getSimilaritySentenceWithTopn(SentenceQuery sentenceQuery) {
        DuplicateCheckSentenceQuery sentenceDataQuery = new DuplicateCheckSentenceQuery();
        sentenceDataQuery.setDocumentId(sentenceQuery.getDocumentId());
        sentenceDataQuery.setSimilarity(sentenceQuery.getSimilarity());
        sentenceDataQuery.setResultIdList(this.getResultIdList(sentenceQuery));
        sentenceDataQuery.setPageFlag(sentenceQuery.isPageFlag());
        sentenceDataQuery.setCurrent(sentenceQuery.getCurrent());
        sentenceDataQuery.setSize(sentenceQuery.getSize());
        sentenceDataQuery.setTopN(sentenceQuery.getTopN());
        sentenceDataQuery.setDocumentIdList(sentenceQuery.getDocumentIds());
        sentenceDataQuery.setIgnoreFlag(sentenceQuery.getIgnoreFlag());
        return this.sentenceService.getSentenceListWithTopn(sentenceDataQuery);
    }

    public List<GroupDuplicateCheckResponseDto> getSimilarityWithGroup(GroupDuplicateRequestDto requestDto) {
        return this.duplicateCheckSentenceService.getSimilarityWithGroup(requestDto);
    }

    public Page<DuplicateCheckSentenceDto> getSentenceWithMaxSimiSentence(SentenceQuery sentenceQuery) {
        DuplicateCheckSentenceQuery sentenceDataQuery = new DuplicateCheckSentenceQuery();
        sentenceDataQuery.setDocumentId(sentenceQuery.getDocumentId());
        sentenceDataQuery.setSimilarity(sentenceQuery.getSimilarity());
        sentenceDataQuery.setResultIdList(this.getResultIdList(sentenceQuery));
        sentenceDataQuery.setIgnoreFlag(sentenceQuery.getIgnoreFlag());
        sentenceDataQuery.setPageFlag(sentenceQuery.isPageFlag());
        sentenceDataQuery.setCurrent(sentenceQuery.getCurrent());
        sentenceDataQuery.setSize(sentenceQuery.getSize());
        return this.sentenceService.getSentenceWithMaxSimiSentence(sentenceDataQuery);
    }

    public Page<DuplicateCheckResultDto> getSimilarityDocument(DuplicateCheckDocQuery docQuery) {
        List<DuplicateCheckResultDto> resultList = this.resultService.getSimilarityDoc(docQuery.getDocumentId());
        Page page = new Page();
        page.setRecords(resultList);
        page.setTotal((long)resultList.size());
        return page;
    }

    public Page<DuplicateCheckSimilarSentenceDto> getSimilaritySentence(SentenceQuery sentenceQuery) {
        DuplicateCheckSimilarSentenceQuery ssQuery = new DuplicateCheckSimilarSentenceQuery();
        ssQuery.setSentenceId(sentenceQuery.getSentenceId());
        ssQuery.setSimilarity(sentenceQuery.getSimilarity());
        List<String> resultIdList = this.getResultIdList(sentenceQuery);
        ssQuery.setResultIdList(resultIdList);
        ssQuery.setPageFlag(sentenceQuery.isPageFlag());
        ssQuery.setCurrent(sentenceQuery.getCurrent());
        ssQuery.setSize(sentenceQuery.getSize());
        return this.similarSentenceService.getSimilaritySentence(ssQuery);
    }
}

