/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.icpac.service.impl;

import cn.hutool.core.util.IdUtil;
import com.jxdinfo.idp.common.base.dto.FileBytesInfo;
import com.jxdinfo.idp.common.exception.BusinessException;
import com.jxdinfo.idp.common.util.DoubleUtils;
import com.jxdinfo.idp.common.util.StringUtils;
import com.jxdinfo.idp.dio.service.DocInfoIoService;
import com.jxdinfo.idp.docmanger.file.dto.DocumentUploadRequestDto;
import com.jxdinfo.idp.docmanger.file.dto.UploadDocumentResponseDto;
import com.jxdinfo.idp.docmanger.file.service.IDPDocMangerFileService;
import com.jxdinfo.idp.duplicatecheck.api.entity.dto.DuplicateCheckDocDto;
import com.jxdinfo.idp.duplicatecheck.api.entity.dto.DuplicateCheckDocument;
import com.jxdinfo.idp.duplicatecheck.api.entity.dto.DuplicateCheckDocumentCollection;
import com.jxdinfo.idp.duplicatecheck.api.entity.dto.DuplicateCheckDocumentGroup;
import com.jxdinfo.idp.duplicatecheck.api.entity.dto.DuplicateCheckRequestDto;
import com.jxdinfo.idp.duplicatecheck.api.entity.po.DuplicateCheckDoc;
import com.jxdinfo.idp.icpac.core.info.DuplicateCheckExecuteModelEnum;
import com.jxdinfo.idp.icpac.service.DuplicateCheckDocService;
import com.jxdinfo.idp.icpac.service.DuplicateCheckExecutorService;
import com.jxdinfo.idp.icpac.service.DuplicateCheckMonitorService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.mock.web.MockMultipartFile;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class DuplicateCheckMonitorServiceImpl
implements DuplicateCheckMonitorService {
    private static final Logger log = LoggerFactory.getLogger(DuplicateCheckMonitorServiceImpl.class);
    protected static final long B = 1024L;
    protected static final int KB = 0x100000;
    @Resource
    private DuplicateCheckExecutorService executorService;
    @Resource
    private DuplicateCheckDocService docService;
    @Resource
    private DocInfoIoService ioService;
    @Resource
    private IDPDocMangerFileService fileService;

    @Override
    public List<DuplicateCheckDocDto> initLibDocument(DuplicateCheckDocumentCollection documentCollection) throws Exception {
        List pendingInfoList = documentCollection.getPendingInfoList();
        if (CollectionUtils.isEmpty((Collection)pendingInfoList)) {
            return new ArrayList<DuplicateCheckDocDto>();
        }
        Iterator pendingInfoIter = pendingInfoList.iterator();
        while (pendingInfoIter.hasNext()) {
            DuplicateCheckDocument pendingInfo = (DuplicateCheckDocument)pendingInfoIter.next();
            Long fileId = pendingInfo.getFileId();
            MultipartFile file = pendingInfo.getFile();
            String text = pendingInfo.getText();
            if (fileId != null) {
                MultipartFile transToFile = this.fileIdTransToFile(fileId);
                if (transToFile == null) {
                    pendingInfoIter.remove();
                }
                pendingInfo.setFile(transToFile);
                continue;
            }
            if (file != null) {
                Long saveFileId = this.saveFileInfo(file);
                if (saveFileId == null) {
                    pendingInfoIter.remove();
                }
                pendingInfo.setFileId(fileId);
                continue;
            }
            if (StringUtils.isNotEmpty((String)text)) {
                String textFilename = IdUtil.simpleUUID() + ".txt";
                MockMultipartFile textFile = new MockMultipartFile(textFilename, textFilename, null, text.getBytes());
                pendingInfo.setFile((MultipartFile)textFile);
                Long saveFileId = this.saveFileInfo((MultipartFile)textFile);
                if (saveFileId == null) {
                    pendingInfoIter.remove();
                }
                pendingInfo.setFileId(fileId);
                continue;
            }
            pendingInfoIter.remove();
        }
        return this.saveDocInfoToCheckDuplicateLib(documentCollection);
    }

    private Long saveFileInfo(MultipartFile file) {
        DocumentUploadRequestDto du = new DocumentUploadRequestDto();
        du.setFile(file);
        UploadDocumentResponseDto response = this.fileService.uploadDocument(du);
        Boolean status = response.getStatus();
        if (status != null && status.booleanValue()) {
            return response.getDocumentId();
        }
        log.error("\u5f53\u524d\u6587\u4ef6\u4fdd\u5b58\u5931\u8d25\uff0c\u4fdd\u5b58\u7684\u6587\u4ef6\u4e3a\uff1a{}\uff1b\u5931\u8d25\u539f\u56e0\u4e3a\uff1a" + file.getOriginalFilename(), (Object)response.getErrorMessage());
        return null;
    }

    private List<DuplicateCheckDocDto> saveDocInfoToCheckDuplicateLib(DuplicateCheckDocumentCollection duplicateCheckDocument) {
        ArrayList<DuplicateCheckDocDto> docInfoList = new ArrayList<DuplicateCheckDocDto>();
        List pendingInfoList = duplicateCheckDocument.getPendingInfoList();
        String projectId = duplicateCheckDocument.getProjectId();
        for (DuplicateCheckDocument pendingInfo : pendingInfoList) {
            DuplicateCheckDocDto docInfo = new DuplicateCheckDocDto();
            docInfo.setProjectId(projectId);
            docInfo.setFileId(pendingInfo.getFileId());
            docInfo.setUpdateLib(pendingInfo.getUpdateLib());
            docInfo.setAttachment(pendingInfo.getAttachment());
            this.cacFileSize(pendingInfo.getFile(), (DuplicateCheckDoc)docInfo);
            docInfo.setFileName(pendingInfo.getFile().getOriginalFilename());
            docInfoList.add(docInfo);
        }
        return this.docService.saveDocInfo(docInfoList);
    }

    public void cacFileSize(MultipartFile file, DuplicateCheckDoc doc) {
        double size = file.getSize();
        if (size < 1024.0) {
            doc.setFileSize(String.valueOf(size));
            doc.setFileUnit("B");
        } else if (size < 1048576.0) {
            doc.setFileSize(String.valueOf(DoubleUtils.towDecimal((Double)(size / 1024.0))));
            doc.setFileUnit("KB");
        } else {
            doc.setFileSize(String.valueOf(DoubleUtils.towDecimal((Double)(size / 1048576.0))));
            doc.setFileUnit("MB");
        }
    }

    private MultipartFile fileIdTransToFile(Long fileId) {
        try {
            FileBytesInfo fileBytesInfo = this.ioService.getFileBytesInfo(fileId);
            String fileName = fileBytesInfo.getFileName() + "." + fileBytesInfo.getFileFormat();
            return new MockMultipartFile(fileName, fileName, null, fileBytesInfo.getFileBytes());
        }
        catch (BusinessException ex) {
            log.info("\u83b7\u53d6\u6587\u4ef6\u5931\u8d25\uff0c\u6587\u4ef6id\u4e3a\uff1a{}", (Object)fileId, (Object)ex);
            return null;
        }
    }

    @Override
    public void checkDuplicate(List<DuplicateCheckDocumentGroup> taskGroupList, DuplicateCheckRequestDto duplicateCheckRequestDto) throws Exception {
        this.executorService.batchCheckDuplicate(taskGroupList, DuplicateCheckExecuteModelEnum.getModel(duplicateCheckRequestDto.getModel()), duplicateCheckRequestDto.getImmediate());
    }
}

