/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.icpac.service.impl;

import cn.hutool.core.util.IdUtil;
import com.jxdinfo.idp.common.base.dto.FileBytesInfo;
import com.jxdinfo.idp.dio.service.DocInfoIoService;
import com.jxdinfo.idp.duplicatecheck.api.call.DuplicatecheckOverInterface;
import com.jxdinfo.idp.duplicatecheck.api.entity.dto.DuplicateCheckDocDto;
import com.jxdinfo.idp.duplicatecheck.api.entity.dto.DuplicateCheckDocumentGroup;
import com.jxdinfo.idp.duplicatecheck.api.entity.dto.DuplicateCheckProjectDto;
import com.jxdinfo.idp.icpac.core.asyncexecutor.DuplicateCheckTaskGroup;
import com.jxdinfo.idp.icpac.core.entity.DuplicateCheckInfo;
import com.jxdinfo.idp.icpac.core.entity.DuplicateCheckInfoGroup;
import com.jxdinfo.idp.icpac.core.handler.DuplicateCheckResultHandler;
import com.jxdinfo.idp.icpac.core.info.DuplicateCheckExecuteModelEnum;
import com.jxdinfo.idp.icpac.core.info.DuplicateCheckOperationEnum;
import com.jxdinfo.idp.icpac.core.info.DuplicateCheckUpdateModelEnum;
import com.jxdinfo.idp.icpac.custom.resulthandler.DefaultResultHandler;
import com.jxdinfo.idp.icpac.custom.resulthandler.NotifyResultHandler;
import com.jxdinfo.idp.icpac.custom.sentencehandler.SentenceHandlerManagement;
import com.jxdinfo.idp.icpac.service.DuplicateCheckDocService;
import com.jxdinfo.idp.icpac.service.DuplicateCheckExecutorService;
import com.jxdinfo.idp.icpac.service.DuplicateCheckProjectService;
import com.jxdinfo.idp.icpac.utils.DuplicateCheckProgress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.mock.web.MockMultipartFile;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class DuplicateCheckExecutorServiceImpl
implements DuplicateCheckExecutorService {
    @Resource
    private DuplicateCheckDocService docService;
    @Autowired(required=false)
    private List<DuplicatecheckOverInterface> censorOverInterfaces;
    @Resource
    private DuplicateCheckProjectService projectService;
    @Resource
    private DocInfoIoService ioService;

    private DuplicateCheckInfo prepareCheckDuplicate(String documentId) {
        return this.prepareCheckDuplicate(documentId, null);
    }

    private DuplicateCheckInfo prepareCheckDuplicate(String documentId, DuplicateCheckResultHandler resultHandler) {
        if (StringUtils.isEmpty((CharSequence)documentId)) {
            throw new RuntimeException("\u6ca1\u6709\u7ed9\u5b9adocId\uff0c\u65e0\u6cd5\u9884\u652f\u6267\u884c\u67d0\u4e2a\u67e5\u91cd");
        }
        DuplicateCheckProgress.setProgress(documentId, 0);
        DuplicateCheckDocDto docInfo = this.docService.simpleDetail(documentId);
        FileBytesInfo fileBytesInfo = this.ioService.getFileBytesInfo(docInfo.getFileId());
        String fileName = fileBytesInfo.getFileName() + "." + fileBytesInfo.getFileFormat();
        MockMultipartFile file = new MockMultipartFile(fileName, fileName, null, fileBytesInfo.getFileBytes());
        DuplicateCheckProjectDto projectDto = this.projectService.detailWithConfigInfo(docInfo.getProjectId());
        String updateLib = docInfo.getUpdateLib();
        DuplicateCheckUpdateModelEnum updateModel = DuplicateCheckUpdateModelEnum.getUpdateModel(updateLib);
        if (resultHandler == null) {
            if (updateModel == DuplicateCheckUpdateModelEnum.NO_UPDATE || updateModel == DuplicateCheckUpdateModelEnum.CHECK_UPDATE) {
                resultHandler = new DefaultResultHandler(this.docService);
            } else if (updateModel == DuplicateCheckUpdateModelEnum.NO_CHECK_UPDATE) {
                resultHandler = new NotifyResultHandler(this.docService);
            } else {
                throw new RuntimeException("\u6839\u636eupdateLib\u672a\u627e\u5230\u5408\u9002\u7684\u7c7b\u53bb\u89e3\u51b3\u8be5\u95ee\u9898");
            }
        }
        DuplicateCheckInfo checkInfo = new DuplicateCheckInfo(documentId, (MultipartFile)file, updateLib, projectDto.getSimilarityBounds(), projectDto.getWordLength(), SentenceHandlerManagement.get((MultipartFile)file), resultHandler);
        checkInfo.addAttachment("chapterConfig", projectDto.getChapterList());
        checkInfo.addAttachment("docId", documentId);
        checkInfo.addAttachment("projectId", projectDto.getId());
        return checkInfo;
    }

    @Override
    public void asyncCheckDuplicate(DuplicateCheckDocDto docInfo) {
        DuplicateCheckInfo duplicateCheckInfo = this.prepareCheckDuplicate(docInfo.getId());
        DuplicateCheckInfoGroup checkInfoGroup = new DuplicateCheckInfoGroup(IdUtil.simpleUUID(), Arrays.asList(duplicateCheckInfo), new ArrayList<String>(), DuplicateCheckExecuteModelEnum.ASYNC, DuplicateCheckOperationEnum.CHECK);
        DuplicateCheckTaskGroup taskGroup = new DuplicateCheckTaskGroup(Arrays.asList(checkInfoGroup));
        taskGroup.call();
    }

    @Override
    public void syncCheckDuplicate(DuplicateCheckDocDto docInfo) {
        DuplicateCheckInfo duplicateCheckInfo = this.prepareCheckDuplicate(docInfo.getId());
        DuplicateCheckInfoGroup checkInfoGroup = new DuplicateCheckInfoGroup(IdUtil.simpleUUID(), Arrays.asList(duplicateCheckInfo), new ArrayList<String>(), DuplicateCheckExecuteModelEnum.SYNC, DuplicateCheckOperationEnum.CHECK);
        DuplicateCheckTaskGroup duplicateCheckTaskGroup = new DuplicateCheckTaskGroup(Arrays.asList(checkInfoGroup));
        duplicateCheckTaskGroup.call();
    }

    @Override
    public void batchCheckDuplicate(List<DuplicateCheckDocumentGroup> documentGroupList, DuplicateCheckExecuteModelEnum model, Boolean immediate) throws Exception {
        ArrayList<DuplicateCheckInfoGroup> infoGroupList = new ArrayList<DuplicateCheckInfoGroup>();
        for (DuplicateCheckDocumentGroup documentGroup : documentGroupList) {
            ArrayList<DuplicateCheckInfo> infoList = new ArrayList<DuplicateCheckInfo>();
            DuplicateCheckInfoGroup infoGroup = new DuplicateCheckInfoGroup();
            infoGroup.setExcludeDocumentIdList(documentGroup.getExcludeDocumentIdList());
            infoGroup.setExecuteModel(model);
            for (String documentId : documentGroup.getDocumentIdList()) {
                DuplicateCheckInfo checkInfo = this.prepareCheckDuplicate(documentId);
                infoList.add(checkInfo);
            }
            infoGroupList.add(new DuplicateCheckInfoGroup(documentGroup.getGroupId(), infoList, documentGroup.getExcludeDocumentIdList(), model, DuplicateCheckOperationEnum.CHECK));
        }
        DuplicateCheckTaskGroup duplicateCheckTaskGroup = new DuplicateCheckTaskGroup(infoGroupList, immediate);
        duplicateCheckTaskGroup.call();
    }
}

