/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.icpac.service.impl;

import cn.hutool.core.lang.generator.SnowflakeGenerator;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.jxdinfo.idp.common.util.DoubleUtils;
import com.jxdinfo.idp.duplicatecheck.api.entity.dto.DuplicateCheckDocDto;
import com.jxdinfo.idp.duplicatecheck.api.entity.dto.DuplicateCheckResultDto;
import com.jxdinfo.idp.duplicatecheck.api.entity.dto.DuplicateCheckSentenceDto;
import com.jxdinfo.idp.duplicatecheck.api.entity.po.DuplicateCheckDoc;
import com.jxdinfo.idp.duplicatecheck.api.entity.query.DuplicateCheckDocQuery;
import com.jxdinfo.idp.duplicatecheck.api.entity.query.DuplicateCheckResultQuery;
import com.jxdinfo.idp.duplicatecheck.api.entity.query.DuplicateCheckSentenceQuery;
import com.jxdinfo.idp.icpac.core.asyncexecutor.DuplicateCheckTaskGroup;
import com.jxdinfo.idp.icpac.core.entity.DuplicateCheckInfo;
import com.jxdinfo.idp.icpac.core.entity.DuplicateCheckInfoGroup;
import com.jxdinfo.idp.icpac.core.info.DuplicateCheckOperationEnum;
import com.jxdinfo.idp.icpac.core.info.DuplicateCheckStatusEnum;
import com.jxdinfo.idp.icpac.core.info.DuplicateCheckUpdateModelEnum;
import com.jxdinfo.idp.icpac.listen.baseinfo.DuplicateCheckProjectChain;
import com.jxdinfo.idp.icpac.listen.baseinfo.DuplicateCheckProjectListener;
import com.jxdinfo.idp.icpac.listen.event.DuplicateCheckEvent;
import com.jxdinfo.idp.icpac.listen.event.MultiSimilarityEventType;
import com.jxdinfo.idp.icpac.mapper.DuplicateCheckDocMapper;
import com.jxdinfo.idp.icpac.service.DuplicateCheckDocService;
import com.jxdinfo.idp.icpac.service.DuplicateCheckResultService;
import com.jxdinfo.idp.icpac.service.DuplicateCheckSentenceService;
import com.jxdinfo.idp.icpac.utils.DuplicateCheckProgress;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class DuplicateCheckDocServiceImpl
extends ServiceImpl<DuplicateCheckDocMapper, DuplicateCheckDoc>
implements DuplicateCheckDocService,
DuplicateCheckProjectListener {
    private static final Logger log = LoggerFactory.getLogger(DuplicateCheckDocServiceImpl.class);
    @Resource
    private DuplicateCheckDocMapper mapper;
    @Resource
    private DuplicateCheckResultService resultService;
    @Resource
    private DuplicateCheckSentenceService sentenceService;

    public DuplicateCheckDocServiceImpl() {
        DuplicateCheckProjectChain.register(this);
    }

    @Override
    public void onEvent(DuplicateCheckEvent event) {
        if (event.getEventType() == MultiSimilarityEventType.DELETE) {
            List projectIds = (List)event.getData();
            LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
            wrapper.in(DuplicateCheckDoc::getProjectId, (Collection)projectIds);
            List docInfoList = this.list((Wrapper)wrapper);
            List<String> ids = docInfoList.stream().map(DuplicateCheckDoc::getId).collect(Collectors.toList());
            this.removeByIds(ids);
            this.cascadeDelete(ids, null);
        }
    }

    @Override
    public Page<DuplicateCheckDocDto> list(DuplicateCheckDocQuery query) {
        boolean pageFlag = query.isPageFlag();
        Page page = query.getPage(DuplicateCheckDocDto.class);
        if (pageFlag) {
            List<DuplicateCheckDocDto> docInfoList = this.mapper.list(query, (Page<DuplicateCheckDocDto>)page);
            page.setRecords(docInfoList);
        } else {
            List<DuplicateCheckDocDto> docInfoList = this.mapper.list(query, null);
            page.setRecords(docInfoList);
        }
        return page;
    }

    @Override
    public void delete(List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return;
        }
        DuplicateCheckProgress.clear(ids);
        DuplicateCheckDoc checkDoc = (DuplicateCheckDoc)this.getById((Serializable)((Object)ids.get(0)));
        if (checkDoc == null) {
            return;
        }
        List checkDocList = this.listByIds(ids);
        String projectId = checkDoc.getProjectId();
        this.removeByIds(ids);
        this.cascadeDelete(ids, projectId);
        List historyDocList = checkDocList.stream().filter(k -> Objects.equals(k.getUpdateLib(), DuplicateCheckUpdateModelEnum.CHECK_UPDATE.getFlag())).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(historyDocList)) {
            this.calcSimilarityAfterDelDoc(projectId);
        }
    }

    @Override
    public List<DuplicateCheckDocDto> saveDocInfo(List<DuplicateCheckDocDto> docInfoList) {
        ArrayList<DuplicateCheckDoc> saveDocList = new ArrayList<DuplicateCheckDoc>();
        for (DuplicateCheckDocDto docInfo : docInfoList) {
            this.fillInfo(docInfo);
            saveDocList.add(new DuplicateCheckDoc((DuplicateCheckDoc)docInfo));
        }
        this.saveBatch(saveDocList);
        return docInfoList;
    }

    @Override
    public void calcSimilarityAfterDelSentence(String docId) {
        DuplicateCheckSentenceQuery sentenceQuery = new DuplicateCheckSentenceQuery();
        sentenceQuery.setDocumentId(docId);
        sentenceQuery.setIgnoreFlag("1");
        sentenceQuery.setPageFlag(false);
        List sentenceDtoList = this.sentenceService.getSentenceList(sentenceQuery).getRecords();
        DuplicateCheckDoc checkDoc = (DuplicateCheckDoc)this.getById((Serializable)((Object)docId));
        DuplicateCheckDoc doc = this.calcSimilarity(docId, checkDoc.getCandidateSentenceNum(), sentenceDtoList);
        this.updateById(doc);
    }

    private DuplicateCheckDoc calcSimilarity(String docId, int candidateSentenceNum, Collection<DuplicateCheckSentenceDto> sentenceDtoList) {
        double maxSimilarity = 0.0;
        double docSimilarity = 0.0;
        if (CollectionUtils.isNotEmpty(sentenceDtoList)) {
            BigDecimal docSimilarityD = new BigDecimal(0);
            for (DuplicateCheckSentenceDto sentence : sentenceDtoList) {
                if (Double.compare(maxSimilarity, sentence.getSimilarity()) < 0) {
                    maxSimilarity = sentence.getSimilarity();
                }
                docSimilarityD = docSimilarityD.add(BigDecimal.valueOf(sentence.getSimilarity()));
            }
            docSimilarity = DoubleUtils.towDecimal((Double)(docSimilarityD.doubleValue() / (double)candidateSentenceNum));
        }
        DuplicateCheckDoc doc = new DuplicateCheckDoc();
        doc.setId(docId);
        doc.setMaxSimilarity(Double.valueOf(maxSimilarity));
        doc.setDocSimilarity(Double.valueOf(docSimilarity));
        doc.setCandidateSentenceNum(candidateSentenceNum);
        return doc;
    }

    @Override
    public void calcSimilarityAfterDelDoc(String projectId) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(DuplicateCheckDoc::getProjectId, (Object)projectId);
        List docList = this.list((Wrapper)wrapper);
        if (CollectionUtils.isEmpty((Collection)docList)) {
            return;
        }
        DuplicateCheckSentenceQuery sentenceQuery = new DuplicateCheckSentenceQuery();
        List docIdList = docList.stream().map(DuplicateCheckDoc::getId).collect(Collectors.toList());
        sentenceQuery.setDocIds(docIdList);
        sentenceQuery.setIgnoreFlag("1");
        sentenceQuery.setPageFlag(false);
        List sentenceDtoList = this.sentenceService.getSentenceList(sentenceQuery).getRecords();
        HashMap<String, List> docIdListMap = new HashMap<String, List>();
        for (DuplicateCheckSentenceDto sentenceDto : sentenceDtoList) {
            docIdListMap.computeIfAbsent(sentenceDto.getDocId(), k -> new ArrayList()).add(sentenceDto);
        }
        ArrayList<DuplicateCheckDoc> updateDoc = new ArrayList<DuplicateCheckDoc>();
        for (DuplicateCheckDoc doc : docList) {
            updateDoc.add(this.calcSimilarity(doc.getId(), doc.getCandidateSentenceNum(), (Collection)docIdListMap.get(doc.getId())));
        }
        this.updateBatchById(updateDoc);
    }

    private void cascadeDelete(List<String> ids, String projectId) {
        this.sentenceService.deleteByDocIds(ids);
        this.resultService.deleteByDocIds(ids);
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)wrapper.eq(DuplicateCheckDoc::getProjectId, (Object)projectId)).eq(DuplicateCheckDoc::getUpdateLib, (Object)DuplicateCheckUpdateModelEnum.NO_UPDATE.getFlag());
        List checkDocList = this.list((Wrapper)wrapper);
        List<String> idList = checkDocList.stream().map(DuplicateCheckDoc::getId).collect(Collectors.toList());
        DuplicateCheckResultQuery resultQuery = new DuplicateCheckResultQuery();
        resultQuery.setUploadDocIds(idList);
        List<DuplicateCheckResultDto> resultDtos = this.resultService.list(resultQuery);
        if (CollectionUtils.isEmpty(resultDtos)) {
            this.sentenceService.deleteByDocIds(idList);
        } else {
            for (DuplicateCheckResultDto resultDto : resultDtos) {
                idList.remove(resultDto.getUploadDocId());
            }
            this.sentenceService.deleteByDocIds(idList);
        }
        if (StringUtils.isNotEmpty((CharSequence)projectId)) {
            DuplicateCheckInfo checkInfo = new DuplicateCheckInfo("mn_checkId", DuplicateCheckOperationEnum.DELETE);
            checkInfo.addAttachment("uploadIds", ids);
            checkInfo.addAttachment("projectId", projectId);
            DuplicateCheckInfoGroup checkInfoGroup = new DuplicateCheckInfoGroup();
            checkInfoGroup.setOperationEnum(DuplicateCheckOperationEnum.DELETE);
            checkInfoGroup.setInfoList(Arrays.asList(checkInfo));
            DuplicateCheckTaskGroup taskGroup = new DuplicateCheckTaskGroup(Arrays.asList(checkInfoGroup));
            taskGroup.call();
        }
    }

    @Override
    public DuplicateCheckDocDto detail(String id) {
        DuplicateCheckDoc docInfo = (DuplicateCheckDoc)this.getById((Serializable)((Object)id));
        if (docInfo == null) {
            return new DuplicateCheckDocDto();
        }
        DuplicateCheckDocDto docInfoDto = DuplicateCheckDocDto.toDto((DuplicateCheckDoc)docInfo);
        Map<String, List<DuplicateCheckResultDto>> idObjMap = this.resultService.listByDocIdsForMap(Collections.singletonList(id));
        docInfoDto.setResultList(idObjMap.get(docInfoDto.getId()));
        return docInfoDto;
    }

    @Override
    public List<DuplicateCheckDocDto> listByProjectId(String projectId) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(DuplicateCheckDoc::getProjectId, (Object)projectId);
        List docInfos = this.list((Wrapper)wrapper);
        return DuplicateCheckDocDto.toDto((List)docInfos);
    }

    @Override
    public DuplicateCheckDoc insert(DuplicateCheckDocDto docInfoDto) throws Exception {
        String projectId = docInfoDto.getProjectId();
        if (StringUtils.isEmpty((CharSequence)projectId)) {
            throw new IllegalArgumentException("\u6587\u6863\u4e0d\u77e5\u9053\u5bf9\u5e94\u7684\u57fa\u7840\u4fe1\u606fid\uff0c\u4f20\u5165\u7684\u57fa\u7840\u4fe1\u606fid\u4e3a\u7a7a");
        }
        this.fillInfo(docInfoDto);
        this.save(docInfoDto);
        return docInfoDto;
    }

    private void fillInfo(DuplicateCheckDocDto docDto) {
        SnowflakeGenerator snowflakeGenerator = new SnowflakeGenerator();
        docDto.setId(String.valueOf(snowflakeGenerator.next()));
        docDto.setTaskStatus(DuplicateCheckStatusEnum.PROCESSING.getStatus());
        docDto.setStartTime(LocalDateTime.now());
    }

    @Override
    public DuplicateCheckDocDto simpleDetail(String id) {
        DuplicateCheckDocQuery docQuery = new DuplicateCheckDocQuery();
        docQuery.setDocumentId(id);
        List<DuplicateCheckDocDto> docDtoList = this.mapper.list(docQuery, null);
        if (CollectionUtils.isEmpty(docDtoList)) {
            return new DuplicateCheckDocDto();
        }
        return docDtoList.get(0);
    }

    @Override
    public void insertCheckResult(DuplicateCheckDocDto docDto) {
        this.resultService.saveBatch(docDto.getResultList());
        this.sentenceService.saveBatch(docDto.getSentenceList());
    }
}

