/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.icpac.core.entity;

import com.jxdinfo.hussar.platform.core.utils.file.FileNameUtil;
import com.jxdinfo.idp.icpac.core.context.DuplicateCheckContext;
import com.jxdinfo.idp.icpac.core.entity.DuplicateCheckCandidateSentence;
import com.jxdinfo.idp.icpac.core.executor.DuplicateCheckDocumentExecutor;
import com.jxdinfo.idp.icpac.core.executor.DuplicateCheckExecutorRegister;
import com.jxdinfo.idp.icpac.core.handler.DuplicateCheckResultHandler;
import com.jxdinfo.idp.icpac.core.handler.SentenceHandler;
import com.jxdinfo.idp.icpac.core.info.DuplicateCheckOperationEnum;
import com.jxdinfo.idp.icpac.core.info.DuplicateCheckUpdateModelEnum;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.web.multipart.MultipartFile;

public class DuplicateCheckInfo {
    private String checkId;
    private MultipartFile file;
    private Double simThresh;
    private Map<String, Object> attachmentCollections;
    private Integer minSentenceLen;
    private SentenceHandler sentenceHandler;
    private int candidateSentenceNum;
    private List<DuplicateCheckCandidateSentence> candidateSentenceList;
    private String format;
    private String groupId;
    private DuplicateCheckDocumentExecutor checkDocExecutor;
    private DuplicateCheckResultHandler resultHandler;
    private DuplicateCheckContext context;
    private DuplicateCheckUpdateModelEnum updateModel;

    public DuplicateCheckInfo(String checkId, DuplicateCheckOperationEnum operationEnum) {
        this.assertNoNull(checkId, "\u7ed9\u5b9a\u7684\u64cd\u4f5c\u6807\u8bc6\u7b26id\u4e3a\u7a7a");
        this.checkId = checkId;
        this.attachmentCollections = new HashMap<String, Object>();
        this.checkDocExecutor = DuplicateCheckExecutorRegister.get(this);
    }

    public DuplicateCheckInfo(String checkId, MultipartFile file, String updateLib, Double simThresh, Integer minSentenceLen, SentenceHandler sentenceHandler, DuplicateCheckResultHandler resultHandler) {
        this.assertNoNull(checkId, "\u7ed9\u5b9a\u7684\u64cd\u4f5c\u6807\u8bc6\u7b26id\u4e3a\u7a7a");
        this.checkId = checkId;
        this.assertNoNull(file, "\u7ed9\u5b9a\u7684\u67e5\u91cd\u6587\u4ef6\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u8fdb\u884c\u5ba1\u67e5");
        this.file = file;
        this.assertNoNull(simThresh, "\u76f8\u4f3c\u5ea6\u9608\u503c\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u8fdb\u884c\u5ba1\u67e5");
        if (simThresh <= 0.0) {
            throw new IllegalArgumentException("\u76f8\u4f3c\u5ea6\u9608\u503c\u4e0d\u80fd\u4e3a0\uff0c\u7ed9\u5b9a\u7684\u76f8\u4f3c\u5ea6\u9608\u503c\u4e3a\uff1a" + minSentenceLen);
        }
        this.simThresh = simThresh;
        this.assertNoNull(minSentenceLen, "\u89c4\u5b9a\u67e5\u91cd\u7684\u6700\u5c0f\u53e5\u5b50\u5b57\u7b26\u6570\u4e3a\u7a7a");
        if (minSentenceLen <= 0) {
            throw new IllegalArgumentException("\u6700\u5c0f\u5b57\u7b26\u957f\u5ea6\u4e0d\u80fd\u5c0f\u4e8e0\uff0c\u7ed9\u5b9a\u7684\u6700\u5c0f\u5b57\u7b26\u957f\u5ea6\u4e3a\uff1a" + minSentenceLen);
        }
        this.updateModel = DuplicateCheckUpdateModelEnum.getUpdateModel(updateLib);
        this.minSentenceLen = minSentenceLen;
        this.attachmentCollections = new HashMap<String, Object>();
        this.sentenceHandler = sentenceHandler;
        this.format = FileNameUtil.getSuffix((String)file.getOriginalFilename());
        this.resultHandler = resultHandler;
        this.checkDocExecutor = DuplicateCheckExecutorRegister.get(this);
    }

    private void assertNoNull(Object o, String message) {
        if (this.file == o) {
            throw new NullPointerException(message);
        }
    }

    public Object addAttachment(String key, Object attachment) {
        if (key == null) {
            throw new NullPointerException("\u7ed9\u5b9a\u7684key\u4e0d\u80fd\u4e3anull");
        }
        Object oldAttachment = this.attachmentCollections.remove(key);
        this.attachmentCollections.put(key, attachment);
        return oldAttachment;
    }

    public <T> T getAttachment(String key, Class<T> type) {
        Object o = this.attachmentCollections.get(key);
        if (o == null) {
            return null;
        }
        return (T)o;
    }

    public String getFileName() {
        if (this.file == null) {
            return "";
        }
        return this.file.getOriginalFilename();
    }

    public String getCheckId() {
        return this.checkId;
    }

    public MultipartFile getFile() {
        return this.file;
    }

    public Double getSimThresh() {
        return this.simThresh;
    }

    public Map<String, Object> getAttachmentCollections() {
        return this.attachmentCollections;
    }

    public Integer getMinSentenceLen() {
        return this.minSentenceLen;
    }

    public SentenceHandler getSentenceHandler() {
        return this.sentenceHandler;
    }

    public int getCandidateSentenceNum() {
        return this.candidateSentenceNum;
    }

    public List<DuplicateCheckCandidateSentence> getCandidateSentenceList() {
        return this.candidateSentenceList;
    }

    public String getFormat() {
        return this.format;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public DuplicateCheckDocumentExecutor getCheckDocExecutor() {
        return this.checkDocExecutor;
    }

    public DuplicateCheckResultHandler getResultHandler() {
        return this.resultHandler;
    }

    public DuplicateCheckContext getContext() {
        return this.context;
    }

    public DuplicateCheckUpdateModelEnum getUpdateModel() {
        return this.updateModel;
    }

    public void setCheckId(String checkId) {
        this.checkId = checkId;
    }

    public void setFile(MultipartFile file) {
        this.file = file;
    }

    public void setSimThresh(Double simThresh) {
        this.simThresh = simThresh;
    }

    public void setAttachmentCollections(Map<String, Object> attachmentCollections) {
        this.attachmentCollections = attachmentCollections;
    }

    public void setMinSentenceLen(Integer minSentenceLen) {
        this.minSentenceLen = minSentenceLen;
    }

    public void setSentenceHandler(SentenceHandler sentenceHandler) {
        this.sentenceHandler = sentenceHandler;
    }

    public void setCandidateSentenceNum(int candidateSentenceNum) {
        this.candidateSentenceNum = candidateSentenceNum;
    }

    public void setCandidateSentenceList(List<DuplicateCheckCandidateSentence> candidateSentenceList) {
        this.candidateSentenceList = candidateSentenceList;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public void setCheckDocExecutor(DuplicateCheckDocumentExecutor checkDocExecutor) {
        this.checkDocExecutor = checkDocExecutor;
    }

    public void setResultHandler(DuplicateCheckResultHandler resultHandler) {
        this.resultHandler = resultHandler;
    }

    public void setContext(DuplicateCheckContext context) {
        this.context = context;
    }

    public void setUpdateModel(DuplicateCheckUpdateModelEnum updateModel) {
        this.updateModel = updateModel;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DuplicateCheckInfo)) {
            return false;
        }
        DuplicateCheckInfo other = (DuplicateCheckInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getCandidateSentenceNum() != other.getCandidateSentenceNum()) {
            return false;
        }
        Double this$simThresh = this.getSimThresh();
        Double other$simThresh = other.getSimThresh();
        if (this$simThresh == null ? other$simThresh != null : !((Object)this$simThresh).equals(other$simThresh)) {
            return false;
        }
        Integer this$minSentenceLen = this.getMinSentenceLen();
        Integer other$minSentenceLen = other.getMinSentenceLen();
        if (this$minSentenceLen == null ? other$minSentenceLen != null : !((Object)this$minSentenceLen).equals(other$minSentenceLen)) {
            return false;
        }
        String this$checkId = this.getCheckId();
        String other$checkId = other.getCheckId();
        if (this$checkId == null ? other$checkId != null : !this$checkId.equals(other$checkId)) {
            return false;
        }
        MultipartFile this$file = this.getFile();
        MultipartFile other$file = other.getFile();
        if (this$file == null ? other$file != null : !this$file.equals(other$file)) {
            return false;
        }
        Map<String, Object> this$attachmentCollections = this.getAttachmentCollections();
        Map<String, Object> other$attachmentCollections = other.getAttachmentCollections();
        if (this$attachmentCollections == null ? other$attachmentCollections != null : !((Object)this$attachmentCollections).equals(other$attachmentCollections)) {
            return false;
        }
        SentenceHandler this$sentenceHandler = this.getSentenceHandler();
        SentenceHandler other$sentenceHandler = other.getSentenceHandler();
        if (this$sentenceHandler == null ? other$sentenceHandler != null : !this$sentenceHandler.equals(other$sentenceHandler)) {
            return false;
        }
        List<DuplicateCheckCandidateSentence> this$candidateSentenceList = this.getCandidateSentenceList();
        List<DuplicateCheckCandidateSentence> other$candidateSentenceList = other.getCandidateSentenceList();
        if (this$candidateSentenceList == null ? other$candidateSentenceList != null : !((Object)this$candidateSentenceList).equals(other$candidateSentenceList)) {
            return false;
        }
        String this$format = this.getFormat();
        String other$format = other.getFormat();
        if (this$format == null ? other$format != null : !this$format.equals(other$format)) {
            return false;
        }
        String this$groupId = this.getGroupId();
        String other$groupId = other.getGroupId();
        if (this$groupId == null ? other$groupId != null : !this$groupId.equals(other$groupId)) {
            return false;
        }
        DuplicateCheckDocumentExecutor this$checkDocExecutor = this.getCheckDocExecutor();
        DuplicateCheckDocumentExecutor other$checkDocExecutor = other.getCheckDocExecutor();
        if (this$checkDocExecutor == null ? other$checkDocExecutor != null : !this$checkDocExecutor.equals(other$checkDocExecutor)) {
            return false;
        }
        DuplicateCheckResultHandler this$resultHandler = this.getResultHandler();
        DuplicateCheckResultHandler other$resultHandler = other.getResultHandler();
        if (this$resultHandler == null ? other$resultHandler != null : !this$resultHandler.equals(other$resultHandler)) {
            return false;
        }
        DuplicateCheckContext this$context = this.getContext();
        DuplicateCheckContext other$context = other.getContext();
        if (this$context == null ? other$context != null : !this$context.equals(other$context)) {
            return false;
        }
        DuplicateCheckUpdateModelEnum this$updateModel = this.getUpdateModel();
        DuplicateCheckUpdateModelEnum other$updateModel = other.getUpdateModel();
        return !(this$updateModel == null ? other$updateModel != null : !((Object)((Object)this$updateModel)).equals((Object)other$updateModel));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DuplicateCheckInfo;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getCandidateSentenceNum();
        Double $simThresh = this.getSimThresh();
        result = result * 59 + ($simThresh == null ? 43 : ((Object)$simThresh).hashCode());
        Integer $minSentenceLen = this.getMinSentenceLen();
        result = result * 59 + ($minSentenceLen == null ? 43 : ((Object)$minSentenceLen).hashCode());
        String $checkId = this.getCheckId();
        result = result * 59 + ($checkId == null ? 43 : $checkId.hashCode());
        MultipartFile $file = this.getFile();
        result = result * 59 + ($file == null ? 43 : $file.hashCode());
        Map<String, Object> $attachmentCollections = this.getAttachmentCollections();
        result = result * 59 + ($attachmentCollections == null ? 43 : ((Object)$attachmentCollections).hashCode());
        SentenceHandler $sentenceHandler = this.getSentenceHandler();
        result = result * 59 + ($sentenceHandler == null ? 43 : $sentenceHandler.hashCode());
        List<DuplicateCheckCandidateSentence> $candidateSentenceList = this.getCandidateSentenceList();
        result = result * 59 + ($candidateSentenceList == null ? 43 : ((Object)$candidateSentenceList).hashCode());
        String $format = this.getFormat();
        result = result * 59 + ($format == null ? 43 : $format.hashCode());
        String $groupId = this.getGroupId();
        result = result * 59 + ($groupId == null ? 43 : $groupId.hashCode());
        DuplicateCheckDocumentExecutor $checkDocExecutor = this.getCheckDocExecutor();
        result = result * 59 + ($checkDocExecutor == null ? 43 : $checkDocExecutor.hashCode());
        DuplicateCheckResultHandler $resultHandler = this.getResultHandler();
        result = result * 59 + ($resultHandler == null ? 43 : $resultHandler.hashCode());
        DuplicateCheckContext $context = this.getContext();
        result = result * 59 + ($context == null ? 43 : $context.hashCode());
        DuplicateCheckUpdateModelEnum $updateModel = this.getUpdateModel();
        result = result * 59 + ($updateModel == null ? 43 : ((Object)((Object)$updateModel)).hashCode());
        return result;
    }

    public String toString() {
        return "DuplicateCheckInfo(checkId=" + this.getCheckId() + ", file=" + this.getFile() + ", simThresh=" + this.getSimThresh() + ", attachmentCollections=" + this.getAttachmentCollections() + ", minSentenceLen=" + this.getMinSentenceLen() + ", sentenceHandler=" + this.getSentenceHandler() + ", candidateSentenceNum=" + this.getCandidateSentenceNum() + ", candidateSentenceList=" + this.getCandidateSentenceList() + ", format=" + this.getFormat() + ", groupId=" + this.getGroupId() + ", checkDocExecutor=" + this.getCheckDocExecutor() + ", resultHandler=" + this.getResultHandler() + ", context=" + this.getContext() + ", updateModel=" + (Object)((Object)this.getUpdateModel()) + ")";
    }
}

