/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.icpac.core.asyncexecutor.impl;

import com.jxdinfo.idp.icpac.core.asyncexecutor.impl.AbstractDuplicateCheckTask;
import com.jxdinfo.idp.icpac.core.entity.DuplicateCheckInfo;
import com.jxdinfo.idp.icpac.core.entity.DuplicateCheckResult;
import com.jxdinfo.idp.icpac.core.executor.DuplicateCheckDocumentExecutor;
import com.jxdinfo.idp.icpac.core.handler.DuplicateCheckResultHandler;
import com.jxdinfo.idp.icpac.core.info.DuplicateCheckUpdateModelEnum;
import com.jxdinfo.idp.icpac.core.rmi.resp.DuplicateCheckResponse;
import java.io.IOException;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DuplicateCheckVerCheckTask
extends AbstractDuplicateCheckTask {
    private static final Logger log = LoggerFactory.getLogger(DuplicateCheckVerCheckTask.class);
    private Boolean immediate = false;

    public DuplicateCheckVerCheckTask() {
    }

    public DuplicateCheckVerCheckTask(Boolean immediate) {
        this.immediate = immediate;
    }

    @Override
    public Object call() throws Exception {
        Iterator infoIter = this.infoList.iterator();
        while (infoIter.hasNext()) {
            DuplicateCheckInfo checkInfo = (DuplicateCheckInfo)infoIter.next();
            DuplicateCheckDocumentExecutor checkDocExecutor = checkInfo.getCheckDocExecutor();
            try {
                if (checkInfo.getUpdateModel() == DuplicateCheckUpdateModelEnum.NO_UPDATE) continue;
                checkDocExecutor.vectorization(checkInfo);
            }
            catch (Exception ex) {
                log.info("\u67e5\u91cd\u4efb\u52a1\u5411\u91cf\u5316\u51fa\u73b0\u9519\u8bef", (Throwable)ex);
                infoIter.remove();
                DuplicateCheckResult checkResult = new DuplicateCheckResult();
                checkResult.setInfo(checkInfo);
                checkResult.setError(ex);
                DuplicateCheckResultHandler resultHandler = checkInfo.getResultHandler();
                if (resultHandler == null) continue;
                resultHandler.handleResult(checkResult);
            }
        }
        for (DuplicateCheckInfo duplicateCheckInfo : this.infoList) {
            if (this.immediate.booleanValue()) {
                this.executeCheck(duplicateCheckInfo);
                continue;
            }
            CompletableFuture.runAsync(() -> this.executeCheck(duplicateCheckInfo));
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object executeCheck(DuplicateCheckInfo checkInfo) {
        block15: {
            DuplicateCheckDocumentExecutor checkDocExecutor = checkInfo.getCheckDocExecutor();
            DuplicateCheckResultHandler resultHandler = checkInfo.getResultHandler();
            log.info("\u5f53\u524d\u7684\u64cd\u4f5c\u662f\u67e5\u91cd\u64cd\u4f5c");
            DuplicateCheckResult checkResult = new DuplicateCheckResult();
            checkResult.setInfo(checkInfo);
            try {
                DuplicateCheckUpdateModelEnum updateModel = checkInfo.getUpdateModel();
                DuplicateCheckResponse response = null;
                response = updateModel == DuplicateCheckUpdateModelEnum.NO_UPDATE ? checkDocExecutor.checkRepeat(checkInfo) : checkDocExecutor.checkRepeatNoVectorization(checkInfo);
                checkResult.setExecutionResult(response);
                if (resultHandler == null) break block15;
                try {
                    resultHandler.handleResult(checkResult);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            catch (Exception e) {
                log.error("\u5ba1\u67e5\u51fa\u73b0\u95ee\u9898\uff0c\u5ba1\u67e5\u4fe1\u606f\u4e3a", (Throwable)e);
                checkResult.setError(e);
                if (resultHandler != null) {
                    resultHandler.handleResult(checkResult);
                }
            }
            finally {
                if (checkInfo.getFile() != null) {
                    try {
                        checkInfo.getFile().getInputStream().close();
                    }
                    catch (IOException iOException) {}
                }
                log.info("\u67e5\u8be2\u4efb\u52a1\u6267\u884c\u5b8c\u6bd5");
            }
        }
        return null;
    }
}

