/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.icpac.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hutool.core.date.LocalDateTimeUtil;
import com.jxdinfo.idp.common.base.dto.FileBytesInfo;
import com.jxdinfo.idp.dio.service.DocInfoIoService;
import com.jxdinfo.idp.duplicatecheck.api.entity.dto.DuplicateCheckDocDto;
import com.jxdinfo.idp.duplicatecheck.api.entity.dto.DuplicateCheckResultDto;
import com.jxdinfo.idp.duplicatecheck.api.entity.dto.DuplicateCheckSentenceDto;
import com.jxdinfo.idp.duplicatecheck.api.entity.dto.DuplicateCheckSimilarSentenceDto;
import com.jxdinfo.idp.duplicatecheck.api.entity.dto.DuplicateCheckSimilarityInfo;
import com.jxdinfo.idp.duplicatecheck.api.entity.po.DuplicateCheckSentence;
import com.jxdinfo.idp.duplicatecheck.api.entity.query.ContrastQuery;
import com.jxdinfo.idp.duplicatecheck.api.entity.query.DuplicateCheckSentenceQuery;
import com.jxdinfo.idp.icpac.core.view.FrontViewHandler;
import com.jxdinfo.idp.icpac.core.view.FrontViewHandlerFactory;
import com.jxdinfo.idp.icpac.entity.query.SentenceDataQuery;
import com.jxdinfo.idp.icpac.service.ContrastService;
import com.jxdinfo.idp.icpac.service.DuplicateCheckDocService;
import com.jxdinfo.idp.icpac.service.DuplicateCheckResultService;
import com.jxdinfo.idp.icpac.service.DuplicateCheckSentenceService;
import com.jxdinfo.idp.icpac.service.DuplicateCheckSimilarSentenceService;
import com.jxdinfo.idp.icpac.service.data.SentenceSelectData;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.xwpf.usermodel.ParagraphAlignment;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.apache.poi.xwpf.usermodel.XWPFRun;
import org.apache.poi.xwpf.usermodel.XWPFTable;
import org.apache.poi.xwpf.usermodel.XWPFTableCell;
import org.apache.poi.xwpf.usermodel.XWPFTableRow;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STMerge;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.mock.web.MockMultipartFile;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class ContrastServiceImpl
implements ContrastService {
    private static final Logger log = LoggerFactory.getLogger(ContrastServiceImpl.class);
    @Resource
    private DuplicateCheckResultService resultService;
    @Resource
    private DuplicateCheckSentenceService sentenceService;
    @Resource
    private DuplicateCheckSimilarSentenceService similarSentenceService;
    @Resource
    private DuplicateCheckDocService docService;
    @Resource
    private DocInfoIoService ioService;
    @Resource
    private SentenceSelectData sentenceSelectData;

    @Override
    public List<DuplicateCheckSentenceDto> getSentenceNoPage(ContrastQuery query) {
        SentenceDataQuery sentenceDataQuery = new SentenceDataQuery();
        sentenceDataQuery.setDocumentId(query.getUploadDocId());
        sentenceDataQuery.setSimilarity(query.getSimilarity());
        sentenceDataQuery.setPageFlag(false);
        Page<DuplicateCheckSentenceDto> page = this.sentenceSelectData.getSentence(sentenceDataQuery);
        return page.getRecords();
    }

    @Override
    public List<DuplicateCheckSentenceDto> getAllSentence(ContrastQuery query) {
        SentenceDataQuery sentenceDataQuery = new SentenceDataQuery();
        sentenceDataQuery.setDocumentId(query.getUploadDocId());
        sentenceDataQuery.setPageFlag(false);
        Page<DuplicateCheckSentenceDto> page = this.sentenceSelectData.getSentenceWithMaxSimiSentence(sentenceDataQuery);
        return page.getRecords();
    }

    @Override
    public List<DuplicateCheckSimilarSentenceDto> getSimilaritySentenceNoPage(ContrastQuery query) {
        SentenceDataQuery sentenceDataQuery = new SentenceDataQuery();
        sentenceDataQuery.setDocumentId(query.getUploadDocId());
        sentenceDataQuery.setSimilarity(query.getSimilarity());
        sentenceDataQuery.setPageFlag(false);
        sentenceDataQuery.setSimilarDocId(query.getSimilarDocId());
        sentenceDataQuery.setSentenceId(query.getSentenceId());
        Page<DuplicateCheckSimilarSentenceDto> page = this.sentenceSelectData.getSimilaritySentence(sentenceDataQuery);
        return page.getRecords();
    }

    @Override
    public void getStream(HttpServletResponse response, ContrastQuery query) throws Exception {
        DuplicateCheckDocDto docDto = null;
        List<DuplicateCheckSentenceDto> docLocationList = null;
        if (query.isUploadFile()) {
            docDto = this.docService.simpleDetail(query.getUploadDocId());
            docLocationList = this.getSentenceNoPage(query);
        } else {
            docDto = this.docService.simpleDetail(query.getSimilarDocId());
            docLocationList = this.getSimilaritySentenceNoPage(query);
        }
        Long fileId = docDto.getFileId();
        FileBytesInfo fileBytesInfo = this.ioService.getFileBytesInfo(fileId);
        MockMultipartFile file = new MockMultipartFile(fileBytesInfo.getFileName(), fileBytesInfo.getFileName(), null, fileBytesInfo.getFileBytes());
        FrontViewHandler frontViewHandler = FrontViewHandlerFactory.getHandler((MultipartFile)file);
        frontViewHandler.handleView(response, docLocationList, (MultipartFile)file);
    }

    @Override
    public byte[] getStream(ContrastQuery query) throws Exception {
        DuplicateCheckDocDto docDto = null;
        List<DuplicateCheckSentenceDto> docLocationList = null;
        if (query.isUploadFile()) {
            docDto = this.docService.simpleDetail(query.getUploadDocId());
            docLocationList = this.getSentenceNoPage(query);
        } else {
            docDto = this.docService.simpleDetail(query.getSimilarDocId());
            docLocationList = this.getSimilaritySentenceNoPage(query);
        }
        Long fileId = docDto.getFileId();
        FileBytesInfo fileBytesInfo = this.ioService.getFileBytesInfo(fileId);
        MockMultipartFile file = new MockMultipartFile(fileBytesInfo.getFileName(), fileBytesInfo.getFileName(), null, fileBytesInfo.getFileBytes());
        FrontViewHandler frontViewHandler = FrontViewHandlerFactory.getHandler((MultipartFile)file);
        return frontViewHandler.handleView(docLocationList, (MultipartFile)file);
    }

    @Override
    public byte[] downloadCheckDuplicateReport(String docId) throws IOException {
        DuplicateCheckDocDto docInfo = this.docService.detail(docId);
        if (docInfo == null) {
            throw new IllegalArgumentException("\u7ed9\u5b9a\u7684docId:" + docId + " \uff0c\u5728\u6587\u4ef6\u5e93\u4e2d\u627e\u4e0d\u5230");
        }
        HashMap<String, Object> reportInfo = new HashMap<String, Object>();
        reportInfo.put("reportNo", docId);
        reportInfo.put("docInfo", docInfo);
        DuplicateCheckSentenceQuery sentenceQuery = new DuplicateCheckSentenceQuery();
        sentenceQuery.setDocId(docId);
        sentenceQuery.setIgnoreFlag("1");
        sentenceQuery.setPageFlag(false);
        List allSentence = this.sentenceService.getSentenceWithMaxSimiSentence(sentenceQuery).getRecords();
        reportInfo.put("topSentence", CollectionUtils.isEmpty((Collection)allSentence) ? new ArrayList() : allSentence);
        reportInfo.put("sentenceCount", allSentence.size());
        sentenceQuery = new DuplicateCheckSentenceQuery();
        sentenceQuery.setDocId(docId);
        sentenceQuery.setSimilarity(Double.valueOf(80.0));
        sentenceQuery.setIgnoreFlag("1");
        sentenceQuery.setPageFlag(false);
        List sentenceList = this.sentenceService.getSentenceList(sentenceQuery).getRecords();
        sentenceList = CollectionUtils.isEmpty((Collection)sentenceList) ? Collections.emptyList() : sentenceList;
        reportInfo.put("le80PreProportion", sentenceList.size() + "/" + docInfo.getCandidateSentenceNum());
        return this.getWord(docId, reportInfo);
    }

    @Override
    public void downloadCheckDuplicateReport(HttpServletResponse response, String docId) throws IOException {
        response.setContentType("application/octet-stream");
        response.setHeader("Content-Disposition", "attachment; filename=\u67e5\u91cd\u62a5\u544a.docx");
        ServletOutputStream outputStream = response.getOutputStream();
        outputStream.write(this.downloadCheckDuplicateReport(docId));
        outputStream.flush();
    }

    private byte[] getWord(String docId, Map<String, Object> reportInfo) throws IOException {
        try (XWPFDocument document = new XWPFDocument();){
            XWPFParagraph paragraph = document.createParagraph();
            DuplicateCheckDocDto docInfo = (DuplicateCheckDocDto)reportInfo.get("docInfo");
            paragraph.setAlignment(ParagraphAlignment.CENTER);
            XWPFRun titleParagraphRun = paragraph.createRun();
            titleParagraphRun.setText("\u53ef\u7814\u67e5\u91cd\u5de5\u5177");
            titleParagraphRun.setFontSize(14);
            titleParagraphRun.setBold(true);
            titleParagraphRun.setFontFamily("\u5b8b\u4f53");
            paragraph = document.createParagraph();
            paragraph.setAlignment(ParagraphAlignment.CENTER);
            titleParagraphRun = paragraph.createRun();
            titleParagraphRun.setText(docInfo.getFileName());
            titleParagraphRun.setFontSize(14);
            titleParagraphRun.setBold(true);
            titleParagraphRun.setFontFamily("\u5b8b\u4f53");
            List sentenceList = (List)reportInfo.get("topSentence");
            paragraph = document.createParagraph();
            paragraph.setAlignment(ParagraphAlignment.LEFT);
            titleParagraphRun = paragraph.createRun();
            titleParagraphRun.setText("\u57fa\u672c\u4fe1\u606f\uff1a");
            titleParagraphRun.setFontSize(12);
            titleParagraphRun.setBold(true);
            titleParagraphRun.setFontFamily("\u5b8b\u4f53");
            XWPFTable table = document.createTable();
            table.setWidth("96%");
            XWPFTableRow headerRow = table.getRow(0);
            headerRow.getCell(0).setText("\u62a5\u544a\u7f16\u53f7");
            headerRow.getCell(0).setWidth("25%");
            headerRow.addNewTableCell().setText((String)reportInfo.get("reportNo"));
            headerRow.getCell(1).setWidth("75%");
            XWPFTableRow dataRow = table.createRow();
            dataRow.getCell(0).setText("\u6587\u6863\u6807\u9898");
            dataRow.getCell(0).setWidth("25%");
            dataRow.getCell(1).setText(docInfo.getFileName());
            dataRow.getCell(1).setWidth("75%");
            dataRow = table.createRow();
            dataRow.getCell(0).setText("\u68c0\u6d4b\u65f6\u95f4");
            dataRow.getCell(0).setWidth("25%");
            dataRow.getCell(1).setText(LocalDateTimeUtil.format((LocalDateTime)docInfo.getStartTime(), (String)"yyyy-MM-dd"));
            dataRow.getCell(1).setWidth("75%");
            dataRow = table.createRow();
            dataRow.getCell(0).setText("\u68c0\u6d4b\u5927\u5c0f");
            dataRow.getCell(0).setWidth("25%");
            dataRow.getCell(1).setText(docInfo.getFileSize() + docInfo.getFileUnit());
            dataRow.getCell(1).setWidth("75%");
            paragraph = document.createParagraph();
            XWPFRun brRun = paragraph.createRun();
            brRun.addBreak();
            paragraph = document.createParagraph();
            paragraph.setAlignment(ParagraphAlignment.LEFT);
            titleParagraphRun = paragraph.createRun();
            titleParagraphRun.setText("\u76f8\u4f3c\u6027\u68c0\u6d4b\u7ed3\u679c\uff1a");
            titleParagraphRun.setFontSize(12);
            titleParagraphRun.setBold(true);
            titleParagraphRun.setFontFamily("\u5b8b\u4f53");
            paragraph = document.createParagraph();
            paragraph.setAlignment(ParagraphAlignment.LEFT);
            titleParagraphRun = paragraph.createRun();
            int repeatCount = CollectionUtils.isNotEmpty((Collection)docInfo.getResultList()) ? docInfo.getResultList().size() : 0;
            String complain = String.format("\u76f8\u4f3c\u8bed\u53e5\u6570\u91cf\uff1a%s\uff1b\u91cd\u590d\u6587\u6863\u6570\u91cf\uff1a%s\uff1b\u6700\u9ad8\u76f8\u4f3c\u5ea6\uff1a%s\uff1b\u67e5\u91cd\u7387\uff1a%s\uff1b\u5927\u4e8e80\u7684\u76f8\u4f3c\u5ea6\u5360\u6bd4\uff1a%s", reportInfo.get("sentenceCount"), repeatCount, docInfo.getMaxSimilarity(), docInfo.getDocSimilarity(), reportInfo.get("le80PreProportion"));
            titleParagraphRun.setText(complain);
            titleParagraphRun.setFontSize(12);
            titleParagraphRun.setBold(true);
            titleParagraphRun.setFontFamily("\u5b8b\u4f53");
            paragraph = document.createParagraph();
            brRun = paragraph.createRun();
            brRun.addBreak();
            for (DuplicateCheckSentenceDto sentenceDto : sentenceList) {
                DuplicateCheckSimilarSentenceDto similarSentence = (DuplicateCheckSimilarSentenceDto)sentenceDto.getSimilarSentenceList().get(0);
                XWPFTable table1 = document.createTable();
                table1.setWidth("96%");
                headerRow = table1.getRow(0);
                headerRow.getCell(0).setText("\u539f\u6587\u6863");
                headerRow.getCell(0).setWidth("50%");
                headerRow.addNewTableCell().setText("\u5bf9\u6bd4\u6587\u6863");
                headerRow.getCell(1).setWidth("50%");
                XWPFTableRow row = table1.createRow();
                row.getCell(0).setText("\u300a" + sentenceDto.getFileName() + "\u300b");
                row.getCell(0).setWidth("50%");
                row.getCell(1).setText("\u300a" + similarSentence.getFileName() + "\u300b");
                row.getCell(1).setWidth("50%");
                row = table1.createRow();
                XWPFTableCell cell = row.getCell(0);
                cell.getCTTc().addNewTcPr().addNewHMerge().setVal(STMerge.RESTART);
                cell.setText("\u76f8\u4f3c\u5ea6:" + similarSentence.getSimilarity() + "%");
                cell.setWidth("100%");
                XWPFTableCell cell1 = row.getCell(1);
                cell1.getCTTc().addNewTcPr().addNewHMerge().setVal(STMerge.CONTINUE);
                row = table1.createRow();
                row.getCell(0).setText(sentenceDto.getSentence());
                row.getCell(0).setWidth("50%");
                row.getCell(1).setText(similarSentence.getSentence());
                row.getCell(1).setWidth("50%");
                paragraph = document.createParagraph();
                brRun = paragraph.createRun();
                brRun.addBreak();
            }
            paragraph = document.createParagraph();
            paragraph.setAlignment(ParagraphAlignment.LEFT);
            titleParagraphRun = paragraph.createRun();
            titleParagraphRun.setText("\u67e5\u91cd\u5de5\u5177\u4fe1\u606f\uff1a");
            titleParagraphRun.setFontSize(12);
            titleParagraphRun.setBold(true);
            titleParagraphRun.setFontFamily("\u5b8b\u4f53");
            XWPFTable table2 = document.createTable();
            table2.setWidth("96%");
            headerRow = table2.getRow(0);
            headerRow.getCell(0).setText("\u67e5\u91cd\u5de5\u5177");
            headerRow.addNewTableCell().setText("\u5b89\u5fbd\u53ef\u7814\u67e5\u91cd\u5de5\u5177");
            headerRow.getCell(0).setWidth("25%");
            headerRow.getCell(1).setWidth("75%");
            dataRow = table2.createRow();
            dataRow.getCell(0).setText("\u7248\u672c\u4fe1\u606f");
            dataRow.getCell(0).setWidth("25%");
            dataRow.getCell(1).setText("V1.0.0");
            dataRow.getCell(1).setWidth("75%");
            paragraph = document.createParagraph();
            paragraph.setAlignment(ParagraphAlignment.LEFT);
            titleParagraphRun = paragraph.createRun();
            titleParagraphRun.setText("\u9690\u79c1\u4e0e\u7248\u6743\u58f0\u660e\uff1a");
            titleParagraphRun.setFontSize(12);
            titleParagraphRun.setBold(true);
            titleParagraphRun.setFontFamily("\u5b8b\u4f53");
            paragraph = document.createParagraph();
            paragraph.setAlignment(ParagraphAlignment.LEFT);
            titleParagraphRun = paragraph.createRun();
            titleParagraphRun.setText("1\u3001\u62a5\u544a\u7f16\u53f7\u7cfb\u9001\u68c0\u6587\u6863\u67e5\u91cd\u62a5\u544a\u5728\u672c\u7cfb\u7edf\u4e2d\u7684\u552f\u4e00\u7f16\u53f7\u3002");
            titleParagraphRun.setFontSize(12);
            titleParagraphRun.setFontFamily("\u5b8b\u4f53");
            paragraph = document.createParagraph();
            paragraph.setAlignment(ParagraphAlignment.LEFT);
            titleParagraphRun = paragraph.createRun();
            titleParagraphRun.setText("2\u3001\u672c\u62a5\u544a\u4e3a\u7cfb\u7edf\u7b97\u6cd5\u81ea\u52a8\u751f\u6210\uff0c\u4ec5\u5bf9\u60a8\u6240\u9009\u62e9\u6bd4\u5bf9\u8d44\u6e90\u8303\u56f4\u5185\u68c0\u9a8c\u7ed3\u679c\u8d1f\u8d23\uff0c\u4ec5\u4f9b\u53c2\u8003\u3002");
            titleParagraphRun.setFontSize(12);
            titleParagraphRun.setFontFamily("\u5b8b\u4f53");
            paragraph = document.createParagraph();
            paragraph.setAlignment(ParagraphAlignment.LEFT);
            titleParagraphRun = paragraph.createRun();
            titleParagraphRun.setText("3\u3001\u300a\u67e5\u91cd\u62a5\u544a\u300b\u5c0a\u91cd\u5e76\u4fdd\u62a4\u6240\u6709\u4f7f\u7528\u670d\u52a1\u7528\u6237\u7684\u4e2a\u4eba\u9690\u79c1\u6743\u3002\u4e3a\u4e86\u7ed9\u60a8\u63d0\u4f9b\u66f4\u51c6\u786e\u3001\u66f4\u6709\u4e2a\u6027\u5316\u7684\u670d\u52a1\uff0c\u300a\u67e5\u91cd\u62a5\u544a\u300b\u4f1a\u6309\u7167\u672c\u9690\u79c1\u6743\u653f\u7b56\u7684\u89c4\u5b9a\u4f7f\u7528\u548c\u62ab\u9732\u60a8\u7684\u4e2a\u4eba\u4fe1\u606f\u3002\u4f46\u300a\u67e5\u91cd\u62a5\u544a\u300b\u5c06\u4ee5\u9ad8\u5ea6\u7684\u52e4\u52c9\u3001\u5ba1\u614e\u4e49\u52a1\u5bf9\u5f85\u8fd9\u4e9b\u4fe1\u606f\u3002\u9664\u672c\u9690\u79c1\u6743\u653f\u7b56\u53e6\u6709\u89c4\u5b9a\u5916\uff0c\u5728\u672a\u5f81\u5f97\u60a8\u4e8b\u5148\u8bb8\u53ef\u7684\u60c5\u51b5\u4e0b\uff0c\u300a\u67e5\u91cd\u62a5\u544a\u300b\u4e0d\u4f1a\u5c06\u8fd9\u4e9b\u4fe1\u606f\u5bf9\u5916\u62ab\u9732\u6216\u5411\u7b2c\u4e09\u65b9\u63d0\u4f9b\u3002\u300a\u67e5\u91cd\u62a5\u544a\u300b\u4f1a\u4e0d\u65f6\u66f4\u65b0\u672c\u9690\u79c1\u6743\u653f\u7b56\u3002\u60a8\u5728\u540c\u610f\u300a\u67e5\u91cd\u62a5\u544a\u300b\u670d\u52a1\u4f7f\u7528\u534f\u8bae\u4e4b\u65f6\uff0c\u5373\u89c6\u4e3a\u60a8\u5df2\u7ecf\u540c\u610f\u672c\u9690\u79c1\u6743\u653f\u7b56\u5168\u90e8\u5185\u5bb9\u3002\u672c\u9690\u79c1\u6743\u653f\u7b56\u5c5e\u4e8e\u300a\u67e5\u91cd\u62a5\u544a\u300b\u670d\u52a1\u4f7f\u7528\u534f\u8bae\u4e0d\u53ef\u5206\u5272\u7684\u4e00\u90e8\u5206\u3002");
            titleParagraphRun.setFontSize(12);
            titleParagraphRun.setFontFamily("\u5b8b\u4f53");
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            document.write((OutputStream)baos);
            byte[] byArray = baos.toByteArray();
            return byArray;
        }
    }

    @Override
    public DuplicateCheckSimilarityInfo getSimilarityInfo(ContrastQuery query) {
        String docId = query.getUploadDocId();
        if (StringUtils.isEmpty((CharSequence)docId)) {
            return new DuplicateCheckSimilarityInfo();
        }
        DuplicateCheckSimilarityInfo similarityInfo = new DuplicateCheckSimilarityInfo();
        DuplicateCheckDocDto detail = this.docService.detail(docId);
        similarityInfo.setMaxSimilarity(detail.getMaxSimilarity());
        similarityInfo.setDocSimilarity(detail.getDocSimilarity());
        similarityInfo.setCandidateSentenceNum(detail.getCandidateSentenceNum());
        List resultList = detail.getResultList();
        if (CollectionUtils.isEmpty((Collection)resultList)) {
            similarityInfo.setRepeatDocCount(0);
        } else {
            similarityInfo.setRepeatDocCount(resultList.size());
        }
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(DuplicateCheckSentence::getDocId, (Object)docId);
        wrapper.eq(DuplicateCheckSentence::getIgnoreFlag, (Object)"0");
        long count = this.sentenceService.count((Wrapper)wrapper);
        similarityInfo.setIgnoreSentenceCount((int)count);
        DuplicateCheckSentenceQuery sentenceQuery = new DuplicateCheckSentenceQuery();
        sentenceQuery.setDocId(docId);
        sentenceQuery.setSimilarity(Double.valueOf(80.0));
        sentenceQuery.setIgnoreFlag("1");
        sentenceQuery.setPageFlag(false);
        List sentenceList = this.sentenceService.getSentenceList(sentenceQuery).getRecords();
        sentenceList = CollectionUtils.isEmpty((Collection)sentenceList) ? Collections.emptyList() : sentenceList;
        similarityInfo.setLe80PreCount(sentenceList.size());
        similarityInfo.setLe80PreProportion(sentenceList.size() + "/" + detail.getCandidateSentenceNum());
        return similarityInfo;
    }

    @Override
    public Page<DuplicateCheckSimilarSentenceDto> getSimilaritySentence(ContrastQuery query) {
        SentenceDataQuery sentenceDataQuery = new SentenceDataQuery();
        sentenceDataQuery.setDocumentId(query.getUploadDocId());
        sentenceDataQuery.setSimilarity(query.getSimilarity());
        sentenceDataQuery.setPageFlag(false);
        sentenceDataQuery.setSimilarDocId(query.getSimilarDocId());
        sentenceDataQuery.setSentenceId(query.getSentenceId());
        sentenceDataQuery.setCurrent(query.getCurrent());
        sentenceDataQuery.setSize(query.getSize());
        return this.sentenceSelectData.getSimilaritySentence(sentenceDataQuery);
    }

    @Override
    public List<DuplicateCheckResultDto> getSimilarityDoc(String docId) {
        return this.resultService.getSimilarityDoc(docId);
    }

    @Override
    public Page<? extends DuplicateCheckSentence> getSentence(ContrastQuery query) {
        SentenceDataQuery sentenceDataQuery = new SentenceDataQuery();
        sentenceDataQuery.setDocumentId(query.getUploadDocId());
        sentenceDataQuery.setSimilarity(query.getSimilarity());
        sentenceDataQuery.setPageFlag(true);
        sentenceDataQuery.setSize(query.getSize());
        sentenceDataQuery.setCurrent(query.getCurrent());
        return this.sentenceSelectData.getSentence(sentenceDataQuery);
    }

    @Override
    public Page<? extends DuplicateCheckSentence> getCompareSentence(ContrastQuery query) {
        Page<? extends DuplicateCheckSentence> page = this.getSentence(query);
        List sentences = page.getRecords();
        HashMap<String, DuplicateCheckSentence> map = new HashMap<String, DuplicateCheckSentence>();
        ArrayList<String> sentenceIds = new ArrayList<String>();
        for (DuplicateCheckSentence sentence : sentences) {
            sentenceIds.add(sentence.getId());
            map.put(sentence.getId(), sentence);
        }
        query.setSentenceIds(sentenceIds);
        List<DuplicateCheckSimilarSentenceDto> similaritySentenceList = this.getSimilaritySentenceNoPage(query);
        for (DuplicateCheckSimilarSentenceDto similarSentenceDto : similaritySentenceList) {
            DuplicateCheckSentence sentence = (DuplicateCheckSentence)map.get(similarSentenceDto.getSentenceId());
            if (!(sentence instanceof DuplicateCheckSentenceDto)) continue;
            DuplicateCheckSentenceDto sentenceDto = (DuplicateCheckSentenceDto)sentence;
            sentenceDto.addSimilarSentence(similarSentenceDto);
        }
        return page;
    }
}

