/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.icpac.core.view.impl;

import com.jxdinfo.idp.common.base.dto.FileBytesInfo;
import com.jxdinfo.idp.common.entity.util.docparse.location.WordLocation;
import com.jxdinfo.idp.common.util.docparse.MarkHtmlUtil;
import com.jxdinfo.idp.duplicatecheck.api.entity.HighlightLocation;
import com.jxdinfo.idp.icpac.core.view.FrontViewHandler;
import com.jxdinfo.idp.icpac.utils.FilenameUtils;
import com.jxdinfo.idp.icpac.utils.WordConverterUtils;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.multipart.MultipartFile;

public class WordViewHandler
implements FrontViewHandler {
    private static final Logger log = LoggerFactory.getLogger(WordViewHandler.class);

    @Override
    public boolean support(MultipartFile file) {
        if (file == null) {
            return false;
        }
        String filename = file.getOriginalFilename();
        String fileSuffix = FilenameUtils.getFileSuffix(filename);
        return Objects.equals("docx", fileSuffix) || Objects.equals("doc", fileSuffix) || Objects.equals("wps", fileSuffix);
    }

    public Map<String, Object> getLocationInfo(List<? extends HighlightLocation> locationList) throws Exception {
        LinkedHashMap<String, String> matchTextMap = new LinkedHashMap<String, String>();
        LinkedHashMap<String, WordLocation> locationMap = new LinkedHashMap<String, WordLocation>();
        for (HighlightLocation highlightLocation : locationList) {
            String locationJson = highlightLocation.location();
            if (StringUtils.isEmpty((CharSequence)locationJson)) {
                log.error("sentence:{} \u65e0\u6cd5\u83b7\u53d6\u5230\u4f4d\u7f6e\u4fe1\u606f", (Object)highlightLocation.id());
                continue;
            }
            try {
                locationMap.put(highlightLocation.id(), WordLocation.getLocation((String)locationJson));
                matchTextMap.put(highlightLocation.id(), highlightLocation.sentence());
            }
            catch (Exception e) {
                log.error("\u83b7\u53d6{}\u4f4d\u7f6e\u4fe1\u606f\u9519\u8bef", (Object)highlightLocation.sentence(), (Object)e);
            }
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("match", matchTextMap);
        result.put("location", locationMap);
        return result;
    }

    @Override
    public void handleView(HttpServletResponse response, List<? extends HighlightLocation> locationList, MultipartFile file) throws Exception {
        file = WordConverterUtils.doc2Docx(file);
        Map<String, Object> locationInfo = this.getLocationInfo(locationList);
        Map matchTextMap = (Map)locationInfo.get("match");
        Map locationMap = (Map)locationInfo.get("location");
        MarkHtmlUtil util = new MarkHtmlUtil(locationMap, matchTextMap);
        util.execute(response, new FileBytesInfo(file.getBytes(), file.getOriginalFilename(), FilenameUtils.getFileSuffix(file.getOriginalFilename())));
    }

    @Override
    public byte[] handleView(List<? extends HighlightLocation> locationList, MultipartFile file) throws Exception {
        file = WordConverterUtils.doc2Docx(file);
        Map<String, Object> locationInfo = this.getLocationInfo(locationList);
        Map matchTextMap = (Map)locationInfo.get("match");
        Map locationMap = (Map)locationInfo.get("location");
        MarkHtmlUtil util = new MarkHtmlUtil(locationMap, matchTextMap);
        return util.execute(new FileBytesInfo(file.getBytes(), file.getOriginalFilename(), FilenameUtils.getFileSuffix(file.getOriginalFilename())));
    }
}

