/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.icpac.core.asyncexecutor;

import cn.hutool.core.thread.ThreadUtil;
import cn.hutool.core.util.ObjectUtil;
import com.jxdinfo.idp.duplicatecheck.api.call.DuplicatecheckOverInterface;
import com.jxdinfo.idp.icpac.core.asyncexecutor.DuplicateCheckTask;
import com.jxdinfo.idp.icpac.core.asyncexecutor.DuplicatecheckCallTask;
import com.jxdinfo.idp.icpac.core.asyncexecutor.impl.DuplicateCheckTaskFactory;
import com.jxdinfo.idp.icpac.core.context.DuplicateCheckContext;
import com.jxdinfo.idp.icpac.core.entity.DuplicateCheckInfo;
import com.jxdinfo.idp.icpac.core.entity.DuplicateCheckInfoGroup;
import com.jxdinfo.idp.icpac.core.info.DuplicateCheckOperationEnum;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DuplicateCheckTaskGroup
implements Callable<Object> {
    private static final Logger log = LoggerFactory.getLogger(DuplicateCheckTaskGroup.class);
    private final List<DuplicateCheckInfoGroup> checkInfoGroupList;
    private Boolean immediate = false;
    private List<DuplicatecheckOverInterface> censorOverInterfaces;

    public DuplicateCheckTaskGroup(List<DuplicateCheckInfoGroup> checkInfoGroupList) {
        if (checkInfoGroupList == null || CollectionUtils.isEmpty(checkInfoGroupList)) {
            throw new NullPointerException("\u7ed9\u5b9a\u7684\u67e5\u91cd\u4fe1\u606f\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u8fdb\u884c\u4e0b\u4e00\u6b65\u67e5\u91cd");
        }
        this.checkInfoGroupList = checkInfoGroupList;
    }

    public DuplicateCheckTaskGroup(List<DuplicateCheckInfoGroup> checkInfoGroupList, Boolean immediate) {
        if (checkInfoGroupList == null || CollectionUtils.isEmpty(checkInfoGroupList)) {
            throw new NullPointerException("\u7ed9\u5b9a\u7684\u67e5\u91cd\u4fe1\u606f\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u8fdb\u884c\u4e0b\u4e00\u6b65\u67e5\u91cd");
        }
        this.checkInfoGroupList = checkInfoGroupList;
        this.immediate = immediate;
    }

    public DuplicateCheckTaskGroup(List<DuplicateCheckInfoGroup> checkInfoGroupList, Boolean immediate, List<DuplicatecheckOverInterface> censorOverInterfaces) {
        if (checkInfoGroupList == null || CollectionUtils.isEmpty(checkInfoGroupList)) {
            throw new NullPointerException("\u7ed9\u5b9a\u7684\u67e5\u91cd\u4fe1\u606f\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u8fdb\u884c\u4e0b\u4e00\u6b65\u67e5\u91cd");
        }
        this.checkInfoGroupList = checkInfoGroupList;
        this.immediate = immediate;
        this.censorOverInterfaces = censorOverInterfaces;
    }

    @Override
    public Object call() {
        HashMap<DuplicateCheckOperationEnum, List> groupCollection = new HashMap<DuplicateCheckOperationEnum, List>();
        DuplicateCheckContext context = new DuplicateCheckContext();
        context.init(this.checkInfoGroupList);
        for (DuplicateCheckInfoGroup checkInfoGroup : this.checkInfoGroupList) {
            DuplicateCheckOperationEnum operationEnum = checkInfoGroup.getOperationEnum();
            List group = groupCollection.computeIfAbsent(operationEnum, k -> new ArrayList());
            List<DuplicateCheckInfo> infoList = checkInfoGroup.getInfoList();
            for (DuplicateCheckInfo checkInfo : infoList) {
                checkInfo.setContext(context);
                group.add(checkInfo);
            }
        }
        ArrayList<CompletableFuture<Object>> futureList = new ArrayList<CompletableFuture<Object>>();
        for (Map.Entry entry : groupCollection.entrySet()) {
            DuplicateCheckTask checkTask = DuplicateCheckTaskFactory.getTask((DuplicateCheckOperationEnum)((Object)entry.getKey()), this.immediate);
            checkTask.init((List)entry.getValue());
            CompletableFuture<Object> future = CompletableFuture.supplyAsync(() -> {
                try {
                    return checkTask.call();
                }
                catch (Exception e) {
                    return null;
                }
            });
            if (!ObjectUtil.isNotNull(future)) continue;
            futureList.add(future);
        }
        this.waitAllTaskComplete(futureList);
        return null;
    }

    private void waitAllTaskComplete(List<CompletableFuture<Object>> futureList) {
        if (this.immediate.booleanValue() && !CollectionUtils.isEmpty(futureList)) {
            CompletableFuture.allOf(futureList.toArray(new CompletableFuture[0])).join();
        } else {
            DuplicatecheckCallTask task = new DuplicatecheckCallTask(this.censorOverInterfaces, futureList, this.checkInfoGroupList);
            ThreadUtil.execute((Runnable)task);
        }
    }
}

