/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.icpac.api;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.idp.duplicatecheck.api.entity.dto.DuplicateCheckResultDto;
import com.jxdinfo.idp.duplicatecheck.api.entity.dto.DuplicateCheckSentenceDto;
import com.jxdinfo.idp.duplicatecheck.api.entity.dto.DuplicateCheckSimilarSentenceDto;
import com.jxdinfo.idp.duplicatecheck.api.entity.dto.DuplicateCheckSimilarityInfo;
import com.jxdinfo.idp.duplicatecheck.api.entity.dto.GroupDuplicateCheckResponseDto;
import com.jxdinfo.idp.duplicatecheck.api.entity.dto.GroupDuplicateRequestDto;
import com.jxdinfo.idp.duplicatecheck.api.entity.query.ContrastQuery;
import com.jxdinfo.idp.duplicatecheck.api.entity.query.DuplicateDocumentQueryDto;
import com.jxdinfo.idp.duplicatecheck.api.entity.query.SentenceQuery;
import com.jxdinfo.idp.duplicatecheck.api.service.IDuplicateCheckDataService;
import com.jxdinfo.idp.icpac.entity.query.SentenceDataQuery;
import com.jxdinfo.idp.icpac.service.ContrastService;
import com.jxdinfo.idp.icpac.service.DuplicateCheckSentenceService;
import com.jxdinfo.idp.icpac.service.data.SentenceSelectData;
import java.io.IOException;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Component;

@Component
@Primary
public class IDuplicateCheckDataServiceImpl
implements IDuplicateCheckDataService {
    @Resource
    private ContrastService contrastService;
    @Resource
    private SentenceSelectData sentenceSelectData;
    @Resource
    private DuplicateCheckSentenceService duplicateCheckSentenceService;

    public byte[] getStream(ContrastQuery query) throws Exception {
        return this.contrastService.getStream(query);
    }

    public byte[] downloadCheckDuplicateReport(DuplicateDocumentQueryDto duplicateDocumentQueryDto) throws IOException {
        return this.contrastService.downloadCheckDuplicateReport(duplicateDocumentQueryDto.getDocumentId());
    }

    public DuplicateCheckSimilarityInfo getSimilarityInfo(ContrastQuery query) {
        return this.contrastService.getSimilarityInfo(query);
    }

    public Page<DuplicateCheckSentenceDto> getSentence(SentenceQuery sentenceQuery) {
        SentenceDataQuery sentenceDataQuery = new SentenceDataQuery();
        sentenceDataQuery.setDocumentId(sentenceQuery.getDocumentId());
        sentenceDataQuery.setSimilarity(sentenceQuery.getSimilarity());
        sentenceDataQuery.setSimilarDocId(sentenceDataQuery.getSimilarDocId());
        sentenceDataQuery.setPageFlag(sentenceQuery.isPageFlag());
        sentenceDataQuery.setCurrent(sentenceQuery.getCurrent());
        sentenceDataQuery.setSize(sentenceQuery.getSize());
        return this.sentenceSelectData.getSentence(sentenceDataQuery);
    }

    public Page<DuplicateCheckSentenceDto> getSimilaritySentenceWithTopn(SentenceQuery sentenceQuery) {
        SentenceDataQuery sentenceDataQuery = new SentenceDataQuery();
        sentenceDataQuery.setDocumentId(sentenceQuery.getDocumentId());
        sentenceDataQuery.setSimilarity(sentenceQuery.getSimilarity());
        sentenceDataQuery.setSimilarDocId(sentenceDataQuery.getSimilarDocId());
        sentenceDataQuery.setPageFlag(sentenceQuery.isPageFlag());
        sentenceDataQuery.setCurrent(sentenceQuery.getCurrent());
        sentenceDataQuery.setSize(sentenceQuery.getSize());
        sentenceDataQuery.setTopN(sentenceQuery.getTopN());
        sentenceDataQuery.setDocumentIds(sentenceDataQuery.getDocumentIds());
        return this.sentenceSelectData.getSimilaritySentenceWithTopn(sentenceDataQuery);
    }

    public List<GroupDuplicateCheckResponseDto> getSimilarityWithGroup(GroupDuplicateRequestDto requestDto) {
        return this.duplicateCheckSentenceService.getSimilarityWithGroup(requestDto);
    }

    public Page<DuplicateCheckSentenceDto> getSentenceWithMaxSimiSentence(SentenceQuery sentenceQuery) {
        SentenceDataQuery sentenceDataQuery = new SentenceDataQuery();
        sentenceDataQuery.setDocumentId(sentenceQuery.getDocumentId());
        sentenceDataQuery.setSimilarity(sentenceQuery.getSimilarity());
        sentenceDataQuery.setSimilarDocId(sentenceDataQuery.getSimilarDocId());
        sentenceDataQuery.setPageFlag(sentenceQuery.isPageFlag());
        sentenceDataQuery.setCurrent(sentenceQuery.getCurrent());
        sentenceDataQuery.setSize(sentenceQuery.getSize());
        return this.sentenceSelectData.getSentenceWithMaxSimiSentence(sentenceDataQuery);
    }

    public Page<DuplicateCheckResultDto> getSimilarityDocument(DuplicateDocumentQueryDto duplicateDocumentQueryDto) {
        List<DuplicateCheckResultDto> resultList = this.contrastService.getSimilarityDoc(duplicateDocumentQueryDto.getDocumentId());
        Page page = new Page();
        page.setRecords(resultList);
        return page;
    }

    public Page<DuplicateCheckSimilarSentenceDto> getSimilaritySentence(SentenceQuery sentenceQuery) {
        SentenceDataQuery sentenceDataQuery = new SentenceDataQuery();
        sentenceDataQuery.setSentenceId(sentenceQuery.getSentenceId());
        sentenceDataQuery.setSimilarDocId(sentenceQuery.getSimilarDocId());
        sentenceDataQuery.setSimilarity(sentenceQuery.getSimilarity());
        sentenceDataQuery.setPageFlag(sentenceDataQuery.isPageFlag());
        sentenceDataQuery.setCurrent(sentenceQuery.getCurrent());
        sentenceDataQuery.setSize(sentenceQuery.getSize());
        return this.sentenceSelectData.getSimilaritySentence(sentenceDataQuery);
    }
}

