/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.icpac.core.asyncexecutor;

import com.jxdinfo.idp.icpac.core.asyncexecutor.DuplicateCheckTask;
import com.jxdinfo.idp.icpac.core.asyncexecutor.DuplicateCheckTaskExecutor;
import com.jxdinfo.idp.icpac.core.asyncexecutor.impl.DuplicateCheckTaskFactory;
import com.jxdinfo.idp.icpac.core.context.DuplicateCheckContext;
import com.jxdinfo.idp.icpac.core.entity.DuplicateCheckInfo;
import com.jxdinfo.idp.icpac.core.entity.DuplicateCheckInfoGroup;
import com.jxdinfo.idp.icpac.core.info.DuplicateCheckOperationEnum;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DuplicateCheckTaskGroup
implements Callable<Object> {
    private static final Logger log = LoggerFactory.getLogger(DuplicateCheckTaskGroup.class);
    private final List<DuplicateCheckInfoGroup> checkInfoGroupList;

    public DuplicateCheckTaskGroup(List<DuplicateCheckInfoGroup> checkInfoGroupList) {
        if (checkInfoGroupList == null || CollectionUtils.isEmpty(checkInfoGroupList)) {
            throw new NullPointerException("\u7ed9\u5b9a\u7684\u67e5\u91cd\u4fe1\u606f\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u8fdb\u884c\u4e0b\u4e00\u6b65\u67e5\u91cd");
        }
        this.checkInfoGroupList = checkInfoGroupList;
    }

    @Override
    public Object call() {
        HashMap<DuplicateCheckOperationEnum, List> groupCollection = new HashMap<DuplicateCheckOperationEnum, List>();
        DuplicateCheckContext context = new DuplicateCheckContext();
        context.init(this.checkInfoGroupList);
        for (DuplicateCheckInfoGroup duplicateCheckInfoGroup : this.checkInfoGroupList) {
            DuplicateCheckOperationEnum operationEnum = duplicateCheckInfoGroup.getOperationEnum();
            List group = groupCollection.computeIfAbsent(operationEnum, k -> new ArrayList());
            List<DuplicateCheckInfo> infoList = duplicateCheckInfoGroup.getInfoList();
            for (DuplicateCheckInfo checkInfo : infoList) {
                checkInfo.setContext(context);
                group.add(checkInfo);
            }
        }
        for (Map.Entry entry : groupCollection.entrySet()) {
            DuplicateCheckTask checkTask = DuplicateCheckTaskFactory.getTask((DuplicateCheckOperationEnum)((Object)entry.getKey()));
            checkTask.init((List)entry.getValue());
            DuplicateCheckTaskExecutor.executor(checkTask);
        }
        return null;
    }
}

