/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.icpac.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.idp.common.response.ApiResponse;
import com.jxdinfo.idp.duplicatecheck.api.entity.dto.DuplicateCheckProjectDto;
import com.jxdinfo.idp.duplicatecheck.api.entity.po.DuplicateCheckProject;
import com.jxdinfo.idp.duplicatecheck.api.entity.query.DuplicateCheckProjectQuery;
import com.jxdinfo.idp.icpac.service.DuplicateCheckProjectService;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/icpac/multiSimilarity/baseInfo"})
public class DuplicateCheckProjectController {
    private static final Logger log = LoggerFactory.getLogger(DuplicateCheckProjectController.class);
    @Resource
    private DuplicateCheckProjectService service;

    @PostMapping(value={"/insertOrUpdate"})
    public ApiResponse<DuplicateCheckProjectDto> insertOrUpdate(@RequestBody DuplicateCheckProjectDto baseInfoDto) {
        return ApiResponse.success((Object)this.service.insertOrUpdate(baseInfoDto));
    }

    @PostMapping(value={"/listDocLibrary"})
    public ApiResponse<List<DuplicateCheckProjectDto>> listDocLibrary(@RequestBody DuplicateCheckProjectQuery projectDto) throws Exception {
        try {
            List<DuplicateCheckProjectDto> list = this.service.listDocLibrary(projectDto);
            return ApiResponse.success(list);
        }
        catch (Exception e) {
            log.error("\u521b\u5efa\u6587\u4ef6\u5e93\u5f02\u5e38", (Throwable)e);
            return ApiResponse.fail((String)"\u670d\u52a1\u67e5\u91cd\u63a5\u53e3\u51fa\u73b0\u5f02\u5e38");
        }
    }

    @PostMapping(value={"/delete"})
    public ApiResponse<Boolean> delete(@RequestBody List<String> ids) {
        return ApiResponse.success((Object)this.service.delete(ids));
    }

    @PostMapping(value={"/list"})
    public ApiResponse<Page<? extends DuplicateCheckProject>> list(@RequestBody DuplicateCheckProjectQuery query) {
        return ApiResponse.success(this.service.list(query));
    }

    @PostMapping(value={"/uniqueName"})
    public ApiResponse<List<DuplicateCheckProject>> uniqueName(@RequestBody DuplicateCheckProjectDto projectInfo) {
        return ApiResponse.success(this.service.uniqueName(projectInfo));
    }

    @GetMapping(value={"/detail/{id}"})
    public ApiResponse<? extends DuplicateCheckProject> detail(@PathVariable(value="id") String id) {
        return ApiResponse.success((Object)this.service.detailWithConfigInfo(id));
    }
}

