/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.icpac.service.impl;

import com.jxdinfo.idp.common.base.dto.FileBytesInfo;
import com.jxdinfo.idp.dio.service.DocInfoIoService;
import com.jxdinfo.idp.duplicatecheck.api.entity.dto.DuplicateCheckDocDto;
import com.jxdinfo.idp.duplicatecheck.api.entity.dto.DuplicateCheckProjectDto;
import com.jxdinfo.idp.icpac.core.asyncexecutor.DuplicateCheckTask;
import com.jxdinfo.idp.icpac.core.asyncexecutor.DuplicateCheckTaskExecutor;
import com.jxdinfo.idp.icpac.core.entity.DuplicateCheckInfo;
import com.jxdinfo.idp.icpac.core.info.DuplicateCheckExecuteModelEnum;
import com.jxdinfo.idp.icpac.core.info.DuplicateCheckOperationEnum;
import com.jxdinfo.idp.icpac.service.DuplicateCheckDocService;
import com.jxdinfo.idp.icpac.service.DuplicateCheckExecutorService;
import com.jxdinfo.idp.icpac.service.DuplicateCheckProjectService;
import com.jxdinfo.idp.icpac.service.handler.resulthandler.DefaultResultHandler;
import com.jxdinfo.idp.icpac.service.handler.resulthandler.NotifyResultHandler;
import com.jxdinfo.idp.icpac.service.handler.sentencehandler.SentenceHandlerManagement;
import com.jxdinfo.idp.icpac.utils.DuplicateCheckProgress;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.mock.web.MockMultipartFile;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class DuplicateCheckExecutorServiceImpl
implements DuplicateCheckExecutorService {
    @Resource
    private DuplicateCheckDocService docService;
    @Resource
    private DuplicateCheckProjectService projectService;
    @Resource
    private DocInfoIoService ioService;

    private DuplicateCheckTask prepareCheckDuplicate(DuplicateCheckDocDto docInfo) throws Exception {
        String documentId = docInfo.getId();
        if (StringUtils.isEmpty((CharSequence)documentId)) {
            throw new RuntimeException("\u6ca1\u6709\u7ed9\u5b9adocId\uff0c\u65e0\u6cd5\u9884\u652f\u6267\u884c\u67d0\u4e2a\u67e5\u91cd");
        }
        DuplicateCheckProgress.setProgress(documentId, 0);
        docInfo = this.docService.simpleDetail(documentId);
        FileBytesInfo fileBytesInfo = this.ioService.getFileBytesInfo(docInfo.getFileId());
        MockMultipartFile file = new MockMultipartFile(fileBytesInfo.getFileName(), fileBytesInfo.getFileName(), null, fileBytesInfo.getFileBytes());
        DuplicateCheckProjectDto projectDto = this.projectService.detailWithConfigInfo(docInfo.getProjectId());
        DuplicateCheckInfo checkInfo = new DuplicateCheckInfo(documentId, (MultipartFile)file, projectDto.getSimilarityBounds(), projectDto.getWordLength(), DuplicateCheckOperationEnum.CHECK, SentenceHandlerManagement.get((MultipartFile)file));
        checkInfo.addAttachment("chapterConfig", projectDto.getChapterList());
        checkInfo.addAttachment("docId", documentId);
        checkInfo.addAttachment("projectId", projectDto.getId());
        checkInfo.addAttachment("chooseIdList", new ArrayList());
        checkInfo.addAttachment("simThresh", projectDto.getSimilarityBounds());
        String updateLib = docInfo.getUpdateLib();
        checkInfo.addAttachment("updateLib", updateLib);
        if (Objects.equals(updateLib, "1")) {
            return new DuplicateCheckTask(checkInfo, new NotifyResultHandler(this.docService));
        }
        return new DuplicateCheckTask(checkInfo, new DefaultResultHandler(this.docService));
    }

    @Override
    public void asyncCheckDuplicate(DuplicateCheckDocDto docInfo) throws Exception {
        DuplicateCheckTask duplicateCheckTask = this.prepareCheckDuplicate(docInfo);
        DuplicateCheckTaskExecutor.executor(duplicateCheckTask);
    }

    @Override
    public void syncCheckDuplicate(DuplicateCheckDocDto docInfo) throws Exception {
        DuplicateCheckTask duplicateCheckTask = this.prepareCheckDuplicate(docInfo);
        duplicateCheckTask.run();
    }

    @Override
    public void notifyCheckServer(DuplicateCheckDocDto docInfo) throws Exception {
        DuplicateCheckTask duplicateCheckTask = this.prepareCheckDuplicate(docInfo);
        duplicateCheckTask.run();
    }

    @Override
    public void batchCheckDuplicate(List<DuplicateCheckDocDto> dcDocInfoList, String model) {
        DuplicateCheckExecuteModelEnum executeModel = DuplicateCheckExecuteModelEnum.getModel(model);
        for (DuplicateCheckDocDto duplicateCheckDocDto : dcDocInfoList) {
            if (DuplicateCheckExecuteModelEnum.SYNC != executeModel) continue;
        }
    }
}

