/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.icpac.core.process;

import com.jxdinfo.idp.icpac.core.entity.DuplicateCheckCandidateSentence;
import com.jxdinfo.idp.icpac.core.entity.DuplicateCheckInfo;
import com.jxdinfo.idp.icpac.core.process.DuplicateCheckDocProcess;
import com.jxdinfo.idp.icpac.core.process.DuplicateCheckProcessRegister;
import com.jxdinfo.idp.icpac.core.rmi.DefaultDuplicateCheckRmi;
import com.jxdinfo.idp.icpac.core.rmi.resp.DuplicateCheckResponse;
import com.jxdinfo.idp.icpac.utils.DuplicateCheckProgress;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDuplicateCheckDocProcess
implements DuplicateCheckDocProcess {
    private static final Logger log = LoggerFactory.getLogger(AbstractDuplicateCheckDocProcess.class);
    @Resource
    private DefaultDuplicateCheckRmi defaultCheckRmi;

    public AbstractDuplicateCheckDocProcess() {
        DuplicateCheckProcessRegister.register(this);
    }

    @Override
    public DuplicateCheckResponse checkRepeat(DuplicateCheckInfo checkInfo) throws Exception {
        DuplicateCheckProgress.setProgress(checkInfo.getCheckId(), 5);
        List<DuplicateCheckCandidateSentence> candidateSentenceList = this.getCandidateSentence(checkInfo);
        if (CollectionUtils.isEmpty(candidateSentenceList)) {
            log.info(checkInfo.getFileName() + "\uff1a\u83b7\u53d6\u5f85\u67e5\u91cd\u7684\u53e5\u5b50\u6761\u6570\u4e3a0,\u65e0\u6cd5\u8fdb\u884c\u67e5\u91cd\uff0c\u67e5\u91cd\u7ed3\u675f");
            return null;
        }
        checkInfo.setCandidateSentenceList(candidateSentenceList);
        checkInfo.setCandidateSentenceNum(candidateSentenceList.size());
        return this.defaultCheckRmi.checkRepeat(checkInfo);
    }

    protected abstract List<DuplicateCheckCandidateSentence> getCandidateSentence(DuplicateCheckInfo var1) throws Exception;

    @Override
    public void addIgnoreSentence(DuplicateCheckInfo info) {
        this.defaultCheckRmi.addIgnoreSentence(info);
    }

    @Override
    public void deleteRemoteDoc(DuplicateCheckInfo checkInfo) {
        this.defaultCheckRmi.deleteRemoteDoc(checkInfo);
    }
}

