/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.icpac.core.asyncexecutor;

import com.jxdinfo.idp.icpac.core.asyncexecutor.DefaultThreadFactory;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DuplicateCheckTaskExecutor {
    private static final Logger log = LoggerFactory.getLogger(DuplicateCheckTaskExecutor.class);
    private static final int DEFAULT_THREAD_POOL_SIZE = 2;
    private static final double DEFAULT_PROCESS_RATE = 0.3;
    private static final ThreadPoolExecutor EXECUTOR;

    public static void executor(Runnable task) {
        EXECUTOR.submit(task);
    }

    static {
        int processors = Runtime.getRuntime().availableProcessors();
        int threadPoolSize = (int)Math.floor((double)processors * 0.3);
        if (threadPoolSize == 0) {
            threadPoolSize = 2;
        }
        EXECUTOR = new ThreadPoolExecutor(10, 10, 60L, TimeUnit.MINUTES, new LinkedBlockingQueue<Runnable>(), new DefaultThreadFactory(), new ThreadPoolExecutor.CallerRunsPolicy());
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            log.info("\u5f00\u59cb\u5173\u95ed\u5ba1\u67e5\u4efb\u52a1\u7ebf\u7a0b\u6c60");
            if (!EXECUTOR.isShutdown()) {
                EXECUTOR.shutdownNow();
            }
            log.info("\u5ba1\u67e5\u4efb\u52a1\u7ebf\u7a0b\u6c60\u5173\u95ed\u7ed3\u675f");
        }));
    }
}

