/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.icpac.core.asyncexecutor;

import com.jxdinfo.idp.icpac.core.entity.DuplicateCheckInfo;
import com.jxdinfo.idp.icpac.core.entity.DuplicateCheckResult;
import com.jxdinfo.idp.icpac.core.handler.DuplicateCheckResultHandler;
import com.jxdinfo.idp.icpac.core.process.DuplicateCheckDocProcess;
import com.jxdinfo.idp.icpac.core.process.DuplicateCheckProcessRegister;
import com.jxdinfo.idp.icpac.core.rmi.resp.DuplicateCheckResponse;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DuplicateCheckTask
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(DuplicateCheckTask.class);
    private final DuplicateCheckInfo checkInfo;
    private final DuplicateCheckResultHandler resultHandler;
    private final DuplicateCheckDocProcess process;

    public DuplicateCheckTask(DuplicateCheckInfo checkInfo, DuplicateCheckResultHandler resultHandler) {
        if (checkInfo == null) {
            throw new NullPointerException("\u7ed9\u5b9a\u7684\u67e5\u91cd\u4fe1\u606f\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u8fdb\u884c\u4e0b\u4e00\u6b65\u67e5\u91cd");
        }
        this.checkInfo = checkInfo;
        this.resultHandler = resultHandler;
        this.process = DuplicateCheckProcessRegister.get(checkInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        block21: {
            log.info("\u67e5\u8be2\u4efb\u52a1\u6267\u884c\u5f00\u59cb\uff0c\u5f53\u524d\u7684\u64cd\u4f5c\u4e3a\uff1a" + (Object)((Object)this.checkInfo.getOperationEnum()));
            DuplicateCheckResult checkResult = new DuplicateCheckResult();
            checkResult.setInfo(this.checkInfo);
            try {
                switch (this.checkInfo.getOperationEnum()) {
                    case CHECK: {
                        DuplicateCheckResponse response = this.process.checkRepeat(this.checkInfo);
                        checkResult.setExecutionResult(response);
                        break;
                    }
                    case DELETE: {
                        this.process.deleteRemoteDoc(this.checkInfo);
                        break;
                    }
                    case IGNORE: {
                        this.process.addIgnoreSentence(this.checkInfo);
                        break;
                    }
                }
                if (this.resultHandler == null) break block21;
                try {
                    this.resultHandler.handleResult(checkResult);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            catch (Exception e) {
                log.error("\u5ba1\u67e5\u51fa\u73b0\u95ee\u9898\uff0c\u5ba1\u67e5\u4fe1\u606f\u4e3a", (Throwable)e);
                checkResult.setError(e);
                if (this.resultHandler == null) break block21;
                try {
                    this.resultHandler.handleResult(checkResult);
                }
                catch (Exception ex) {
                    throw new RuntimeException(ex);
                }
            }
            finally {
                if (this.checkInfo.getFile() != null) {
                    try {
                        this.checkInfo.getFile().getInputStream().close();
                    }
                    catch (IOException iOException) {}
                }
                log.info("\u67e5\u8be2\u4efb\u52a1\u6267\u884c\u5b8c\u6bd5");
            }
        }
    }
}

