/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.icpac.core.storage;

import com.jxdinfo.idp.icpac.core.call.DuplicatecheckOverInterface;
import com.jxdinfo.idp.icpac.core.enmus.DuplicateCheckExecuteModelEnum;
import com.jxdinfo.idp.icpac.core.enmus.DuplicateCheckModelEnum;
import com.jxdinfo.idp.icpac.core.enmus.DuplicateCheckOperationEnum;
import com.jxdinfo.idp.icpac.core.enmus.DuplicateCheckUpdateModelEnum;
import com.jxdinfo.idp.icpac.core.entity.DuplicateCheckChapterConfig;
import com.jxdinfo.idp.icpac.core.handler.DuplicateCheckCandidateElementPostProcessor;
import com.jxdinfo.idp.icpac.core.handler.DuplicateCheckGroupResultHandler;
import com.jxdinfo.idp.icpac.core.handler.DuplicateCheckResultHandler;
import com.jxdinfo.idp.icpac.core.handler.DuplicateCheckResultPersistence;
import com.jxdinfo.idp.icpac.core.handler.highrisk.DuplicateCheckHighRiskDetector;
import com.jxdinfo.idp.icpac.core.handler.resultfilter.DuplicateCheckResultFilter;
import com.jxdinfo.idp.icpac.core.handler.sentencehandler.DuplicateCheckCandidateElementExtractor;
import com.jxdinfo.idp.icpac.core.paramconfig.DefaultParamConfig;
import com.jxdinfo.idp.icpac.core.progress.DuplicateCheckProgress;
import com.jxdinfo.idp.icpac.core.storage.DuplicateCheckCandidateDocument;
import com.jxdinfo.idp.icpac.core.storage.DuplicateCheckCandidateGroup;
import com.jxdinfo.idp.icpac.core.storage.DuplicateCheckParamConfiguration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DuplicateCheckContext {
    private static final Logger log = LoggerFactory.getLogger(DuplicateCheckContext.class);
    private volatile CyclicBarrier cyclicBarrier;
    private volatile CountDownLatch countDownLatch;
    private ThreadPoolExecutor taskThreadPool;
    private DuplicateCheckResultPersistence resultPersistence;
    private List<DuplicateCheckCandidateGroup> candidateGroupList;
    private DuplicateCheckParamConfiguration paramConfiguration;
    private DuplicateCheckExecuteModelEnum executorModelEnum;
    private DuplicateCheckModelEnum checkModel;
    private List<DuplicatecheckOverInterface> censorOverInterfaces = new ArrayList<DuplicatecheckOverInterface>();
    private DuplicateCheckGroupResultHandler groupResultHandler;
    private DuplicateCheckOperationEnum operationModel;
    Map<DuplicateCheckOperationEnum, List<DuplicateCheckCandidateDocument>> operationClassifiers;
    private List<String> documentIdList;
    private long startTime;
    private String libId;

    public DuplicateCheckContext() {
        this.candidateGroupList = new ArrayList<DuplicateCheckCandidateGroup>();
        this.checkModel = DuplicateCheckModelEnum.VECTORIZATION;
        this.operationClassifiers = new HashMap<DuplicateCheckOperationEnum, List<DuplicateCheckCandidateDocument>>();
    }

    public DuplicateCheckResultPersistence getResultPersistence() {
        return this.resultPersistence == null ? null : this.resultPersistence;
    }

    public void waitOthers() {
        try {
            this.cyclicBarrier.await();
        }
        catch (Exception e) {
            log.error("\u7b49\u5f85\u5176\u4ed6\u7ebf\u7a0b\u5411\u91cf\u5316\u51fa\u73b0\u9519\u8bef", (Throwable)e);
        }
        log.info("\u5f53\u524d\u5b8c\u6210\u4efb\u52a1\u7684\u7ebf\u7a0b\u4e3a\uff1a{}", (Object)Thread.currentThread().getName());
    }

    public void completeOperation() {
        this.countDownLatch.countDown();
    }

    public void waitCompleteByOperation() {
        try {
            this.countDownLatch.await();
        }
        catch (InterruptedException e) {
            log.error("\u7b49\u5f85\u5168\u90e8\u4efb\u52a1\u6267\u884c\u5b8c\u6bd5\u8d85\u65f6", (Throwable)e);
        }
    }

    public void init() {
        this.validate();
        Double simThresh = this.paramConfiguration.getSimThresh();
        if (simThresh == null) {
            this.paramConfiguration.setSimThresh(DefaultParamConfig.SIM_DIFF_THRESH);
        }
        if (this.paramConfiguration.getMinTableLength() == null) {
            this.paramConfiguration.setMinTableLength(DefaultParamConfig.tableWordLength);
        }
        if (this.paramConfiguration.getMinTextLength() == null) {
            this.paramConfiguration.setMinTextLength(DefaultParamConfig.wordLength);
        }
        this.startTime = System.currentTimeMillis();
        if (this.isHandle()) {
            this.handleGroup();
        }
        this.classifyOperation();
        this.combineDeleteCheck();
        this.initProcess();
        this.initThreadControl();
    }

    private void handleGroup() {
        HashMap groupIdWithDocumentIdList = new HashMap();
        for (DuplicateCheckCandidateGroup candidateGroup : this.candidateGroupList) {
            groupIdWithDocumentIdList.put(candidateGroup.getGroupId(), candidateGroup.getCandidateDocumentList().stream().map(DuplicateCheckCandidateDocument::getDocumentId).collect(Collectors.toList()));
        }
        for (DuplicateCheckCandidateGroup candidateGroup : this.candidateGroupList) {
            List documentId = (List)groupIdWithDocumentIdList.get(candidateGroup.getGroupId());
            candidateGroup.addAllExcludeDocumentId(documentId);
            for (Map.Entry entry : groupIdWithDocumentIdList.entrySet()) {
                String groupId = (String)entry.getKey();
                if (Objects.equals(candidateGroup.getGroupId(), entry.getKey())) continue;
                candidateGroup.addAllChooseDocumentId((List)entry.getValue());
            }
        }
    }

    private boolean isHandle() {
        DuplicateCheckOperationEnum operationModel = this.getOperationModel();
        if (operationModel != DuplicateCheckOperationEnum.CHECK) {
            return false;
        }
        if (this.candidateGroupList.size() == 1) {
            return false;
        }
        for (DuplicateCheckCandidateGroup candidateGroup : this.candidateGroupList) {
            if (!CollectionUtils.isNotEmpty(candidateGroup.getChooseDocumentIdList()) && !CollectionUtils.isNotEmpty(candidateGroup.getExcludeDocumentIdList())) continue;
            return false;
        }
        return true;
    }

    private void initProcess() {
        for (List<DuplicateCheckCandidateDocument> candidateDocuments : this.operationClassifiers.values()) {
            for (DuplicateCheckCandidateDocument candidateDocument : candidateDocuments) {
                try {
                    DuplicateCheckProgress.setProgress(candidateDocument.getDocumentId(), 0);
                }
                catch (Exception e) {
                    log.error("{}\uff1a\u8fdb\u5ea6\u521d\u59cb\u5316\u5931\u8d25\u3002\u3002", (Object)candidateDocument.getFileName(), (Object)e);
                }
            }
        }
    }

    private void combineDeleteCheck() {
        List<DuplicateCheckCandidateDocument> deleteCandidateDocumentList = this.operationClassifiers.get((Object)DuplicateCheckOperationEnum.DELETE);
        ArrayList<String> candidateDeleteDocumentIdList = new ArrayList<String>();
        if (CollectionUtils.isNotEmpty(deleteCandidateDocumentList)) {
            for (DuplicateCheckCandidateDocument deleteCandidateDocument : deleteCandidateDocumentList) {
                candidateDeleteDocumentIdList.add(deleteCandidateDocument.getDocumentId());
            }
            DuplicateCheckCandidateDocument candidateDocument = deleteCandidateDocumentList.get(0);
            candidateDocument.addAttachment("uploadIds", candidateDeleteDocumentIdList);
            this.operationClassifiers.put(DuplicateCheckOperationEnum.DELETE, Arrays.asList(candidateDocument));
        }
    }

    private void initThreadControl() {
        List<DuplicateCheckCandidateDocument> checkCandidateDocumentList = this.operationClassifiers.get((Object)DuplicateCheckOperationEnum.CHECK);
        int needCheckCount = 0;
        if (CollectionUtils.isNotEmpty(checkCandidateDocumentList)) {
            for (DuplicateCheckCandidateDocument checkCandidateDocument : checkCandidateDocumentList) {
                DuplicateCheckUpdateModelEnum updateModel = checkCandidateDocument.getUpdateModel();
                if (updateModel == null || updateModel == DuplicateCheckUpdateModelEnum.NO_PERSIST) continue;
                ++needCheckCount;
            }
            this.cyclicBarrier = new CyclicBarrier(needCheckCount);
        }
        int taskCount = 0;
        for (Map.Entry<DuplicateCheckOperationEnum, List<DuplicateCheckCandidateDocument>> operation : this.operationClassifiers.entrySet()) {
            taskCount = operation.getValue().size() + taskCount;
        }
        this.countDownLatch = new CountDownLatch(taskCount);
        this.taskThreadPool = new ThreadPoolExecutor(taskCount, taskCount, 60L, TimeUnit.MINUTES, new LinkedBlockingQueue<Runnable>(), new DefaultThreadFactory(), new ThreadPoolExecutor.AbortPolicy());
    }

    private void classifyOperation() {
        for (DuplicateCheckCandidateGroup candidateGroup : this.candidateGroupList) {
            List<DuplicateCheckCandidateDocument> candidateDocumentList = candidateGroup.getCandidateDocumentList();
            for (DuplicateCheckCandidateDocument candidateDocument : candidateDocumentList) {
                DuplicateCheckOperationEnum operationModel = candidateDocument.getOperationModel();
                this.operationClassifiers.computeIfAbsent(operationModel, k -> new ArrayList()).add(candidateDocument);
            }
        }
    }

    public void addCandidateGroup(DuplicateCheckCandidateGroup candidateGroup) {
        candidateGroup.setContext(this);
        this.candidateGroupList.add(candidateGroup);
    }

    public void addAllCandidateGroup(List<DuplicateCheckCandidateGroup> candidateGroupList) {
        for (DuplicateCheckCandidateGroup candidateGroup : candidateGroupList) {
            this.addCandidateGroup(candidateGroup);
        }
    }

    public void validate() {
        if (CollectionUtils.isEmpty(this.candidateGroupList)) {
            throw new RuntimeException("\u672a\u627e\u5230\u4efb\u4f55\u9700\u8981\u67e5\u91cd\u7684\u5206\u7ec4\u4fe1\u606f\u3002\u3002\u3002\u3002\u3002\u3002\u3002");
        }
        for (DuplicateCheckCandidateGroup candidateGroup : this.candidateGroupList) {
            boolean result = candidateGroup.isParamConfigurationNull();
            if (!result || this.paramConfiguration != null) continue;
            throw new RuntimeException("\u672a\u914d\u7f6e\u4efb\u4f55\u6709\u6548\u5f97\u5173\u952e\u4fe1\u606f");
        }
    }

    public boolean isDuplicateImageFlag() {
        Boolean duplicateImageFlag;
        if (this.paramConfiguration != null && (duplicateImageFlag = this.paramConfiguration.getDuplicateImageFlag()) != null) {
            return duplicateImageFlag;
        }
        return false;
    }

    public Double getSimThresh() {
        Double simThresh;
        if (this.paramConfiguration != null && (simThresh = this.paramConfiguration.getSimThresh()) != null) {
            return simThresh;
        }
        return 80.0;
    }

    public DuplicateCheckUpdateModelEnum getUpdateModel() {
        DuplicateCheckUpdateModelEnum updateModel;
        if (this.paramConfiguration != null && (updateModel = this.paramConfiguration.getUpdateModel()) != null) {
            return updateModel;
        }
        throw new RuntimeException("\u6ca1\u6709\u6307\u5b9a\u8be5\u6587\u6863\u7c7b\u578b\u662f\u65b9\u5f0f");
    }

    public DuplicateCheckCandidateElementExtractor getCandidateElementExtractor() {
        return this.paramConfiguration.getCandidateElementExtractor();
    }

    public DuplicateCheckGroupResultHandler getDuplicateCheckGroupResultHandler() {
        return this.groupResultHandler == null ? null : (DuplicateCheckGroupResultHandler)this.groupResultHandler.cloneObject();
    }

    public void clear() {
        this.taskThreadPool.shutdownNow();
        log.info("\u505c\u6b62\u7ebf\u7a0b\u6c60");
    }

    public DuplicateCheckResultHandler getResultHandler() {
        DuplicateCheckResultHandler resultHandler;
        if (this.paramConfiguration != null && (resultHandler = this.paramConfiguration.getResultHandler()) != null) {
            return resultHandler;
        }
        return null;
    }

    public List<DuplicateCheckCandidateElementPostProcessor> getCandidateElementPostProcessorList() {
        if (this.paramConfiguration != null) {
            return this.paramConfiguration.getCandidateElementPostProcessorList();
        }
        return null;
    }

    public void addCensorOver(DuplicatecheckOverInterface censorOver) {
        this.censorOverInterfaces.add(censorOver);
    }

    public void addAllCensorOver(List<DuplicatecheckOverInterface> censorOverList) {
        if (CollectionUtils.isNotEmpty(this.censorOverInterfaces)) {
            this.censorOverInterfaces.addAll(censorOverList);
        }
    }

    public List<DuplicateCheckResultFilter> getCheckResultFilter() {
        List<DuplicateCheckResultFilter> checkResultFilterList;
        if (this.paramConfiguration != null && CollectionUtils.isNotEmpty(checkResultFilterList = this.paramConfiguration.getCheckResultFilterList())) {
            return checkResultFilterList;
        }
        return null;
    }

    public List<DuplicateCheckHighRiskDetector> getHighRiskDetectorList() {
        List<DuplicateCheckHighRiskDetector> riskDetectorList;
        if (this.paramConfiguration != null && CollectionUtils.isNotEmpty(riskDetectorList = this.paramConfiguration.getHighRiskDetectorList())) {
            return riskDetectorList;
        }
        return null;
    }

    public List<String> getTemplateTextList() {
        List<String> templateTextList;
        if (this.paramConfiguration != null && com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(templateTextList = this.paramConfiguration.getTemplateTextList())) {
            return templateTextList;
        }
        return null;
    }

    public int getMinTextLength() {
        Integer minTextLength;
        if (this.paramConfiguration != null && (minTextLength = this.paramConfiguration.getMinTextLength()) != null) {
            return minTextLength;
        }
        return -1;
    }

    public int getMinTableLength() {
        Integer minTableLength;
        if (this.paramConfiguration != null && (minTableLength = this.paramConfiguration.getMinTableLength()) != null) {
            return minTableLength;
        }
        return -1;
    }

    public List<DuplicateCheckChapterConfig> getChapterConfig() {
        if (this.paramConfiguration != null) {
            return this.paramConfiguration.getChapterConfigList();
        }
        return null;
    }

    public Boolean isTextSegmentation() {
        if (this.paramConfiguration != null) {
            return this.paramConfiguration.getTextSegmentation();
        }
        return null;
    }

    public String getChapterMatchType() {
        String chapterMatchType;
        if (this.paramConfiguration != null && StringUtils.isNotEmpty((CharSequence)(chapterMatchType = this.paramConfiguration.getChapterMatchType()))) {
            return chapterMatchType;
        }
        return null;
    }

    public List<String> getAllDocumentIdList() {
        return this.documentIdList;
    }

    public List<DuplicateCheckCandidateDocument> getAllCandidateDocumentList() {
        if (this.operationClassifiers == null || this.operationClassifiers.size() == 0) {
            return new ArrayList<DuplicateCheckCandidateDocument>();
        }
        Collection<List<DuplicateCheckCandidateDocument>> allTaskCollection = this.operationClassifiers.values();
        ArrayList<DuplicateCheckCandidateDocument> candidateDocumentList = new ArrayList<DuplicateCheckCandidateDocument>();
        for (List<DuplicateCheckCandidateDocument> task : allTaskCollection) {
            candidateDocumentList.addAll(task);
        }
        return candidateDocumentList;
    }

    public String getTemplateProjectId() {
        String templateProjectId;
        if (this.paramConfiguration != null && StringUtils.isNotEmpty((CharSequence)(templateProjectId = this.paramConfiguration.getTemplateLibId()))) {
            return templateProjectId;
        }
        return "";
    }

    public List<String> getExcludeLibList() {
        List<String> excludeRegList;
        if (this.paramConfiguration != null && CollectionUtils.isNotEmpty(excludeRegList = this.paramConfiguration.getExcludeRegList())) {
            return excludeRegList;
        }
        return null;
    }

    public CyclicBarrier getCyclicBarrier() {
        return this.cyclicBarrier;
    }

    public CountDownLatch getCountDownLatch() {
        return this.countDownLatch;
    }

    public ThreadPoolExecutor getTaskThreadPool() {
        return this.taskThreadPool;
    }

    public List<DuplicateCheckCandidateGroup> getCandidateGroupList() {
        return this.candidateGroupList;
    }

    public DuplicateCheckParamConfiguration getParamConfiguration() {
        return this.paramConfiguration;
    }

    public DuplicateCheckExecuteModelEnum getExecutorModelEnum() {
        return this.executorModelEnum;
    }

    public DuplicateCheckModelEnum getCheckModel() {
        return this.checkModel;
    }

    public List<DuplicatecheckOverInterface> getCensorOverInterfaces() {
        return this.censorOverInterfaces;
    }

    public DuplicateCheckGroupResultHandler getGroupResultHandler() {
        return this.groupResultHandler;
    }

    public DuplicateCheckOperationEnum getOperationModel() {
        return this.operationModel;
    }

    public Map<DuplicateCheckOperationEnum, List<DuplicateCheckCandidateDocument>> getOperationClassifiers() {
        return this.operationClassifiers;
    }

    public List<String> getDocumentIdList() {
        return this.documentIdList;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public String getLibId() {
        return this.libId;
    }

    public void setCyclicBarrier(CyclicBarrier cyclicBarrier) {
        this.cyclicBarrier = cyclicBarrier;
    }

    public void setCountDownLatch(CountDownLatch countDownLatch) {
        this.countDownLatch = countDownLatch;
    }

    public void setTaskThreadPool(ThreadPoolExecutor taskThreadPool) {
        this.taskThreadPool = taskThreadPool;
    }

    public void setResultPersistence(DuplicateCheckResultPersistence resultPersistence) {
        this.resultPersistence = resultPersistence;
    }

    public void setCandidateGroupList(List<DuplicateCheckCandidateGroup> candidateGroupList) {
        this.candidateGroupList = candidateGroupList;
    }

    public void setParamConfiguration(DuplicateCheckParamConfiguration paramConfiguration) {
        this.paramConfiguration = paramConfiguration;
    }

    public void setExecutorModelEnum(DuplicateCheckExecuteModelEnum executorModelEnum) {
        this.executorModelEnum = executorModelEnum;
    }

    public void setCheckModel(DuplicateCheckModelEnum checkModel) {
        this.checkModel = checkModel;
    }

    public void setCensorOverInterfaces(List<DuplicatecheckOverInterface> censorOverInterfaces) {
        this.censorOverInterfaces = censorOverInterfaces;
    }

    public void setGroupResultHandler(DuplicateCheckGroupResultHandler groupResultHandler) {
        this.groupResultHandler = groupResultHandler;
    }

    public void setOperationModel(DuplicateCheckOperationEnum operationModel) {
        this.operationModel = operationModel;
    }

    public void setOperationClassifiers(Map<DuplicateCheckOperationEnum, List<DuplicateCheckCandidateDocument>> operationClassifiers) {
        this.operationClassifiers = operationClassifiers;
    }

    public void setDocumentIdList(List<String> documentIdList) {
        this.documentIdList = documentIdList;
    }

    public void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    public void setLibId(String libId) {
        this.libId = libId;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DuplicateCheckContext)) {
            return false;
        }
        DuplicateCheckContext other = (DuplicateCheckContext)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getStartTime() != other.getStartTime()) {
            return false;
        }
        CyclicBarrier this$cyclicBarrier = this.getCyclicBarrier();
        CyclicBarrier other$cyclicBarrier = other.getCyclicBarrier();
        if (this$cyclicBarrier == null ? other$cyclicBarrier != null : !this$cyclicBarrier.equals(other$cyclicBarrier)) {
            return false;
        }
        CountDownLatch this$countDownLatch = this.getCountDownLatch();
        CountDownLatch other$countDownLatch = other.getCountDownLatch();
        if (this$countDownLatch == null ? other$countDownLatch != null : !this$countDownLatch.equals(other$countDownLatch)) {
            return false;
        }
        ThreadPoolExecutor this$taskThreadPool = this.getTaskThreadPool();
        ThreadPoolExecutor other$taskThreadPool = other.getTaskThreadPool();
        if (this$taskThreadPool == null ? other$taskThreadPool != null : !this$taskThreadPool.equals(other$taskThreadPool)) {
            return false;
        }
        DuplicateCheckResultPersistence this$resultPersistence = this.getResultPersistence();
        DuplicateCheckResultPersistence other$resultPersistence = other.getResultPersistence();
        if (this$resultPersistence == null ? other$resultPersistence != null : !this$resultPersistence.equals(other$resultPersistence)) {
            return false;
        }
        List<DuplicateCheckCandidateGroup> this$candidateGroupList = this.getCandidateGroupList();
        List<DuplicateCheckCandidateGroup> other$candidateGroupList = other.getCandidateGroupList();
        if (this$candidateGroupList == null ? other$candidateGroupList != null : !((Object)this$candidateGroupList).equals(other$candidateGroupList)) {
            return false;
        }
        DuplicateCheckParamConfiguration this$paramConfiguration = this.getParamConfiguration();
        DuplicateCheckParamConfiguration other$paramConfiguration = other.getParamConfiguration();
        if (this$paramConfiguration == null ? other$paramConfiguration != null : !((Object)this$paramConfiguration).equals(other$paramConfiguration)) {
            return false;
        }
        DuplicateCheckExecuteModelEnum this$executorModelEnum = this.getExecutorModelEnum();
        DuplicateCheckExecuteModelEnum other$executorModelEnum = other.getExecutorModelEnum();
        if (this$executorModelEnum == null ? other$executorModelEnum != null : !((Object)((Object)this$executorModelEnum)).equals((Object)other$executorModelEnum)) {
            return false;
        }
        DuplicateCheckModelEnum this$checkModel = this.getCheckModel();
        DuplicateCheckModelEnum other$checkModel = other.getCheckModel();
        if (this$checkModel == null ? other$checkModel != null : !((Object)((Object)this$checkModel)).equals((Object)other$checkModel)) {
            return false;
        }
        List<DuplicatecheckOverInterface> this$censorOverInterfaces = this.getCensorOverInterfaces();
        List<DuplicatecheckOverInterface> other$censorOverInterfaces = other.getCensorOverInterfaces();
        if (this$censorOverInterfaces == null ? other$censorOverInterfaces != null : !((Object)this$censorOverInterfaces).equals(other$censorOverInterfaces)) {
            return false;
        }
        DuplicateCheckGroupResultHandler this$groupResultHandler = this.getGroupResultHandler();
        DuplicateCheckGroupResultHandler other$groupResultHandler = other.getGroupResultHandler();
        if (this$groupResultHandler == null ? other$groupResultHandler != null : !this$groupResultHandler.equals(other$groupResultHandler)) {
            return false;
        }
        DuplicateCheckOperationEnum this$operationModel = this.getOperationModel();
        DuplicateCheckOperationEnum other$operationModel = other.getOperationModel();
        if (this$operationModel == null ? other$operationModel != null : !((Object)((Object)this$operationModel)).equals((Object)other$operationModel)) {
            return false;
        }
        Map<DuplicateCheckOperationEnum, List<DuplicateCheckCandidateDocument>> this$operationClassifiers = this.getOperationClassifiers();
        Map<DuplicateCheckOperationEnum, List<DuplicateCheckCandidateDocument>> other$operationClassifiers = other.getOperationClassifiers();
        if (this$operationClassifiers == null ? other$operationClassifiers != null : !((Object)this$operationClassifiers).equals(other$operationClassifiers)) {
            return false;
        }
        List<String> this$documentIdList = this.getDocumentIdList();
        List<String> other$documentIdList = other.getDocumentIdList();
        if (this$documentIdList == null ? other$documentIdList != null : !((Object)this$documentIdList).equals(other$documentIdList)) {
            return false;
        }
        String this$libId = this.getLibId();
        String other$libId = other.getLibId();
        return !(this$libId == null ? other$libId != null : !this$libId.equals(other$libId));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DuplicateCheckContext;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $startTime = this.getStartTime();
        result = result * 59 + (int)($startTime >>> 32 ^ $startTime);
        CyclicBarrier $cyclicBarrier = this.getCyclicBarrier();
        result = result * 59 + ($cyclicBarrier == null ? 43 : $cyclicBarrier.hashCode());
        CountDownLatch $countDownLatch = this.getCountDownLatch();
        result = result * 59 + ($countDownLatch == null ? 43 : $countDownLatch.hashCode());
        ThreadPoolExecutor $taskThreadPool = this.getTaskThreadPool();
        result = result * 59 + ($taskThreadPool == null ? 43 : $taskThreadPool.hashCode());
        DuplicateCheckResultPersistence $resultPersistence = this.getResultPersistence();
        result = result * 59 + ($resultPersistence == null ? 43 : $resultPersistence.hashCode());
        List<DuplicateCheckCandidateGroup> $candidateGroupList = this.getCandidateGroupList();
        result = result * 59 + ($candidateGroupList == null ? 43 : ((Object)$candidateGroupList).hashCode());
        DuplicateCheckParamConfiguration $paramConfiguration = this.getParamConfiguration();
        result = result * 59 + ($paramConfiguration == null ? 43 : ((Object)$paramConfiguration).hashCode());
        DuplicateCheckExecuteModelEnum $executorModelEnum = this.getExecutorModelEnum();
        result = result * 59 + ($executorModelEnum == null ? 43 : ((Object)((Object)$executorModelEnum)).hashCode());
        DuplicateCheckModelEnum $checkModel = this.getCheckModel();
        result = result * 59 + ($checkModel == null ? 43 : ((Object)((Object)$checkModel)).hashCode());
        List<DuplicatecheckOverInterface> $censorOverInterfaces = this.getCensorOverInterfaces();
        result = result * 59 + ($censorOverInterfaces == null ? 43 : ((Object)$censorOverInterfaces).hashCode());
        DuplicateCheckGroupResultHandler $groupResultHandler = this.getGroupResultHandler();
        result = result * 59 + ($groupResultHandler == null ? 43 : $groupResultHandler.hashCode());
        DuplicateCheckOperationEnum $operationModel = this.getOperationModel();
        result = result * 59 + ($operationModel == null ? 43 : ((Object)((Object)$operationModel)).hashCode());
        Map<DuplicateCheckOperationEnum, List<DuplicateCheckCandidateDocument>> $operationClassifiers = this.getOperationClassifiers();
        result = result * 59 + ($operationClassifiers == null ? 43 : ((Object)$operationClassifiers).hashCode());
        List<String> $documentIdList = this.getDocumentIdList();
        result = result * 59 + ($documentIdList == null ? 43 : ((Object)$documentIdList).hashCode());
        String $libId = this.getLibId();
        result = result * 59 + ($libId == null ? 43 : $libId.hashCode());
        return result;
    }

    public String toString() {
        return "DuplicateCheckContext(cyclicBarrier=" + this.getCyclicBarrier() + ", countDownLatch=" + this.getCountDownLatch() + ", taskThreadPool=" + this.getTaskThreadPool() + ", resultPersistence=" + this.getResultPersistence() + ", candidateGroupList=" + this.getCandidateGroupList() + ", paramConfiguration=" + this.getParamConfiguration() + ", executorModelEnum=" + (Object)((Object)this.getExecutorModelEnum()) + ", checkModel=" + (Object)((Object)this.getCheckModel()) + ", censorOverInterfaces=" + this.getCensorOverInterfaces() + ", groupResultHandler=" + this.getGroupResultHandler() + ", operationModel=" + (Object)((Object)this.getOperationModel()) + ", operationClassifiers=" + this.getOperationClassifiers() + ", documentIdList=" + this.getDocumentIdList() + ", startTime=" + this.getStartTime() + ", libId=" + this.getLibId() + ")";
    }

    public static class DefaultThreadFactory
    implements ThreadFactory {
        private final ThreadGroup group;
        private final AtomicInteger threadNumber = new AtomicInteger(1);
        private final String namePrefix;

        public DefaultThreadFactory() {
            SecurityManager s = System.getSecurityManager();
            this.group = s != null ? s.getThreadGroup() : Thread.currentThread().getThreadGroup();
            this.namePrefix = System.currentTimeMillis() + "_check_duplicate--thread-";
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(this.group, r, this.namePrefix + this.threadNumber.getAndIncrement(), 0L);
            if (t.isDaemon()) {
                t.setDaemon(false);
            }
            if (t.getPriority() != 5) {
                t.setPriority(5);
            }
            return t;
        }
    }
}

