/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.icpac.core.storage;

import cn.hutool.core.io.file.FileNameUtil;
import com.jxdinfo.idp.common.entity.util.docparse.word.WordInfo;
import com.jxdinfo.idp.common.util.SpringUtils;
import com.jxdinfo.idp.icpac.core.dochandler.DocumentHandler;
import com.jxdinfo.idp.icpac.core.dochandler.DocumentHandlerFactory;
import com.jxdinfo.idp.icpac.core.enmus.DuplicateCheckModelEnum;
import com.jxdinfo.idp.icpac.core.enmus.DuplicateCheckOperationEnum;
import com.jxdinfo.idp.icpac.core.enmus.DuplicateCheckUpdateModelEnum;
import com.jxdinfo.idp.icpac.core.entity.DuplicateCheckCandidateElement;
import com.jxdinfo.idp.icpac.core.entity.DuplicateCheckCandidateSentence;
import com.jxdinfo.idp.icpac.core.entity.DuplicateCheckChapterConfig;
import com.jxdinfo.idp.icpac.core.entity.DuplicateCheckTaskResult;
import com.jxdinfo.idp.icpac.core.handler.DuplicateCheckCandidateElementPostProcessor;
import com.jxdinfo.idp.icpac.core.handler.DuplicateCheckObjectClone;
import com.jxdinfo.idp.icpac.core.handler.DuplicateCheckResultHandler;
import com.jxdinfo.idp.icpac.core.handler.DuplicateCheckResultPersistence;
import com.jxdinfo.idp.icpac.core.handler.highrisk.DuplicateCheckHighRiskDetector;
import com.jxdinfo.idp.icpac.core.handler.resultfilter.DuplicateCheckResultFilter;
import com.jxdinfo.idp.icpac.core.handler.sentencehandler.DuplicateCheckCandidateElementExtractor;
import com.jxdinfo.idp.icpac.core.presist.images.entity.DuplicateCheckCandidateImage;
import com.jxdinfo.idp.icpac.core.presist.images.service.DuplicateCheckCandidateImageService;
import com.jxdinfo.idp.icpac.core.progress.DuplicateCheckProgress;
import com.jxdinfo.idp.icpac.core.storage.DuplicateCheckCandidateGroup;
import com.jxdinfo.idp.icpac.core.storage.DuplicateCheckContext;
import com.jxdinfo.idp.icpac.core.storage.DuplicateCheckParamConfiguration;
import com.jxdinfo.idp.icpac.core.storage.IgnoreSentenceParam;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.multipart.MultipartFile;

public class DuplicateCheckCandidateDocument {
    private static final Logger log = LoggerFactory.getLogger(DuplicateCheckCandidateDocument.class);
    private String documentId;
    private MultipartFile file;
    private DuplicateCheckParamConfiguration paramConfiguration;
    private IgnoreSentenceParam ignoreSentenceParam;
    private String fileName;
    private String format;
    private Map<String, Object> attachmentCollections;
    private DuplicateCheckCandidateGroup candidateGroup;
    private WordInfo wordInfo;
    private int candidateSentenceNum;
    private boolean isParse = false;
    private DuplicateCheckTaskResult checkTaskResult;
    private DuplicateCheckCandidateElement candidateElement;
    private List<String> chooseDocumentIdList;
    private List<String> candidateImageIdList = new ArrayList<String>();

    public DuplicateCheckCandidateDocument() {
        this.paramConfiguration = new DuplicateCheckParamConfiguration();
        this.attachmentCollections = new HashMap<String, Object>();
    }

    public void setFile(MultipartFile file) {
        if (file != null) {
            this.file = file;
            this.fileName = file.getOriginalFilename();
            this.format = FileNameUtil.getSuffix((String)this.fileName);
        }
    }

    public String getLibId() {
        return this.getContext().getLibId();
    }

    public Object addAttachment(String key, Object attachment) {
        if (key == null) {
            throw new NullPointerException("\u7ed9\u5b9a\u7684key\u4e0d\u80fd\u4e3anull");
        }
        Object oldAttachment = this.attachmentCollections.remove(key);
        this.attachmentCollections.put(key, attachment);
        return oldAttachment;
    }

    public <T> T getAttachment(String key, Class<T> type) {
        Object o = this.attachmentCollections.get(key);
        if (o == null) {
            return null;
        }
        return (T)o;
    }

    public String getFileName() {
        return this.fileName;
    }

    public List<DuplicateCheckCandidateSentence> getCandidateSentenceList() {
        this.extractCandidateElement();
        return this.candidateElement.getCandidateSentenceList() == null ? new ArrayList() : this.candidateElement.getCandidateSentenceList();
    }

    private void extractCandidateElement() {
        try {
            if (!this.isParse) {
                List<DuplicateCheckCandidateSentence> candidateSentenceList;
                this.isParse = true;
                DocumentHandler documentHandler = DocumentHandlerFactory.getDocumentHandler(this.file);
                this.wordInfo = documentHandler.structuredDoc(this.file);
                DuplicateCheckCandidateElementExtractor candidateElementExtractor = this.getCandidateElementExtractor();
                if (candidateElementExtractor == null) {
                    throw new RuntimeException("\u5f53\u524d\u5e26\u5019\u9009\u5143\u7d20\u63d0\u53d6\u5668\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u8fdb\u884c\u83b7\u53d6\u5f85\u5019\u9009\u8bed\u5143\u7d20");
                }
                this.candidateElement = candidateElementExtractor.extractCandidateElement(this);
                if (this.isDuplicateImageFlag() && CollectionUtils.isNotEmpty(this.candidateElement.getCandidateSentenceList())) {
                    DuplicateCheckCandidateImageService imageService = (DuplicateCheckCandidateImageService)SpringUtils.getBean(DuplicateCheckCandidateImageService.class);
                    imageService.deleteByDocId(Arrays.asList(this.getDocumentId()));
                    imageService.saveBatch(this.candidateElement.getCandidateImageList());
                }
                this.candidateSentenceNum = (candidateSentenceList = this.candidateElement.getCandidateSentenceList()) == null ? 0 : candidateSentenceList.size();
                this.candidateElement.setCandidateSentenceList(candidateSentenceList);
                if (CollectionUtils.isNotEmpty(candidateSentenceList)) {
                    this.postCandidateElement();
                }
            }
        }
        catch (Exception e) {
            log.error("\u63d0\u53d6\u7ed3\u679c\u51fa\u9519", (Throwable)e);
            throw new RuntimeException("\u63d0\u53d6\u7ed3\u679c\u51fa\u9519", e);
        }
    }

    private void postCandidateElement() {
        List<DuplicateCheckCandidateElementPostProcessor> candidateElementPostProcessorList = this.getCandidateElementPostProcessors();
        if (CollectionUtils.isNotEmpty(candidateElementPostProcessorList)) {
            for (DuplicateCheckCandidateElementPostProcessor candidateElementPostProcessor : candidateElementPostProcessorList) {
                this.candidateElement = candidateElementPostProcessor.post(this, this.candidateElement);
            }
        }
    }

    private List<DuplicateCheckCandidateElementPostProcessor> getCandidateElementPostProcessors() {
        List<DuplicateCheckCandidateElementPostProcessor> candidateElementPostProcessorList = null;
        if (this.paramConfiguration != null && CollectionUtils.isEmpty(candidateElementPostProcessorList = this.paramConfiguration.getCandidateElementPostProcessorList())) {
            candidateElementPostProcessorList = this.candidateGroup.getCandidateElementPostProcessorList();
        }
        candidateElementPostProcessorList = this.cloneHandlerObject(candidateElementPostProcessorList);
        return candidateElementPostProcessorList;
    }

    private DuplicateCheckCandidateElementExtractor getCandidateElementExtractor() {
        DuplicateCheckCandidateElementExtractor candidateElementExtractor;
        if (this.paramConfiguration != null && (candidateElementExtractor = this.paramConfiguration.getCandidateElementExtractor()) != null) {
            return candidateElementExtractor;
        }
        DuplicateCheckCandidateElementExtractor elementExtractor = this.candidateGroup.getCandidateElementExtractor();
        if (elementExtractor != null) {
            return (DuplicateCheckCandidateElementExtractor)elementExtractor.cloneObject();
        }
        return null;
    }

    public DuplicateCheckOperationEnum getOperationModel() {
        return this.getContext().getOperationModel();
    }

    public void addChooseDocumentId(String chooseDocumentId) {
        this.chooseDocumentIdList.add(chooseDocumentId);
    }

    public void addAllChooseDocumentId(List<String> chooseDocumentIdList) {
        this.chooseDocumentIdList.addAll(chooseDocumentIdList);
    }

    public DuplicateCheckModelEnum getCheckModel() {
        return this.candidateGroup.getCheckModel() == null ? DuplicateCheckModelEnum.VECTORIZATION : this.candidateGroup.getCheckModel();
    }

    public boolean isDuplicateImageFlag() {
        Boolean duplicateImageFlag;
        if (this.paramConfiguration != null && (duplicateImageFlag = this.paramConfiguration.getDuplicateImageFlag()) != null) {
            return duplicateImageFlag;
        }
        return this.candidateGroup.isDuplicateImageFlag();
    }

    public Double getSimThresh() {
        Double simThresh;
        if (this.paramConfiguration != null && (simThresh = this.paramConfiguration.getSimThresh()) != null) {
            return simThresh;
        }
        return this.candidateGroup.getSimThresh();
    }

    public DuplicateCheckUpdateModelEnum getUpdateModel() {
        DuplicateCheckUpdateModelEnum updateModel;
        if (this.paramConfiguration != null && (updateModel = this.paramConfiguration.getUpdateModel()) != null) {
            return updateModel;
        }
        return this.candidateGroup.getUpdateModel();
    }

    public Object getTemplateProjectId() {
        String templateProjectId;
        if (this.paramConfiguration != null && StringUtils.isNotEmpty((CharSequence)(templateProjectId = this.paramConfiguration.getTemplateLibId()))) {
            return templateProjectId;
        }
        return this.candidateGroup.getTemplateProjectId();
    }

    public DuplicateCheckContext getContext() {
        return this.candidateGroup.getContext();
    }

    public void waitOthers() {
        if (this.getOperationModel() == DuplicateCheckOperationEnum.CHECK && this.getUpdateModel() != DuplicateCheckUpdateModelEnum.NO_PERSIST) {
            this.getContext().waitOthers();
        }
    }

    public DuplicateCheckResultHandler getResultHandler() {
        DuplicateCheckResultHandler resultHandler;
        if (this.paramConfiguration != null && (resultHandler = this.paramConfiguration.getResultHandler()) != null) {
            return resultHandler;
        }
        DuplicateCheckResultHandler checkResultHandler = this.candidateGroup.getResultHandler();
        if (checkResultHandler != null) {
            return (DuplicateCheckResultHandler)checkResultHandler.cloneObject();
        }
        return null;
    }

    public List<DuplicateCheckCandidateImage> getCandidateImageList() {
        return this.candidateElement.getCandidateImageList() == null ? new ArrayList() : this.candidateElement.getCandidateImageList();
    }

    public void completeTask() {
        DuplicateCheckResultHandler resultHandler = this.getResultHandler();
        if (resultHandler != null) {
            DuplicateCheckCandidateImageService imageService = (DuplicateCheckCandidateImageService)SpringUtils.getBean(DuplicateCheckCandidateImageService.class);
            List<DuplicateCheckCandidateImage> candidateImages = imageService.getByProjectId(this.getLibId());
            if (CollectionUtils.isNotEmpty(candidateImages)) {
                this.candidateImageIdList = candidateImages.stream().map(k -> k.getId() + "").collect(Collectors.toList());
            }
            Object result = resultHandler.handleResult(this);
            DuplicateCheckResultPersistence resultPersistence = this.getContext().getResultPersistence();
            if (resultPersistence != null) {
                resultPersistence.persist(result);
            }
        }
        if (this.checkTaskResult.isSuccess()) {
            DuplicateCheckProgress.setProgress(this.documentId, 100);
        } else {
            DuplicateCheckProgress.setFail(this.documentId);
        }
        this.getContext().completeOperation();
    }

    public List<DuplicateCheckResultFilter> getCheckResultFilter() {
        List<DuplicateCheckResultFilter> checkResultFilterList;
        if (this.paramConfiguration != null && CollectionUtils.isNotEmpty(checkResultFilterList = this.paramConfiguration.getCheckResultFilterList())) {
            return checkResultFilterList;
        }
        List<DuplicateCheckResultFilter> resultFilter = this.candidateGroup.getCheckResultFilter();
        return this.cloneHandlerObject(resultFilter);
    }

    private <T> List<T> cloneHandlerObject(List<? extends DuplicateCheckObjectClone<T>> resultFilter) {
        ArrayList<T> cloneResultFilter = new ArrayList<T>();
        if (CollectionUtils.isNotEmpty(resultFilter)) {
            for (DuplicateCheckObjectClone<T> filter : resultFilter) {
                cloneResultFilter.add(filter.cloneObject());
            }
        }
        return cloneResultFilter;
    }

    public List<DuplicateCheckHighRiskDetector> getHighRiskDetectorList() {
        List<DuplicateCheckHighRiskDetector> riskDetectorList;
        if (this.paramConfiguration != null && CollectionUtils.isNotEmpty(riskDetectorList = this.paramConfiguration.getHighRiskDetectorList())) {
            return riskDetectorList;
        }
        return this.cloneHandlerObject(this.candidateGroup.getHighRiskDetectorList());
    }

    public List<String> getTemplateTextList() {
        List<String> templateTextList;
        if (this.paramConfiguration != null && CollectionUtils.isNotEmpty(templateTextList = this.paramConfiguration.getTemplateTextList())) {
            return templateTextList;
        }
        return this.candidateGroup.getTemplateTextList();
    }

    public int getMinTextLength() {
        Integer minTextLength;
        if (this.paramConfiguration != null && (minTextLength = this.paramConfiguration.getMinTextLength()) != null) {
            return minTextLength;
        }
        return this.candidateGroup.getMinTextLength();
    }

    public int getMinTableLength() {
        Integer minTableLength;
        if (this.paramConfiguration != null && (minTableLength = this.paramConfiguration.getMinTableLength()) != null) {
            return minTableLength;
        }
        return this.candidateGroup.getMinTableLength();
    }

    public List<DuplicateCheckChapterConfig> getChapterConfig() {
        List<DuplicateCheckChapterConfig> chapterConfigList;
        if (this.paramConfiguration != null && (chapterConfigList = this.paramConfiguration.getChapterConfigList()) != null) {
            return chapterConfigList;
        }
        return this.candidateGroup.getChapterConfig();
    }

    public boolean isTextSegmentation() {
        Boolean textSegmentation;
        if (this.paramConfiguration != null && (textSegmentation = this.paramConfiguration.getTextSegmentation()) != null) {
            return textSegmentation;
        }
        textSegmentation = this.candidateGroup.isTextSegmentation();
        return textSegmentation != null && textSegmentation != false;
    }

    public String getChapterMatchType() {
        String chapterMatchType;
        if (this.paramConfiguration != null && StringUtils.isNotEmpty((CharSequence)(chapterMatchType = this.paramConfiguration.getChapterMatchType()))) {
            return chapterMatchType;
        }
        chapterMatchType = this.candidateGroup.getChapterMatchType();
        return StringUtils.isEmpty((CharSequence)chapterMatchType) ? "0" : chapterMatchType;
    }

    public boolean isParamConfigurationNull() {
        return this.paramConfiguration == null;
    }

    public List<String> getExcludeLibList() {
        List<String> excludeRegList;
        if (this.paramConfiguration != null && CollectionUtils.isNotEmpty(excludeRegList = this.paramConfiguration.getExcludeRegList())) {
            return excludeRegList;
        }
        return this.candidateGroup.getExcludeLibList();
    }

    public String getDocumentId() {
        return this.documentId;
    }

    public MultipartFile getFile() {
        return this.file;
    }

    public DuplicateCheckParamConfiguration getParamConfiguration() {
        return this.paramConfiguration;
    }

    public IgnoreSentenceParam getIgnoreSentenceParam() {
        return this.ignoreSentenceParam;
    }

    public String getFormat() {
        return this.format;
    }

    public Map<String, Object> getAttachmentCollections() {
        return this.attachmentCollections;
    }

    public DuplicateCheckCandidateGroup getCandidateGroup() {
        return this.candidateGroup;
    }

    public WordInfo getWordInfo() {
        return this.wordInfo;
    }

    public int getCandidateSentenceNum() {
        return this.candidateSentenceNum;
    }

    public boolean isParse() {
        return this.isParse;
    }

    public DuplicateCheckTaskResult getCheckTaskResult() {
        return this.checkTaskResult;
    }

    public DuplicateCheckCandidateElement getCandidateElement() {
        return this.candidateElement;
    }

    public List<String> getChooseDocumentIdList() {
        return this.chooseDocumentIdList;
    }

    public List<String> getCandidateImageIdList() {
        return this.candidateImageIdList;
    }

    public void setDocumentId(String documentId) {
        this.documentId = documentId;
    }

    public void setParamConfiguration(DuplicateCheckParamConfiguration paramConfiguration) {
        this.paramConfiguration = paramConfiguration;
    }

    public void setIgnoreSentenceParam(IgnoreSentenceParam ignoreSentenceParam) {
        this.ignoreSentenceParam = ignoreSentenceParam;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public void setAttachmentCollections(Map<String, Object> attachmentCollections) {
        this.attachmentCollections = attachmentCollections;
    }

    public void setCandidateGroup(DuplicateCheckCandidateGroup candidateGroup) {
        this.candidateGroup = candidateGroup;
    }

    public void setWordInfo(WordInfo wordInfo) {
        this.wordInfo = wordInfo;
    }

    public void setCandidateSentenceNum(int candidateSentenceNum) {
        this.candidateSentenceNum = candidateSentenceNum;
    }

    public void setParse(boolean isParse) {
        this.isParse = isParse;
    }

    public void setCheckTaskResult(DuplicateCheckTaskResult checkTaskResult) {
        this.checkTaskResult = checkTaskResult;
    }

    public void setCandidateElement(DuplicateCheckCandidateElement candidateElement) {
        this.candidateElement = candidateElement;
    }

    public void setChooseDocumentIdList(List<String> chooseDocumentIdList) {
        this.chooseDocumentIdList = chooseDocumentIdList;
    }

    public void setCandidateImageIdList(List<String> candidateImageIdList) {
        this.candidateImageIdList = candidateImageIdList;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DuplicateCheckCandidateDocument)) {
            return false;
        }
        DuplicateCheckCandidateDocument other = (DuplicateCheckCandidateDocument)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getCandidateSentenceNum() != other.getCandidateSentenceNum()) {
            return false;
        }
        if (this.isParse() != other.isParse()) {
            return false;
        }
        String this$documentId = this.getDocumentId();
        String other$documentId = other.getDocumentId();
        if (this$documentId == null ? other$documentId != null : !this$documentId.equals(other$documentId)) {
            return false;
        }
        MultipartFile this$file = this.getFile();
        MultipartFile other$file = other.getFile();
        if (this$file == null ? other$file != null : !this$file.equals(other$file)) {
            return false;
        }
        DuplicateCheckParamConfiguration this$paramConfiguration = this.getParamConfiguration();
        DuplicateCheckParamConfiguration other$paramConfiguration = other.getParamConfiguration();
        if (this$paramConfiguration == null ? other$paramConfiguration != null : !((Object)this$paramConfiguration).equals(other$paramConfiguration)) {
            return false;
        }
        IgnoreSentenceParam this$ignoreSentenceParam = this.getIgnoreSentenceParam();
        IgnoreSentenceParam other$ignoreSentenceParam = other.getIgnoreSentenceParam();
        if (this$ignoreSentenceParam == null ? other$ignoreSentenceParam != null : !((Object)this$ignoreSentenceParam).equals(other$ignoreSentenceParam)) {
            return false;
        }
        String this$fileName = this.getFileName();
        String other$fileName = other.getFileName();
        if (this$fileName == null ? other$fileName != null : !this$fileName.equals(other$fileName)) {
            return false;
        }
        String this$format = this.getFormat();
        String other$format = other.getFormat();
        if (this$format == null ? other$format != null : !this$format.equals(other$format)) {
            return false;
        }
        Map<String, Object> this$attachmentCollections = this.getAttachmentCollections();
        Map<String, Object> other$attachmentCollections = other.getAttachmentCollections();
        if (this$attachmentCollections == null ? other$attachmentCollections != null : !((Object)this$attachmentCollections).equals(other$attachmentCollections)) {
            return false;
        }
        DuplicateCheckCandidateGroup this$candidateGroup = this.getCandidateGroup();
        DuplicateCheckCandidateGroup other$candidateGroup = other.getCandidateGroup();
        if (this$candidateGroup == null ? other$candidateGroup != null : !((Object)this$candidateGroup).equals(other$candidateGroup)) {
            return false;
        }
        WordInfo this$wordInfo = this.getWordInfo();
        WordInfo other$wordInfo = other.getWordInfo();
        if (this$wordInfo == null ? other$wordInfo != null : !this$wordInfo.equals(other$wordInfo)) {
            return false;
        }
        DuplicateCheckTaskResult this$checkTaskResult = this.getCheckTaskResult();
        DuplicateCheckTaskResult other$checkTaskResult = other.getCheckTaskResult();
        if (this$checkTaskResult == null ? other$checkTaskResult != null : !((Object)this$checkTaskResult).equals(other$checkTaskResult)) {
            return false;
        }
        DuplicateCheckCandidateElement this$candidateElement = this.getCandidateElement();
        DuplicateCheckCandidateElement other$candidateElement = other.getCandidateElement();
        if (this$candidateElement == null ? other$candidateElement != null : !((Object)this$candidateElement).equals(other$candidateElement)) {
            return false;
        }
        List<String> this$chooseDocumentIdList = this.getChooseDocumentIdList();
        List<String> other$chooseDocumentIdList = other.getChooseDocumentIdList();
        if (this$chooseDocumentIdList == null ? other$chooseDocumentIdList != null : !((Object)this$chooseDocumentIdList).equals(other$chooseDocumentIdList)) {
            return false;
        }
        List<String> this$candidateImageIdList = this.getCandidateImageIdList();
        List<String> other$candidateImageIdList = other.getCandidateImageIdList();
        return !(this$candidateImageIdList == null ? other$candidateImageIdList != null : !((Object)this$candidateImageIdList).equals(other$candidateImageIdList));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DuplicateCheckCandidateDocument;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getCandidateSentenceNum();
        result = result * 59 + (this.isParse() ? 79 : 97);
        String $documentId = this.getDocumentId();
        result = result * 59 + ($documentId == null ? 43 : $documentId.hashCode());
        MultipartFile $file = this.getFile();
        result = result * 59 + ($file == null ? 43 : $file.hashCode());
        DuplicateCheckParamConfiguration $paramConfiguration = this.getParamConfiguration();
        result = result * 59 + ($paramConfiguration == null ? 43 : ((Object)$paramConfiguration).hashCode());
        IgnoreSentenceParam $ignoreSentenceParam = this.getIgnoreSentenceParam();
        result = result * 59 + ($ignoreSentenceParam == null ? 43 : ((Object)$ignoreSentenceParam).hashCode());
        String $fileName = this.getFileName();
        result = result * 59 + ($fileName == null ? 43 : $fileName.hashCode());
        String $format = this.getFormat();
        result = result * 59 + ($format == null ? 43 : $format.hashCode());
        Map<String, Object> $attachmentCollections = this.getAttachmentCollections();
        result = result * 59 + ($attachmentCollections == null ? 43 : ((Object)$attachmentCollections).hashCode());
        DuplicateCheckCandidateGroup $candidateGroup = this.getCandidateGroup();
        result = result * 59 + ($candidateGroup == null ? 43 : ((Object)$candidateGroup).hashCode());
        WordInfo $wordInfo = this.getWordInfo();
        result = result * 59 + ($wordInfo == null ? 43 : $wordInfo.hashCode());
        DuplicateCheckTaskResult $checkTaskResult = this.getCheckTaskResult();
        result = result * 59 + ($checkTaskResult == null ? 43 : ((Object)$checkTaskResult).hashCode());
        DuplicateCheckCandidateElement $candidateElement = this.getCandidateElement();
        result = result * 59 + ($candidateElement == null ? 43 : ((Object)$candidateElement).hashCode());
        List<String> $chooseDocumentIdList = this.getChooseDocumentIdList();
        result = result * 59 + ($chooseDocumentIdList == null ? 43 : ((Object)$chooseDocumentIdList).hashCode());
        List<String> $candidateImageIdList = this.getCandidateImageIdList();
        result = result * 59 + ($candidateImageIdList == null ? 43 : ((Object)$candidateImageIdList).hashCode());
        return result;
    }

    public String toString() {
        return "DuplicateCheckCandidateDocument(documentId=" + this.getDocumentId() + ", file=" + this.getFile() + ", paramConfiguration=" + this.getParamConfiguration() + ", ignoreSentenceParam=" + this.getIgnoreSentenceParam() + ", fileName=" + this.getFileName() + ", format=" + this.getFormat() + ", attachmentCollections=" + this.getAttachmentCollections() + ", candidateGroup=" + this.getCandidateGroup() + ", wordInfo=" + this.getWordInfo() + ", candidateSentenceNum=" + this.getCandidateSentenceNum() + ", isParse=" + this.isParse() + ", checkTaskResult=" + this.getCheckTaskResult() + ", candidateElement=" + this.getCandidateElement() + ", chooseDocumentIdList=" + this.getChooseDocumentIdList() + ", candidateImageIdList=" + this.getCandidateImageIdList() + ")";
    }
}

