/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.icpac.core.executor;

import com.jxdinfo.idp.icpac.core.call.DuplicatecheckOverInterface;
import com.jxdinfo.idp.icpac.core.entity.DuplicateCheckGroupSimilarityResult;
import com.jxdinfo.idp.icpac.core.handler.DuplicateCheckGroupResultHandler;
import com.jxdinfo.idp.icpac.core.storage.DuplicateCheckCandidateGroup;
import com.jxdinfo.idp.icpac.core.storage.DuplicateCheckContext;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DuplicateCheckTaskFinalizer
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(DuplicateCheckTaskFinalizer.class);
    private final DuplicateCheckContext context;

    public DuplicateCheckTaskFinalizer(DuplicateCheckContext context) {
        if (context == null) {
            throw new RuntimeException("\u4f20\u5165\u7684\u67e5\u91cd\u4e0a\u4e0b\u6587\u4e3a\u7a7a\uff0c\u6ca1\u6709\u529e\u6cd5\u8fdb\u884c\u67e5\u91cd\u3002\u3002\u3002\u3002");
        }
        this.context = context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            this.context.waitCompleteByOperation();
            this.cacGroupSimilarity();
            List<DuplicatecheckOverInterface> censorOverInterfaces = this.context.getCensorOverInterfaces();
            if (CollectionUtils.isNotEmpty(censorOverInterfaces)) {
                for (DuplicatecheckOverInterface censorOverInterface : censorOverInterfaces) {
                    try {
                        censorOverInterface.call(this.context);
                    }
                    catch (Exception exception) {}
                }
            }
        }
        finally {
            log.info("\u7ec4\u67e5\u91cd\u4efb\u52a1\u6267\u884c\u5b8c\u6bd5\uff0c\u8017\u65f6\u4e3a\uff1a{}\u79d2", (Object)((System.currentTimeMillis() - this.context.getStartTime()) / 1000L));
            this.context.clear();
        }
    }

    private void cacGroupSimilarity() {
        DuplicateCheckGroupResultHandler resultHandler = this.context.getDuplicateCheckGroupResultHandler();
        if (resultHandler == null) {
            return;
        }
        List<DuplicateCheckCandidateGroup> candidateGroupList = this.context.getCandidateGroupList();
        ArrayList<DuplicateCheckGroupSimilarityResult> groupResultList = new ArrayList<DuplicateCheckGroupSimilarityResult>();
        for (DuplicateCheckCandidateGroup candidateGroup : candidateGroupList) {
            List<DuplicateCheckGroupSimilarityResult> groupResult = candidateGroup.getGroupResult();
            if (!CollectionUtils.isNotEmpty(groupResult)) continue;
            groupResultList.addAll(groupResult);
        }
        resultHandler.handleGroupResult(groupResultList);
    }
}

