/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.icpac.core.duplicate.vectorization;

import com.jxdinfo.idp.icpac.core.duplicate.DuplicateChecker;
import com.jxdinfo.idp.icpac.core.duplicate.DuplicateCheckerFactory;
import com.jxdinfo.idp.icpac.core.duplicate.vectorization.remote.DefaultDuplicateCheckRemoteServer;
import com.jxdinfo.idp.icpac.core.enmus.DuplicateCheckModelEnum;
import com.jxdinfo.idp.icpac.core.entity.DuplicateCheckCandidateSentence;
import com.jxdinfo.idp.icpac.core.entity.resp.DuplicateCheckIgnoreResponse;
import com.jxdinfo.idp.icpac.core.entity.resp.DuplicateCheckImgResponse;
import com.jxdinfo.idp.icpac.core.entity.resp.DuplicateCheckResultResponse;
import com.jxdinfo.idp.icpac.core.entity.resp.DuplicateCheckVectorizationImageResultResponse;
import com.jxdinfo.idp.icpac.core.entity.resp.DuplicateCheckVectorizationResultResponse;
import com.jxdinfo.idp.icpac.core.presist.images.entity.DuplicateCheckCandidateImage;
import com.jxdinfo.idp.icpac.core.progress.DuplicateCheckProgress;
import com.jxdinfo.idp.icpac.core.storage.DuplicateCheckCandidateDocument;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class DuplicateCheckVectorizationExecutor
implements DuplicateChecker {
    private static final Logger log = LoggerFactory.getLogger(DuplicateCheckVectorizationExecutor.class);
    @Resource
    private DefaultDuplicateCheckRemoteServer defaultCheckRmi;

    public DuplicateCheckVectorizationExecutor() {
        DuplicateCheckerFactory.register(this);
    }

    @Override
    public DuplicateCheckResultResponse checkRepeat(DuplicateCheckCandidateDocument checkInfo) throws Exception {
        List<DuplicateCheckCandidateSentence> candidateSentenceList = checkInfo.getCandidateSentenceList();
        if (CollectionUtils.isEmpty(candidateSentenceList)) {
            return this.defaultCheckRmi.checkRepeat(checkInfo);
        }
        return null;
    }

    @Override
    public void vectorizationImage(DuplicateCheckCandidateDocument checkInfo) {
        List<DuplicateCheckCandidateImage> imageList;
        if (checkInfo.isDuplicateImageFlag() && CollectionUtils.isNotEmpty(imageList = checkInfo.getCandidateImageList())) {
            DuplicateCheckVectorizationImageResultResponse images = this.defaultCheckRmi.addImages(checkInfo);
            log.info("\u56fe\u7247\u5411\u91cf\u5316\u8fd4\u56de\u7684\u7ed3\u679c\u4e3a:{}", (Object)images);
        }
    }

    @Override
    public DuplicateCheckImgResponse checkRepeatImg(DuplicateCheckCandidateDocument checkInfo) {
        List<DuplicateCheckCandidateImage> imageList;
        if (checkInfo.isDuplicateImageFlag() && CollectionUtils.isNotEmpty(imageList = checkInfo.getCandidateImageList())) {
            return this.defaultCheckRmi.imagesim(checkInfo);
        }
        return null;
    }

    @Override
    public DuplicateCheckResultResponse checkRepeatNoVectorization(DuplicateCheckCandidateDocument candidateDocument) throws Exception {
        DuplicateCheckProgress.setProgress(candidateDocument.getDocumentId(), 5);
        List<DuplicateCheckCandidateSentence> candidateSentenceList = candidateDocument.getCandidateSentenceList();
        if (CollectionUtils.isEmpty(candidateSentenceList)) {
            log.info(candidateDocument.getFileName() + "\uff1a\u83b7\u53d6\u5f85\u67e5\u91cd\u7684\u53e5\u5b50\u6761\u6570\u4e3a0,\u65e0\u6cd5\u8fdb\u884c\u67e5\u91cd\uff0c\u67e5\u91cd\u7ed3\u675f");
            return null;
        }
        return this.defaultCheckRmi.checkRepeatNoVectorization(candidateDocument);
    }

    @Override
    public DuplicateCheckVectorizationResultResponse vectorization(DuplicateCheckCandidateDocument candidateDocument) throws Exception {
        List<DuplicateCheckCandidateSentence> candidateSentenceList = candidateDocument.getCandidateSentenceList();
        if (CollectionUtils.isEmpty(candidateSentenceList)) {
            log.error(candidateDocument.getFileName() + "\uff1a\u83b7\u53d6\u5f85\u67e5\u91cd\u7684\u53e5\u5b50\u6761\u6570\u4e3a0,\u65e0\u6cd5\u8fdb\u884c\u5411\u91cf\u5316");
            return null;
        }
        return this.defaultCheckRmi.vectorization(candidateDocument);
    }

    @Override
    public DuplicateCheckIgnoreResponse addIgnoreSentence(DuplicateCheckCandidateDocument info) {
        return this.defaultCheckRmi.addIgnoreSentence(info);
    }

    @Override
    public DuplicateCheckIgnoreResponse cancelIgnoreSentence(DuplicateCheckCandidateDocument checkInfo) {
        return this.defaultCheckRmi.cancelIgnoreSentence(checkInfo);
    }

    @Override
    public String deleteRemoteDoc(DuplicateCheckCandidateDocument checkInfo) {
        return this.defaultCheckRmi.deleteRemoteDoc(checkInfo);
    }

    @Override
    public boolean support(DuplicateCheckCandidateDocument candidateDocument) {
        return candidateDocument.getCheckModel() == DuplicateCheckModelEnum.VECTORIZATION;
    }
}

