/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.icpac.core.storage;

import com.jxdinfo.idp.common.entity.util.docparse.word.WordChapterInfo;
import com.jxdinfo.idp.common.entity.util.docparse.word.WordElementInfo;
import com.jxdinfo.idp.common.entity.util.docparse.word.WordInfo;
import com.jxdinfo.idp.common.entity.util.docparse.word.WordParagraphInfo;
import com.jxdinfo.idp.icpac.core.dochandler.DocumentHandler;
import com.jxdinfo.idp.icpac.core.dochandler.DocumentHandlerFactory;
import com.jxdinfo.idp.icpac.core.enmus.DuplicateCheckUpdateModelEnum;
import com.jxdinfo.idp.icpac.core.entity.DuplicateCheckChapterConfig;
import com.jxdinfo.idp.icpac.core.handler.DuplicateCheckCandidateElementPostProcessor;
import com.jxdinfo.idp.icpac.core.handler.DuplicateCheckResultHandler;
import com.jxdinfo.idp.icpac.core.handler.highrisk.DuplicateCheckHighRiskDetector;
import com.jxdinfo.idp.icpac.core.handler.resultfilter.DuplicateCheckResultFilter;
import com.jxdinfo.idp.icpac.core.handler.sentencehandler.DuplicateCheckCandidateElementExtractor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.multipart.MultipartFile;

public class DuplicateCheckParamConfiguration {
    private static final Logger log = LoggerFactory.getLogger(DuplicateCheckParamConfiguration.class);
    private Double simThresh;
    private Integer minTextLength;
    private Integer minTableLength;
    private Boolean duplicateImageFlag;
    private DuplicateCheckUpdateModelEnum updateModel;
    private String templateLibId;
    private String chapterMatchType;
    private DuplicateCheckCandidateElementExtractor candidateElementExtractor;
    private List<DuplicateCheckChapterConfig> chapterConfigList;
    private List<MultipartFile> templateDocumentList;
    private List<DuplicateCheckCandidateElementPostProcessor> candidateElementPostProcessorList;
    private List<DuplicateCheckResultFilter> checkResultFilterList;
    private List<DuplicateCheckHighRiskDetector> highRiskDetectorList;
    private List<TemplateText> templateTextList = new ArrayList<TemplateText>();
    private boolean templateParseFlag = false;
    private Boolean textSegmentation = true;
    private DuplicateCheckResultHandler resultHandler;
    private List<String> excludeRegList;

    public DuplicateCheckParamConfiguration() {
        this.templateDocumentList = new ArrayList<MultipartFile>();
        this.candidateElementPostProcessorList = new ArrayList<DuplicateCheckCandidateElementPostProcessor>();
        this.checkResultFilterList = new ArrayList<DuplicateCheckResultFilter>();
        this.highRiskDetectorList = new ArrayList<DuplicateCheckHighRiskDetector>();
        this.chapterConfigList = new ArrayList<DuplicateCheckChapterConfig>();
        this.excludeRegList = new ArrayList<String>();
    }

    public void setDuplicateImageFlag(String duplicateImageFlag) {
        this.duplicateImageFlag = Objects.equals(duplicateImageFlag, "1");
    }

    private void handleTemplateFile() {
        if (!this.templateParseFlag) {
            this.templateParseFlag = true;
            if (CollectionUtils.isEmpty(this.templateDocumentList)) {
                return;
            }
            for (MultipartFile file : this.templateDocumentList) {
                StringBuilder sb = new StringBuilder();
                DocumentHandler handler = DocumentHandlerFactory.getDocumentHandler(file);
                try {
                    WordInfo wordInfo = handler.structuredDoc(file);
                    this.mergeText(sb, wordInfo.getLevelChapterInfos());
                    this.templateTextList.add(new TemplateText(file, sb.toString()));
                }
                catch (Exception e) {
                    log.error("{},\u6a21\u7248\u6587\u4ef6\u89e3\u6790\u51fa\u9519", (Object)file.getOriginalFilename(), (Object)e);
                }
            }
        }
    }

    private void mergeText(StringBuilder textContainer, List<WordChapterInfo> wordChapterList) {
        if (wordChapterList == null || wordChapterList.size() == 0) {
            return;
        }
        for (WordChapterInfo wordChapterInfo : wordChapterList) {
            List eInfoList = wordChapterInfo.getChildParagraphList();
            if (CollectionUtils.isNotEmpty((Collection)eInfoList)) {
                for (WordElementInfo info : eInfoList) {
                    if (!"para".equals(info.getType())) continue;
                    WordParagraphInfo pInfo = (WordParagraphInfo)info;
                    textContainer.append(pInfo.getText());
                }
            }
            this.mergeText(textContainer, wordChapterInfo.getChildChapterList());
        }
    }

    public List<String> getTemplateTextList() {
        this.handleTemplateFile();
        ArrayList<String> templateTextList = new ArrayList<String>();
        for (TemplateText templateText : this.templateTextList) {
            templateTextList.add(templateText.text);
        }
        return templateTextList;
    }

    public void addTemplateDocument(MultipartFile templateDocument) {
        this.templateDocumentList.add(templateDocument);
    }

    public void addAllTemplateDocument(List<MultipartFile> templateDocumentList) {
        this.templateDocumentList.addAll(templateDocumentList);
    }

    public void addCandidatePostProcessor(DuplicateCheckCandidateElementPostProcessor candidateElementPostProcessor) {
        this.candidateElementPostProcessorList.add(candidateElementPostProcessor);
    }

    public void addAllCandidatePostProcessor(List<DuplicateCheckCandidateElementPostProcessor> candidateElementPostProcessorList) {
        this.candidateElementPostProcessorList.addAll(candidateElementPostProcessorList);
    }

    public void addCheckResultFilter(DuplicateCheckResultFilter checkResultFilter) {
        this.checkResultFilterList.add(checkResultFilter);
    }

    public void addAllCheckResultFilter(List<DuplicateCheckResultFilter> checkResultFilterList) {
        this.checkResultFilterList.addAll(checkResultFilterList);
    }

    public void addHighRiskDetector(DuplicateCheckHighRiskDetector highRiskDetector) {
        this.highRiskDetectorList.add(highRiskDetector);
    }

    public void addAllHighRiskDetector(List<DuplicateCheckHighRiskDetector> highRiskDetectorList) {
        this.highRiskDetectorList.addAll(highRiskDetectorList);
    }

    public void addChapterConfig(DuplicateCheckChapterConfig chapterConfig) {
        this.chapterConfigList.add(chapterConfig);
    }

    public void addAllChapterConfig(List<DuplicateCheckChapterConfig> chapterConfigList) {
        this.chapterConfigList.addAll(chapterConfigList);
    }

    public void addExcludeReg(String exclude) {
        this.excludeRegList.add(exclude);
    }

    public void addAllExcludeReg(List<String> excludeRegList) {
        this.excludeRegList.addAll(excludeRegList);
    }

    public Double getSimThresh() {
        return this.simThresh;
    }

    public Integer getMinTextLength() {
        return this.minTextLength;
    }

    public Integer getMinTableLength() {
        return this.minTableLength;
    }

    public Boolean getDuplicateImageFlag() {
        return this.duplicateImageFlag;
    }

    public DuplicateCheckUpdateModelEnum getUpdateModel() {
        return this.updateModel;
    }

    public String getTemplateLibId() {
        return this.templateLibId;
    }

    public String getChapterMatchType() {
        return this.chapterMatchType;
    }

    public DuplicateCheckCandidateElementExtractor getCandidateElementExtractor() {
        return this.candidateElementExtractor;
    }

    public List<DuplicateCheckChapterConfig> getChapterConfigList() {
        return this.chapterConfigList;
    }

    public List<MultipartFile> getTemplateDocumentList() {
        return this.templateDocumentList;
    }

    public List<DuplicateCheckCandidateElementPostProcessor> getCandidateElementPostProcessorList() {
        return this.candidateElementPostProcessorList;
    }

    public List<DuplicateCheckResultFilter> getCheckResultFilterList() {
        return this.checkResultFilterList;
    }

    public List<DuplicateCheckHighRiskDetector> getHighRiskDetectorList() {
        return this.highRiskDetectorList;
    }

    public boolean isTemplateParseFlag() {
        return this.templateParseFlag;
    }

    public Boolean getTextSegmentation() {
        return this.textSegmentation;
    }

    public DuplicateCheckResultHandler getResultHandler() {
        return this.resultHandler;
    }

    public List<String> getExcludeRegList() {
        return this.excludeRegList;
    }

    public void setSimThresh(Double simThresh) {
        this.simThresh = simThresh;
    }

    public void setMinTextLength(Integer minTextLength) {
        this.minTextLength = minTextLength;
    }

    public void setMinTableLength(Integer minTableLength) {
        this.minTableLength = minTableLength;
    }

    public void setUpdateModel(DuplicateCheckUpdateModelEnum updateModel) {
        this.updateModel = updateModel;
    }

    public void setTemplateLibId(String templateLibId) {
        this.templateLibId = templateLibId;
    }

    public void setChapterMatchType(String chapterMatchType) {
        this.chapterMatchType = chapterMatchType;
    }

    public void setCandidateElementExtractor(DuplicateCheckCandidateElementExtractor candidateElementExtractor) {
        this.candidateElementExtractor = candidateElementExtractor;
    }

    public void setChapterConfigList(List<DuplicateCheckChapterConfig> chapterConfigList) {
        this.chapterConfigList = chapterConfigList;
    }

    public void setTemplateDocumentList(List<MultipartFile> templateDocumentList) {
        this.templateDocumentList = templateDocumentList;
    }

    public void setCandidateElementPostProcessorList(List<DuplicateCheckCandidateElementPostProcessor> candidateElementPostProcessorList) {
        this.candidateElementPostProcessorList = candidateElementPostProcessorList;
    }

    public void setCheckResultFilterList(List<DuplicateCheckResultFilter> checkResultFilterList) {
        this.checkResultFilterList = checkResultFilterList;
    }

    public void setHighRiskDetectorList(List<DuplicateCheckHighRiskDetector> highRiskDetectorList) {
        this.highRiskDetectorList = highRiskDetectorList;
    }

    public void setTemplateTextList(List<TemplateText> templateTextList) {
        this.templateTextList = templateTextList;
    }

    public void setTemplateParseFlag(boolean templateParseFlag) {
        this.templateParseFlag = templateParseFlag;
    }

    public void setTextSegmentation(Boolean textSegmentation) {
        this.textSegmentation = textSegmentation;
    }

    public void setResultHandler(DuplicateCheckResultHandler resultHandler) {
        this.resultHandler = resultHandler;
    }

    public void setExcludeRegList(List<String> excludeRegList) {
        this.excludeRegList = excludeRegList;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DuplicateCheckParamConfiguration)) {
            return false;
        }
        DuplicateCheckParamConfiguration other = (DuplicateCheckParamConfiguration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isTemplateParseFlag() != other.isTemplateParseFlag()) {
            return false;
        }
        Double this$simThresh = this.getSimThresh();
        Double other$simThresh = other.getSimThresh();
        if (this$simThresh == null ? other$simThresh != null : !((Object)this$simThresh).equals(other$simThresh)) {
            return false;
        }
        Integer this$minTextLength = this.getMinTextLength();
        Integer other$minTextLength = other.getMinTextLength();
        if (this$minTextLength == null ? other$minTextLength != null : !((Object)this$minTextLength).equals(other$minTextLength)) {
            return false;
        }
        Integer this$minTableLength = this.getMinTableLength();
        Integer other$minTableLength = other.getMinTableLength();
        if (this$minTableLength == null ? other$minTableLength != null : !((Object)this$minTableLength).equals(other$minTableLength)) {
            return false;
        }
        Boolean this$duplicateImageFlag = this.getDuplicateImageFlag();
        Boolean other$duplicateImageFlag = other.getDuplicateImageFlag();
        if (this$duplicateImageFlag == null ? other$duplicateImageFlag != null : !((Object)this$duplicateImageFlag).equals(other$duplicateImageFlag)) {
            return false;
        }
        Boolean this$textSegmentation = this.getTextSegmentation();
        Boolean other$textSegmentation = other.getTextSegmentation();
        if (this$textSegmentation == null ? other$textSegmentation != null : !((Object)this$textSegmentation).equals(other$textSegmentation)) {
            return false;
        }
        DuplicateCheckUpdateModelEnum this$updateModel = this.getUpdateModel();
        DuplicateCheckUpdateModelEnum other$updateModel = other.getUpdateModel();
        if (this$updateModel == null ? other$updateModel != null : !((Object)((Object)this$updateModel)).equals((Object)other$updateModel)) {
            return false;
        }
        String this$templateLibId = this.getTemplateLibId();
        String other$templateLibId = other.getTemplateLibId();
        if (this$templateLibId == null ? other$templateLibId != null : !this$templateLibId.equals(other$templateLibId)) {
            return false;
        }
        String this$chapterMatchType = this.getChapterMatchType();
        String other$chapterMatchType = other.getChapterMatchType();
        if (this$chapterMatchType == null ? other$chapterMatchType != null : !this$chapterMatchType.equals(other$chapterMatchType)) {
            return false;
        }
        DuplicateCheckCandidateElementExtractor this$candidateElementExtractor = this.getCandidateElementExtractor();
        DuplicateCheckCandidateElementExtractor other$candidateElementExtractor = other.getCandidateElementExtractor();
        if (this$candidateElementExtractor == null ? other$candidateElementExtractor != null : !this$candidateElementExtractor.equals(other$candidateElementExtractor)) {
            return false;
        }
        List<DuplicateCheckChapterConfig> this$chapterConfigList = this.getChapterConfigList();
        List<DuplicateCheckChapterConfig> other$chapterConfigList = other.getChapterConfigList();
        if (this$chapterConfigList == null ? other$chapterConfigList != null : !((Object)this$chapterConfigList).equals(other$chapterConfigList)) {
            return false;
        }
        List<MultipartFile> this$templateDocumentList = this.getTemplateDocumentList();
        List<MultipartFile> other$templateDocumentList = other.getTemplateDocumentList();
        if (this$templateDocumentList == null ? other$templateDocumentList != null : !((Object)this$templateDocumentList).equals(other$templateDocumentList)) {
            return false;
        }
        List<DuplicateCheckCandidateElementPostProcessor> this$candidateElementPostProcessorList = this.getCandidateElementPostProcessorList();
        List<DuplicateCheckCandidateElementPostProcessor> other$candidateElementPostProcessorList = other.getCandidateElementPostProcessorList();
        if (this$candidateElementPostProcessorList == null ? other$candidateElementPostProcessorList != null : !((Object)this$candidateElementPostProcessorList).equals(other$candidateElementPostProcessorList)) {
            return false;
        }
        List<DuplicateCheckResultFilter> this$checkResultFilterList = this.getCheckResultFilterList();
        List<DuplicateCheckResultFilter> other$checkResultFilterList = other.getCheckResultFilterList();
        if (this$checkResultFilterList == null ? other$checkResultFilterList != null : !((Object)this$checkResultFilterList).equals(other$checkResultFilterList)) {
            return false;
        }
        List<DuplicateCheckHighRiskDetector> this$highRiskDetectorList = this.getHighRiskDetectorList();
        List<DuplicateCheckHighRiskDetector> other$highRiskDetectorList = other.getHighRiskDetectorList();
        if (this$highRiskDetectorList == null ? other$highRiskDetectorList != null : !((Object)this$highRiskDetectorList).equals(other$highRiskDetectorList)) {
            return false;
        }
        List<String> this$templateTextList = this.getTemplateTextList();
        List<String> other$templateTextList = other.getTemplateTextList();
        if (this$templateTextList == null ? other$templateTextList != null : !((Object)this$templateTextList).equals(other$templateTextList)) {
            return false;
        }
        DuplicateCheckResultHandler this$resultHandler = this.getResultHandler();
        DuplicateCheckResultHandler other$resultHandler = other.getResultHandler();
        if (this$resultHandler == null ? other$resultHandler != null : !this$resultHandler.equals(other$resultHandler)) {
            return false;
        }
        List<String> this$excludeRegList = this.getExcludeRegList();
        List<String> other$excludeRegList = other.getExcludeRegList();
        return !(this$excludeRegList == null ? other$excludeRegList != null : !((Object)this$excludeRegList).equals(other$excludeRegList));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DuplicateCheckParamConfiguration;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isTemplateParseFlag() ? 79 : 97);
        Double $simThresh = this.getSimThresh();
        result = result * 59 + ($simThresh == null ? 43 : ((Object)$simThresh).hashCode());
        Integer $minTextLength = this.getMinTextLength();
        result = result * 59 + ($minTextLength == null ? 43 : ((Object)$minTextLength).hashCode());
        Integer $minTableLength = this.getMinTableLength();
        result = result * 59 + ($minTableLength == null ? 43 : ((Object)$minTableLength).hashCode());
        Boolean $duplicateImageFlag = this.getDuplicateImageFlag();
        result = result * 59 + ($duplicateImageFlag == null ? 43 : ((Object)$duplicateImageFlag).hashCode());
        Boolean $textSegmentation = this.getTextSegmentation();
        result = result * 59 + ($textSegmentation == null ? 43 : ((Object)$textSegmentation).hashCode());
        DuplicateCheckUpdateModelEnum $updateModel = this.getUpdateModel();
        result = result * 59 + ($updateModel == null ? 43 : ((Object)((Object)$updateModel)).hashCode());
        String $templateLibId = this.getTemplateLibId();
        result = result * 59 + ($templateLibId == null ? 43 : $templateLibId.hashCode());
        String $chapterMatchType = this.getChapterMatchType();
        result = result * 59 + ($chapterMatchType == null ? 43 : $chapterMatchType.hashCode());
        DuplicateCheckCandidateElementExtractor $candidateElementExtractor = this.getCandidateElementExtractor();
        result = result * 59 + ($candidateElementExtractor == null ? 43 : $candidateElementExtractor.hashCode());
        List<DuplicateCheckChapterConfig> $chapterConfigList = this.getChapterConfigList();
        result = result * 59 + ($chapterConfigList == null ? 43 : ((Object)$chapterConfigList).hashCode());
        List<MultipartFile> $templateDocumentList = this.getTemplateDocumentList();
        result = result * 59 + ($templateDocumentList == null ? 43 : ((Object)$templateDocumentList).hashCode());
        List<DuplicateCheckCandidateElementPostProcessor> $candidateElementPostProcessorList = this.getCandidateElementPostProcessorList();
        result = result * 59 + ($candidateElementPostProcessorList == null ? 43 : ((Object)$candidateElementPostProcessorList).hashCode());
        List<DuplicateCheckResultFilter> $checkResultFilterList = this.getCheckResultFilterList();
        result = result * 59 + ($checkResultFilterList == null ? 43 : ((Object)$checkResultFilterList).hashCode());
        List<DuplicateCheckHighRiskDetector> $highRiskDetectorList = this.getHighRiskDetectorList();
        result = result * 59 + ($highRiskDetectorList == null ? 43 : ((Object)$highRiskDetectorList).hashCode());
        List<String> $templateTextList = this.getTemplateTextList();
        result = result * 59 + ($templateTextList == null ? 43 : ((Object)$templateTextList).hashCode());
        DuplicateCheckResultHandler $resultHandler = this.getResultHandler();
        result = result * 59 + ($resultHandler == null ? 43 : $resultHandler.hashCode());
        List<String> $excludeRegList = this.getExcludeRegList();
        result = result * 59 + ($excludeRegList == null ? 43 : ((Object)$excludeRegList).hashCode());
        return result;
    }

    public String toString() {
        return "DuplicateCheckParamConfiguration(simThresh=" + this.getSimThresh() + ", minTextLength=" + this.getMinTextLength() + ", minTableLength=" + this.getMinTableLength() + ", duplicateImageFlag=" + this.getDuplicateImageFlag() + ", updateModel=" + (Object)((Object)this.getUpdateModel()) + ", templateLibId=" + this.getTemplateLibId() + ", chapterMatchType=" + this.getChapterMatchType() + ", candidateElementExtractor=" + this.getCandidateElementExtractor() + ", chapterConfigList=" + this.getChapterConfigList() + ", templateDocumentList=" + this.getTemplateDocumentList() + ", candidateElementPostProcessorList=" + this.getCandidateElementPostProcessorList() + ", checkResultFilterList=" + this.getCheckResultFilterList() + ", highRiskDetectorList=" + this.getHighRiskDetectorList() + ", templateTextList=" + this.getTemplateTextList() + ", templateParseFlag=" + this.isTemplateParseFlag() + ", textSegmentation=" + this.getTextSegmentation() + ", resultHandler=" + this.getResultHandler() + ", excludeRegList=" + this.getExcludeRegList() + ")";
    }

    public DuplicateCheckParamConfiguration(Double simThresh, Integer minTextLength, Integer minTableLength, Boolean duplicateImageFlag, DuplicateCheckUpdateModelEnum updateModel, String templateLibId, String chapterMatchType, DuplicateCheckCandidateElementExtractor candidateElementExtractor, List<DuplicateCheckChapterConfig> chapterConfigList, List<MultipartFile> templateDocumentList, List<DuplicateCheckCandidateElementPostProcessor> candidateElementPostProcessorList, List<DuplicateCheckResultFilter> checkResultFilterList, List<DuplicateCheckHighRiskDetector> highRiskDetectorList, List<TemplateText> templateTextList, boolean templateParseFlag, Boolean textSegmentation, DuplicateCheckResultHandler resultHandler, List<String> excludeRegList) {
        this.simThresh = simThresh;
        this.minTextLength = minTextLength;
        this.minTableLength = minTableLength;
        this.duplicateImageFlag = duplicateImageFlag;
        this.updateModel = updateModel;
        this.templateLibId = templateLibId;
        this.chapterMatchType = chapterMatchType;
        this.candidateElementExtractor = candidateElementExtractor;
        this.chapterConfigList = chapterConfigList;
        this.templateDocumentList = templateDocumentList;
        this.candidateElementPostProcessorList = candidateElementPostProcessorList;
        this.checkResultFilterList = checkResultFilterList;
        this.highRiskDetectorList = highRiskDetectorList;
        this.templateTextList = templateTextList;
        this.templateParseFlag = templateParseFlag;
        this.textSegmentation = textSegmentation;
        this.resultHandler = resultHandler;
        this.excludeRegList = excludeRegList;
    }

    private class TemplateText {
        private MultipartFile file;
        private String text;

        public MultipartFile getFile() {
            return this.file;
        }

        public String getText() {
            return this.text;
        }

        public void setFile(MultipartFile file) {
            this.file = file;
        }

        public void setText(String text) {
            this.text = text;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TemplateText)) {
                return false;
            }
            TemplateText other = (TemplateText)o;
            if (!other.canEqual(this)) {
                return false;
            }
            MultipartFile this$file = this.getFile();
            MultipartFile other$file = other.getFile();
            if (this$file == null ? other$file != null : !this$file.equals(other$file)) {
                return false;
            }
            String this$text = this.getText();
            String other$text = other.getText();
            return !(this$text == null ? other$text != null : !this$text.equals(other$text));
        }

        protected boolean canEqual(Object other) {
            return other instanceof TemplateText;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            MultipartFile $file = this.getFile();
            result = result * 59 + ($file == null ? 43 : $file.hashCode());
            String $text = this.getText();
            result = result * 59 + ($text == null ? 43 : $text.hashCode());
            return result;
        }

        public String toString() {
            return "DuplicateCheckParamConfiguration.TemplateText(file=" + this.getFile() + ", text=" + this.getText() + ")";
        }

        public TemplateText(MultipartFile file, String text) {
            this.file = file;
            this.text = text;
        }

        public TemplateText() {
        }
    }
}

