/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.icpac.core.handler.highrisk;

import com.jxdinfo.idp.common.util.StringUtils;
import com.jxdinfo.idp.icpac.core.entity.resp.DuplicateCheckSentenceResultResponse;
import com.jxdinfo.idp.icpac.core.entity.resp.DuplicateCheckSimilarResultResponse;
import com.jxdinfo.idp.icpac.core.handler.highrisk.DuplicateCheckHighRiskDetector;
import com.jxdinfo.idp.icpac.core.handler.highrisk.DuplicateCheckHighRiskResult;
import com.jxdinfo.idp.icpac.core.storage.DuplicateCheckCandidateDocument;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class AbstractRegHighRiskDetector
implements DuplicateCheckHighRiskDetector {
    @Override
    public DuplicateCheckHighRiskResult detected(DuplicateCheckSentenceResultResponse candidateSentence, DuplicateCheckSimilarResultResponse simiSentenceResult, DuplicateCheckCandidateDocument info) {
        String candidateSentenceStr = candidateSentence.getSentence();
        String simiSentenceStr = simiSentenceResult.getSentence();
        if (StringUtils.isEmpty((String)candidateSentenceStr) || StringUtils.isEmpty((String)simiSentenceStr)) {
            return null;
        }
        Pattern pattern = this.getPattern();
        DuplicateCheckHighRiskResult riskResult = this.getHighRiskReturn();
        List<String> regContentOfCandidateSenList = this.extractRegContent(candidateSentenceStr, pattern);
        List<String> regContentOfSimiSenList = this.extractRegContent(simiSentenceStr, pattern);
        for (String regContentOfCandidateSen : regContentOfCandidateSenList) {
            for (String regContentOfSimiSen : regContentOfSimiSenList) {
                if (!Objects.equals(regContentOfSimiSen, regContentOfCandidateSen)) continue;
                riskResult.addRiskContent(regContentOfCandidateSen);
            }
        }
        return riskResult;
    }

    protected abstract DuplicateCheckHighRiskResult getHighRiskReturn();

    protected List<String> extractRegContent(String content, Pattern pattern) {
        ArrayList<String> regContentOfExtractedList = new ArrayList<String>();
        Matcher candidateSenMatcher = pattern.matcher(content);
        while (candidateSenMatcher.find()) {
            String regContent = candidateSenMatcher.group(1);
            regContentOfExtractedList.add(regContent);
        }
        return regContentOfExtractedList;
    }

    protected abstract Pattern getPattern();
}

