/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.icpac.core.executor;

import com.jxdinfo.idp.icpac.core.enmus.DuplicateCheckExecuteModelEnum;
import com.jxdinfo.idp.icpac.core.entity.DuplicateCheckTaskResult;
import com.jxdinfo.idp.icpac.core.executor.DuplicateCheckTaskFinalizer;
import com.jxdinfo.idp.icpac.core.executor.task.DuplicateCheckTaskExecutor;
import com.jxdinfo.idp.icpac.core.executor.task.impl.DuplicateCheckTaskFactory;
import com.jxdinfo.idp.icpac.core.progress.DuplicateCheckProgress;
import com.jxdinfo.idp.icpac.core.storage.DuplicateCheckCandidateDocument;
import com.jxdinfo.idp.icpac.core.storage.DuplicateCheckContext;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ThreadPoolExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DuplicateCheckTaskDispatcher {
    private static final Logger log = LoggerFactory.getLogger(DuplicateCheckTaskDispatcher.class);
    private final DuplicateCheckContext context;

    public DuplicateCheckTaskDispatcher(DuplicateCheckContext context) {
        if (context == null) {
            throw new NullPointerException("\u7ed9\u5b9a\u7684\u67e5\u91cd\u4fe1\u606f\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u8fdb\u884c\u4e0b\u4e00\u6b65\u67e5\u91cd");
        }
        this.context = context;
    }

    public void dispatch() {
        ThreadPoolExecutor taskExecutors = this.context.getTaskThreadPool();
        List<DuplicateCheckCandidateDocument> candidateDocumentList = this.context.getAllCandidateDocumentList();
        for (DuplicateCheckCandidateDocument candidateDocument : candidateDocumentList) {
            try {
                DuplicateCheckTaskExecutor taskExecutor = DuplicateCheckTaskFactory.getTask(candidateDocument);
                CompletableFuture.runAsync(taskExecutor, taskExecutors);
            }
            catch (Exception e) {
                DuplicateCheckProgress.setFail(candidateDocument.getDocumentId());
                log.error((Object)((Object)candidateDocument.getOperationModel()) + "\u6267\u884c\u51fa\u9519", (Throwable)e);
                DuplicateCheckTaskResult taskResult = new DuplicateCheckTaskResult();
                if (e instanceof NullPointerException) {
                    taskResult.setError(new RuntimeException("\u7a7a\u6307\u9488\u5f02\u5e38"));
                } else {
                    taskResult.setError(e);
                }
                candidateDocument.setCheckTaskResult(taskResult);
                candidateDocument.completeTask();
                DuplicateCheckProgress.setProgress(candidateDocument.getDocumentId(), -1);
            }
        }
        DuplicateCheckExecuteModelEnum modelEnum = this.context.getExecutorModelEnum();
        DuplicateCheckTaskFinalizer taskExecutor = new DuplicateCheckTaskFinalizer(this.context);
        if (modelEnum == DuplicateCheckExecuteModelEnum.SYNC) {
            taskExecutor.run();
        } else {
            CompletableFuture.runAsync(taskExecutor);
        }
    }
}

