/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.icpac.core.storage.builder;

import com.jxdinfo.idp.icpac.core.enmus.DuplicateCheckUpdateModelEnum;
import com.jxdinfo.idp.icpac.core.entity.DuplicateCheckChapterConfig;
import com.jxdinfo.idp.icpac.core.handler.DuplicateCheckCandidateElementPostProcessor;
import com.jxdinfo.idp.icpac.core.handler.DuplicateCheckResultHandler;
import com.jxdinfo.idp.icpac.core.handler.highrisk.DuplicateCheckHighRiskDetector;
import com.jxdinfo.idp.icpac.core.handler.resultfilter.DuplicateCheckResultFilter;
import com.jxdinfo.idp.icpac.core.handler.sentencehandler.DuplicateCheckCandidateElementExtractor;
import com.jxdinfo.idp.icpac.core.storage.DuplicateCheckParamConfiguration;
import java.util.List;
import org.springframework.web.multipart.MultipartFile;

public class DuplicateCheckParamConfigurationBuilder {
    private DuplicateCheckParamConfiguration paramConfiguration = new DuplicateCheckParamConfiguration();

    private DuplicateCheckParamConfigurationBuilder() {
    }

    public static DuplicateCheckParamConfigurationBuilder build() {
        return new DuplicateCheckParamConfigurationBuilder();
    }

    public DuplicateCheckParamConfigurationBuilder simiThresh(Double simThresh) {
        this.paramConfiguration.setSimThresh(simThresh);
        return this;
    }

    public DuplicateCheckParamConfigurationBuilder minTextLength(int minTableLength) {
        this.paramConfiguration.setMinTextLength(minTableLength);
        return this;
    }

    public DuplicateCheckParamConfigurationBuilder minTableLength(int minTableLength) {
        this.paramConfiguration.setMinTableLength(minTableLength);
        return this;
    }

    public DuplicateCheckParamConfigurationBuilder duplicateImageFlag(String duplicateImageFlag) {
        this.paramConfiguration.setDuplicateImageFlag(duplicateImageFlag);
        return this;
    }

    public DuplicateCheckParamConfigurationBuilder updateModel(String updateModel) {
        this.paramConfiguration.setUpdateModel(DuplicateCheckUpdateModelEnum.getUpdateModel(updateModel));
        return this;
    }

    public DuplicateCheckParamConfigurationBuilder updateModel(DuplicateCheckUpdateModelEnum updateModel) {
        this.paramConfiguration.setUpdateModel(updateModel);
        return this;
    }

    public DuplicateCheckParamConfigurationBuilder templateLibId(String templateLibId) {
        this.paramConfiguration.setTemplateLibId(templateLibId);
        return this;
    }

    public DuplicateCheckParamConfigurationBuilder chapterMatchType(String chapterMatchType) {
        this.paramConfiguration.setChapterMatchType(chapterMatchType);
        return this;
    }

    public DuplicateCheckParamConfigurationBuilder addTemplateDocument(MultipartFile templateDocument) {
        this.paramConfiguration.addTemplateDocument(templateDocument);
        return this;
    }

    public DuplicateCheckParamConfigurationBuilder addAllTemplateDocument(List<MultipartFile> templateDocumentList) {
        this.paramConfiguration.addAllTemplateDocument(templateDocumentList);
        return this;
    }

    public DuplicateCheckParamConfigurationBuilder addCandidatePostProcessor(DuplicateCheckCandidateElementPostProcessor candidateElementPostProcessor) {
        this.paramConfiguration.addCandidatePostProcessor(candidateElementPostProcessor);
        return this;
    }

    public DuplicateCheckParamConfigurationBuilder addAllCandidatePostProcessor(List<DuplicateCheckCandidateElementPostProcessor> candidateElementPostProcessorList) {
        this.paramConfiguration.addAllCandidatePostProcessor(candidateElementPostProcessorList);
        return this;
    }

    public DuplicateCheckParamConfigurationBuilder addCheckResultFilter(DuplicateCheckResultFilter checkResultFilter) {
        this.paramConfiguration.addCheckResultFilter(checkResultFilter);
        return this;
    }

    public DuplicateCheckParamConfigurationBuilder addAllCheckResultFilter(List<DuplicateCheckResultFilter> checkResultFilterList) {
        this.paramConfiguration.addAllCheckResultFilter(checkResultFilterList);
        return this;
    }

    public DuplicateCheckParamConfigurationBuilder addHighRiskDetector(DuplicateCheckHighRiskDetector highRiskDetector) {
        this.paramConfiguration.addHighRiskDetector(highRiskDetector);
        return this;
    }

    public DuplicateCheckParamConfigurationBuilder addAllHighRiskDetector(List<DuplicateCheckHighRiskDetector> highRiskDetectorList) {
        this.paramConfiguration.addAllHighRiskDetector(highRiskDetectorList);
        return this;
    }

    public DuplicateCheckParamConfigurationBuilder addChapterConfig(DuplicateCheckChapterConfig chapterConfig) {
        this.paramConfiguration.addChapterConfig(chapterConfig);
        return this;
    }

    public DuplicateCheckParamConfigurationBuilder addAllChapterConfig(List<DuplicateCheckChapterConfig> chapterConfigList) {
        this.paramConfiguration.addAllChapterConfig(chapterConfigList);
        return this;
    }

    public DuplicateCheckParamConfigurationBuilder addExcludeReg(String exclude) {
        this.paramConfiguration.addExcludeReg(exclude);
        return this;
    }

    public DuplicateCheckParamConfigurationBuilder addAllExcludeReg(List<String> excludeRegList) {
        this.paramConfiguration.addAllExcludeReg(excludeRegList);
        return this;
    }

    public DuplicateCheckParamConfiguration create() {
        return this.paramConfiguration;
    }

    public DuplicateCheckParamConfigurationBuilder resultHandler(DuplicateCheckResultHandler defaultResultHandler) {
        this.paramConfiguration.setResultHandler(defaultResultHandler);
        return this;
    }

    public DuplicateCheckParamConfigurationBuilder textSegmentation(boolean textSegment) {
        this.paramConfiguration.setTextSegmentation(textSegment);
        return this;
    }

    public DuplicateCheckParamConfigurationBuilder candidateElementExtractor(DuplicateCheckCandidateElementExtractor candidateElementExtractor) {
        this.paramConfiguration.setCandidateElementExtractor(candidateElementExtractor);
        return this;
    }
}

