/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.icpac.core.view.impl;

import com.jxdinfo.idp.icpac.core.utils.FilenameUtils;
import com.jxdinfo.idp.icpac.core.view.FrontViewHandler;
import com.jxdinfo.idp.icpac.core.view.HighlightLocation;
import java.util.List;
import java.util.Objects;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.springframework.util.Base64Utils;
import org.springframework.web.multipart.MultipartFile;

public class PdfViewHandler
implements FrontViewHandler {
    @Override
    public boolean support(MultipartFile file) {
        if (file == null) {
            return false;
        }
        String filename = file.getOriginalFilename();
        String fileSuffix = FilenameUtils.getFileSuffix(filename);
        return Objects.equals("pdf", fileSuffix);
    }

    @Override
    public void handleView(HttpServletResponse response, List<? extends HighlightLocation> locationList, MultipartFile file, String filePath, String pdfPath) throws Exception {
        String originalFilename = file.getOriginalFilename();
        response.setHeader("Content-disposition", "attachment;filename=\"" + originalFilename + "\"");
        try (ServletOutputStream outputStream = response.getOutputStream();){
            outputStream.write(Base64Utils.encodeToString((byte[])file.getBytes()).getBytes());
            outputStream.flush();
        }
    }

    @Override
    public byte[] handleView(List<? extends HighlightLocation> locationList, MultipartFile file) throws Exception {
        return Base64Utils.encodeToString((byte[])file.getBytes()).getBytes();
    }
}

