/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.icpac.core.executor.task.impl;

import com.jxdinfo.idp.icpac.core.enmus.DuplicateCheckUpdateModelEnum;
import com.jxdinfo.idp.icpac.core.entity.DuplicateCheckTaskResult;
import com.jxdinfo.idp.icpac.core.entity.resp.DuplicateCheckImgResponse;
import com.jxdinfo.idp.icpac.core.entity.resp.DuplicateCheckResultResponse;
import com.jxdinfo.idp.icpac.core.entity.resp.DuplicateCheckVectorizationResultResponse;
import com.jxdinfo.idp.icpac.core.executor.task.AbstractDuplicateCheckTaskExecutor;
import com.jxdinfo.idp.icpac.core.progress.DuplicateCheckProgress;
import java.util.Collections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DuplicateCheckCheckTaskExecutor
extends AbstractDuplicateCheckTaskExecutor {
    private static final Logger log = LoggerFactory.getLogger(DuplicateCheckCheckTaskExecutor.class);

    @Override
    public DuplicateCheckTaskResult runCheckTask() throws Exception {
        this.vectorization();
        DuplicateCheckTaskResult checkTaskResult = this.executeCheck();
        DuplicateCheckProgress.setProgress(this.candidateDocument.getDocumentId(), 100);
        return checkTaskResult;
    }

    private void vectorization() throws Exception {
        try {
            if (this.candidateDocument.getUpdateModel() != DuplicateCheckUpdateModelEnum.NO_PERSIST) {
                log.info(this.candidateDocument.getFileName() + "\u5f00\u59cb\u5411\u91cf\u5316");
                log.info("{}\u5f00\u59cb\u6267\u884c\u5220\u9664\u5386\u53f2\u6570\u636e", (Object)this.candidateDocument.getFileName());
                this.candidateDocument.addAttachment("uploadIds", Collections.singletonList(this.candidateDocument.getDocumentId()));
                String deleteResult = this.duplicateChecker.deleteRemoteDoc(this.candidateDocument);
                log.info("{} \u5220\u9664\u5411\u91cf\u5316\u5b8c\u6bd5\uff0c\u7ed3\u679c\u4e3a\uff1a{}", (Object)this.candidateDocument.getFileName(), (Object)deleteResult);
                DuplicateCheckVectorizationResultResponse vectorization = this.duplicateChecker.vectorization(this.candidateDocument);
                if (this.candidateDocument.isDuplicateImageFlag()) {
                    this.duplicateChecker.vectorizationImage(this.candidateDocument);
                }
                if (vectorization != null) {
                    log.info(this.candidateDocument.getFileName() + "\u5411\u91cf\u5316\u7ed3\u675f\uff0c\u5411\u91cf\u5316\u7684\u7ed3\u679c\u4e3a\uff1a" + vectorization);
                }
            }
        }
        finally {
            this.candidateDocument.waitOthers();
        }
    }

    private DuplicateCheckTaskResult executeCheck() throws Exception {
        DuplicateCheckTaskResult checkResult = new DuplicateCheckTaskResult();
        log.info(this.candidateDocument.getFileName() + "\u5f00\u59cb\u8fdb\u884c\u67e5\u91cd");
        DuplicateCheckUpdateModelEnum updateModel = this.candidateDocument.getUpdateModel();
        DuplicateCheckResultResponse response = null;
        response = updateModel == DuplicateCheckUpdateModelEnum.NO_PERSIST ? this.duplicateChecker.checkRepeat(this.candidateDocument) : this.duplicateChecker.checkRepeatNoVectorization(this.candidateDocument);
        checkResult.setExecutionResult(response);
        if (this.candidateDocument.isDuplicateImageFlag()) {
            DuplicateCheckImgResponse imgResponse = this.duplicateChecker.checkRepeatImg(this.candidateDocument);
            checkResult.setImgExecutionResult(imgResponse);
        }
        return checkResult;
    }
}

