/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.icpac.core.executor.task;

import com.jxdinfo.idp.icpac.core.duplicate.DuplicateChecker;
import com.jxdinfo.idp.icpac.core.duplicate.DuplicateCheckerFactory;
import com.jxdinfo.idp.icpac.core.entity.DuplicateCheckTaskResult;
import com.jxdinfo.idp.icpac.core.executor.task.DuplicateCheckTaskExecutor;
import com.jxdinfo.idp.icpac.core.storage.DuplicateCheckCandidateDocument;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDuplicateCheckTaskExecutor
implements DuplicateCheckTaskExecutor {
    private static final Logger log = LoggerFactory.getLogger(AbstractDuplicateCheckTaskExecutor.class);
    protected DuplicateCheckCandidateDocument candidateDocument;
    protected DuplicateChecker duplicateChecker;

    @Override
    public void init(DuplicateCheckCandidateDocument candidateDocument) {
        this.candidateDocument = candidateDocument;
        this.duplicateChecker = DuplicateCheckerFactory.get(candidateDocument);
    }

    @Override
    public void run() {
        log.info("{} : \u5f00\u59cb\u64cd\u4f5c:{}", (Object)this.candidateDocument.getFileName(), (Object)this.candidateDocument.getOperationModel());
        try {
            this.candidateDocument.setCheckTaskResult(this.runCheckTask());
        }
        catch (Exception ex) {
            DuplicateCheckTaskResult checkResult = new DuplicateCheckTaskResult();
            if (ex instanceof NullPointerException) {
                checkResult.setError(new RuntimeException("\u7a7a\u6307\u9488\u5f02\u5e38"));
            } else {
                checkResult.setError(ex);
            }
            this.candidateDocument.setCheckTaskResult(checkResult);
            log.error("{}\u51fa\u73b0\u9519\u8bef", this.getClass(), (Object)ex);
        }
        log.info("{} : \u7ed3\u675f\u64cd\u4f5c:{}", (Object)this.candidateDocument.getFileName(), (Object)this.candidateDocument.getOperationModel());
        this.candidateDocument.completeTask();
    }

    protected abstract DuplicateCheckTaskResult runCheckTask() throws Exception;
}

