/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.icpac.core.duplicate.vectorization.remote;

import com.jxdinfo.idp.icpac.core.duplicate.vectorization.remote.DuplicateCheckRemoteServer;
import com.jxdinfo.idp.icpac.core.duplicate.vectorization.remote.feign.MutilCompareFeignHttp;
import com.jxdinfo.idp.icpac.core.entity.request.DuplicateCheckCancelIgnoreSentence;
import com.jxdinfo.idp.icpac.core.entity.request.DuplicateCheckIgnoreSentence;
import com.jxdinfo.idp.icpac.core.entity.request.DuplicateCheckRimDoc;
import com.jxdinfo.idp.icpac.core.entity.resp.DuplicateCheckIgnoreResponse;
import com.jxdinfo.idp.icpac.core.entity.resp.DuplicateCheckImgResponse;
import com.jxdinfo.idp.icpac.core.entity.resp.DuplicateCheckResultResponse;
import com.jxdinfo.idp.icpac.core.entity.resp.DuplicateCheckVectorizationImageResultResponse;
import com.jxdinfo.idp.icpac.core.entity.resp.DuplicateCheckVectorizationResultResponse;
import com.jxdinfo.idp.icpac.core.paramconfig.DefaultParamConfig;
import com.jxdinfo.idp.icpac.core.presist.images.entity.DuplicateCheckCandidateImage;
import com.jxdinfo.idp.icpac.core.progress.DuplicateCheckProgress;
import com.jxdinfo.idp.icpac.core.storage.DuplicateCheckCandidateDocument;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DefaultDuplicateCheckRemoteServer
implements DuplicateCheckRemoteServer {
    private static final Logger log = LoggerFactory.getLogger(DefaultDuplicateCheckRemoteServer.class);
    @Autowired
    protected MutilCompareFeignHttp iMutilCompareFeignHttp;

    public Map<String, Object> initRequestParam(DuplicateCheckCandidateDocument candidateDocument) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("sentence", candidateDocument.getCandidateSentenceList());
        param.put("project_id", candidateDocument.getLibId());
        param.put("document_id", candidateDocument.getDocumentId());
        param.put("sim_thresh", candidateDocument.getSimThresh());
        param.put("update_lib", candidateDocument.getUpdateModel().getFlag());
        param.put("template_id", candidateDocument.getTemplateProjectId());
        param.put("template_sim_thresh", candidateDocument.getSimThresh() - 20.0 < 0.0 ? 20.0 : candidateDocument.getSimThresh() - 20.0);
        param.put("sim_diff_thresh", DefaultParamConfig.SIM_DIFF_THRESH);
        param.put("template_sim_diff_thresh", DefaultParamConfig.TEMPLATE_SIM_DIFF_THRESH);
        return param;
    }

    @Override
    public DuplicateCheckResultResponse checkRepeat(DuplicateCheckCandidateDocument info) throws IOException {
        log.info("\u8c03\u7528\u5ba1\u67e5\u670d\u52a1\u5f00\u542f\u3002\u3002\u3002\u3002\u3002\u3002");
        String checkId = info.getDocumentId();
        Map<String, Object> requestParam = this.initRequestParam(info);
        DuplicateCheckResultResponse response = (DuplicateCheckResultResponse)this.iMutilCompareFeignHttp.compare(requestParam).getData();
        log.info("\u8c03\u7528\u5ba1\u67e5\u670d\u52a1\u7ed3\u675f\u3002");
        DuplicateCheckProgress.setProgress(checkId, 20);
        return response;
    }

    @Override
    public DuplicateCheckResultResponse checkRepeatNoVectorization(DuplicateCheckCandidateDocument info) {
        log.info("\u8c03\u7528\u5ba1\u67e5\u670d\u52a1\u5f00\u542f\u3002\u3002\u3002\u3002\u3002\u3002");
        String checkId = info.getDocumentId();
        Map<String, Object> requestParam = this.initRequestParam(info);
        DuplicateCheckResultResponse response = (DuplicateCheckResultResponse)this.iMutilCompareFeignHttp.compareNoVectorization(requestParam).getData();
        log.info("\u8c03\u7528\u5ba1\u67e5\u670d\u52a1\u7ed3\u675f\u3002");
        DuplicateCheckProgress.setProgress(checkId, 20);
        return response;
    }

    @Override
    public DuplicateCheckVectorizationResultResponse vectorization(DuplicateCheckCandidateDocument info) {
        log.info("\u8c03\u7528\u5411\u91cf\u5316\u670d\u52a1\u5f00\u59cb\u3002\u3002\u3002\u3002\u3002\u3002");
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("sentence", info.getCandidateSentenceList());
        map.put("project_id", info.getLibId());
        map.put("document_id", info.getDocumentId());
        map.put("update_lib", info.getUpdateModel().getFlag());
        DuplicateCheckVectorizationResultResponse vectorization = this.iMutilCompareFeignHttp.vectorization(map);
        log.info("\u8c03\u7528\u5411\u91cf\u5316\u670d\u52a1\u7ed3\u675f");
        return vectorization;
    }

    @Override
    public DuplicateCheckIgnoreResponse cancelIgnoreSentence(DuplicateCheckCandidateDocument checkInfo) {
        String projectId = checkInfo.getLibId();
        if (StringUtils.isEmpty((CharSequence)projectId)) {
            return null;
        }
        String textId = checkInfo.getAttachment("aiTextId", String.class);
        if (StringUtils.isEmpty((CharSequence)textId)) {
            return null;
        }
        return (DuplicateCheckIgnoreResponse)this.iMutilCompareFeignHttp.cancelIgnoreSentence(new DuplicateCheckCancelIgnoreSentence(projectId, textId)).getData();
    }

    @Override
    public DuplicateCheckVectorizationImageResultResponse addImages(DuplicateCheckCandidateDocument checkInfo) {
        List<DuplicateCheckCandidateImage> imageList = checkInfo.getCandidateImageList();
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("project_id", checkInfo.getLibId());
        params.put("document_id", checkInfo.getDocumentId());
        ArrayList imgParamList = new ArrayList();
        for (DuplicateCheckCandidateImage candidateImage : imageList) {
            HashMap<String, String> imgParam = new HashMap<String, String>();
            imgParam.put("img_id", candidateImage.getId() + "");
            imgParam.put("img_file", candidateImage.getBase64());
            imgParam.put("filename", candidateImage.getFileName());
            imgParamList.add(imgParam);
        }
        params.put("img", imgParamList);
        return this.iMutilCompareFeignHttp.addImages(params);
    }

    @Override
    public DuplicateCheckImgResponse imagesim(DuplicateCheckCandidateDocument checkInfo) {
        List<DuplicateCheckCandidateImage> imageList = checkInfo.getCandidateImageList();
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("sim_thr", checkInfo.getSimThresh());
        params.put("project_id", checkInfo.getLibId());
        params.put("document_id", checkInfo.getDocumentId());
        ArrayList imgParamList = new ArrayList();
        for (DuplicateCheckCandidateImage candidateImage : imageList) {
            HashMap<String, String> imgParam = new HashMap<String, String>();
            imgParam.put("img_id", candidateImage.getId() + "");
            imgParamList.add(imgParam);
        }
        params.put("img", imgParamList);
        return this.iMutilCompareFeignHttp.imagesim(params);
    }

    @Override
    public String deleteRemoteDoc(DuplicateCheckCandidateDocument info) {
        List docIds = info.getAttachment("uploadIds", List.class);
        DuplicateCheckRimDoc rimDoc = new DuplicateCheckRimDoc();
        if (CollectionUtils.isEmpty((Collection)docIds)) {
            return "\u6ca1\u6709docId \u65e0\u9700\u5220\u9664";
        }
        rimDoc.setDocument_id(docIds);
        String projectId = info.getLibId();
        if (StringUtils.isEmpty((CharSequence)projectId)) {
            return "\u6ca1\u6709projectId \u65e0\u9700\u5220\u9664";
        }
        rimDoc.setProject_id(projectId);
        String deleteResult = this.iMutilCompareFeignHttp.deleteRemoteDoc(Arrays.asList(rimDoc));
        if (StringUtils.isNotEmpty((CharSequence)deleteResult)) {
            return deleteResult;
        }
        return "\u672a\u627e\u5230\u4efb\u4f55\u8fd4\u56de\u7ed3\u679c";
    }

    @Override
    public DuplicateCheckIgnoreResponse addIgnoreSentence(DuplicateCheckCandidateDocument info) {
        String projectId = info.getLibId();
        if (StringUtils.isEmpty((CharSequence)projectId)) {
            return null;
        }
        String text = info.getAttachment("sentence", String.class);
        if (StringUtils.isEmpty((CharSequence)text)) {
            return null;
        }
        return (DuplicateCheckIgnoreResponse)this.iMutilCompareFeignHttp.addIgnoreSentence(new DuplicateCheckIgnoreSentence(projectId, text)).getData();
    }
}

