/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.icpac.core.dochandler.impl;

import com.jxdinfo.idp.common.entity.util.docparse.word.WordCellInfo;
import com.jxdinfo.idp.common.entity.util.docparse.word.WordChapterInfo;
import com.jxdinfo.idp.common.entity.util.docparse.word.WordElementInfo;
import com.jxdinfo.idp.common.entity.util.docparse.word.WordImageInfo;
import com.jxdinfo.idp.common.entity.util.docparse.word.WordInfo;
import com.jxdinfo.idp.common.entity.util.docparse.word.WordParagraphInfo;
import com.jxdinfo.idp.common.entity.util.docparse.word.WordRowInfo;
import com.jxdinfo.idp.common.entity.util.docparse.word.WordTableInfo;
import com.jxdinfo.idp.common.pdfparser.arrange.MarkPdf;
import com.jxdinfo.idp.common.pdfparser.core.PdfParser;
import com.jxdinfo.idp.common.pdfparser.pojo.ContentPojo;
import com.jxdinfo.idp.icpac.core.dochandler.DocumentHandler;
import com.jxdinfo.idp.icpac.core.storage.DuplicateCheckCandidateDocument;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDResources;
import org.apache.pdfbox.pdmodel.graphics.PDXObject;
import org.apache.pdfbox.pdmodel.graphics.image.PDImageXObject;
import org.apache.pdfbox.pdmodel.interactive.documentnavigation.outline.PDDocumentOutline;
import org.apache.pdfbox.pdmodel.interactive.documentnavigation.outline.PDOutlineItem;
import org.apache.pdfbox.text.PDFTextStripper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.multipart.MultipartFile;

public class PdfDocumentHandler
implements DocumentHandler {
    private static final Logger log = LoggerFactory.getLogger(PdfDocumentHandler.class);
    private static final Pattern CHAPTER_PATTERN = Pattern.compile("^((\\d+\\.?)+)");
    private static final Pattern NUMBER_PATTERN = Pattern.compile("^(?:\u9644\u4ef6|\uff08|\\d+)[.)\uff09]?");
    private static final Pattern CATALOG_PATTERN = Pattern.compile("(.*?)(\\.\\.)+\\d+");
    private static final Pattern EXTRACT_CHAPTER_PATTERN = Pattern.compile("(.*?)(?=\\.\\.+)");
    private static final Pattern CAESURA_NOISE_PATTERN = Pattern.compile("^((\\d+[\u3001\uff09])+)");
    private static final Pattern MONTH_NOISE_PATTERN = Pattern.compile("^(\\d{4}[\u5e74/-]\\d{1,2})[\u6708/-]\\d{1,2}\u65e5?");
    private static final Pattern ROMAN_NUMERALS_PATTERN = Pattern.compile("^(M{0,3})(CM|CD|D?C{0,3})(XC|XL|L?X{0,3})(IX|IV|V?I{0,3})$");
    private static final int CHAPTER_MAX_LENGTH = 20;
    private Set<String> chapterNoSet = new HashSet<String>();
    Boolean isSpot = null;
    private final Map<String, PDFChapter> chapterCollection = new HashMap<String, PDFChapter>();
    private final List<String> chapterList = new ArrayList<String>();

    @Override
    public WordInfo structuredDoc(DuplicateCheckCandidateDocument info) throws Exception {
        MultipartFile file = info.getFile();
        WordInfo wordInfo = this.structuredDoc(file);
        if (wordInfo == null) {
            log.warn("\u5f53\u524d\u7684pdf\uff1a'{}' \u4e0d\u662f\u7535\u5b50\u7248 \u800c\u662f\u626b\u63cf\u4ef6", (Object)info.getFile().getOriginalFilename());
            return null;
        }
        return wordInfo;
    }

    @Override
    public WordInfo structuredDoc(MultipartFile file) throws Exception {
        long startTime = System.currentTimeMillis();
        ContentPojo contentPojo = this.parserPdf(file);
        log.info("\u89e3\u6790\u7ed3\u675f\uff0c\u8017\u65f6{}\u79d2", (Object)((System.currentTimeMillis() - startTime) / 1000L));
        if (contentPojo == null) {
            return null;
        }
        this.extractChapter(contentPojo);
        List<WordElementInfo> elementInfos = this.assembleFormatData(contentPojo);
        List<WordChapterInfo> wordChapterInfos = this.assembleChapter(elementInfos);
        WordInfo wordInfo = new WordInfo();
        wordInfo.setLevelChapterInfos(wordChapterInfos);
        wordInfo.setImageInfoList(contentPojo.getImageInfoList());
        return wordInfo;
    }

    private void extractChapter(ContentPojo contentPojo) {
        List pdfContentList = contentPojo.getOutList();
        boolean isSkip = true;
        for (int i = 0; i < pdfContentList.size(); ++i) {
            ContentPojo.contentElement pdfContent = (ContentPojo.contentElement)pdfContentList.get(i);
            String elementType = pdfContent.getElementType();
            if (!Objects.equals(elementType, "text") && !Objects.equals(elementType, "title")) continue;
            String text = pdfContent.getText().replaceAll(" ", "").replaceAll("\r", "");
            if (Objects.equals(text, "\u76ee\u5f55")) {
                isSkip = false;
                pdfContentList.remove(i);
                --i;
                continue;
            }
            if (isSkip || ROMAN_NUMERALS_PATTERN.matcher(text).matches()) continue;
            String[] maybeCatalogArr = text.split("\n");
            boolean isCatalog = false;
            int len = maybeCatalogArr.length;
            for (int j = 0; j < len; ++j) {
                String maybeCatalog = maybeCatalogArr[j];
                if (CATALOG_PATTERN.matcher(maybeCatalog).matches()) {
                    Matcher matcher = EXTRACT_CHAPTER_PATTERN.matcher(maybeCatalog);
                    if (!matcher.find()) continue;
                    this.chapterList.add(matcher.group(1));
                    isCatalog = true;
                    continue;
                }
                if (this.isContent(this.chapterList, maybeCatalog)) {
                    StringBuilder sb = new StringBuilder(maybeCatalog);
                    ++j;
                    while (j < len) {
                        sb.append(maybeCatalogArr[j]).append("\n");
                        ++j;
                    }
                    pdfContent.setText(sb.toString());
                    return;
                }
                this.chapterList.add(maybeCatalog);
                isCatalog = true;
            }
            if (!isCatalog) continue;
            pdfContentList.remove(i);
            --i;
        }
    }

    private boolean isContent(List<String> chapterList, String maybeContent) {
        maybeContent = maybeContent.replaceAll(" ", "").trim();
        for (String chapter : chapterList) {
            if (!(chapter = chapter.replaceAll(" ", "").trim()).contains(maybeContent) && !maybeContent.contains(chapter)) continue;
            return true;
        }
        return false;
    }

    private String formatText(String str) {
        return str.replaceAll("\n", "").replaceAll("\r", "").replaceAll(" ", "").trim();
    }

    private List<WordElementInfo> assembleFormatData(ContentPojo contentPojo) {
        ArrayList<WordElementInfo> eInfoList = new ArrayList<WordElementInfo>();
        List pdfContentList = contentPojo.getOutList();
        for (ContentPojo.contentElement pdfContent : pdfContentList) {
            String elementType = pdfContent.getElementType();
            if (Objects.equals("text", elementType) || Objects.equals("title", elementType)) {
                eInfoList.add((WordElementInfo)this.handleParagraph(pdfContent));
                continue;
            }
            if (!Objects.equals("table", elementType)) continue;
            List cellList = pdfContent.getCells();
            WordTableInfo wordTableInfo = new WordTableInfo();
            int tempRow = 1;
            WordRowInfo wordRowInfo = new WordRowInfo();
            for (ContentPojo.contentElement.InnerCell innerCell : cellList) {
                Integer rowIndex = innerCell.getRow_index();
                if (tempRow != rowIndex) {
                    wordTableInfo.addRow(wordRowInfo);
                    tempRow = rowIndex;
                    wordRowInfo = new WordRowInfo();
                }
                WordCellInfo wordCellInfo = new WordCellInfo();
                Integer rowSpan = innerCell.getRow_span() == null ? 1 : innerCell.getRow_span();
                Integer colSpan = innerCell.getCol_span() == null ? 1 : innerCell.getCol_span();
                if (rowSpan != 1 && colSpan != 1) {
                    wordCellInfo.setType(Integer.valueOf(2));
                } else {
                    wordCellInfo.setType(Integer.valueOf(1));
                }
                wordCellInfo.setRowSpan(rowSpan);
                wordCellInfo.setColSpan(colSpan);
                wordCellInfo.setText(this.formatText(innerCell.getText()));
                wordCellInfo.setPageNum(pdfContent.getPageNumber().intValue());
                wordRowInfo.addCell(wordCellInfo);
            }
            eInfoList.add((WordElementInfo)wordTableInfo);
        }
        return eInfoList;
    }

    private WordParagraphInfo handleParagraph(ContentPojo.contentElement pdfContent) {
        String text = pdfContent.getText().replaceAll(" ", "").trim();
        List<String> chapterList = this.chapterList;
        if (this.chapterCollection.size() > 0) {
            chapterList = new ArrayList<String>(this.chapterCollection.keySet());
        }
        if (CollectionUtils.isEmpty(chapterList)) {
            int level = 10;
            WordParagraphInfo paragraphInfo = new WordParagraphInfo();
            paragraphInfo.setType("para");
            paragraphInfo.setText(this.formatText(text));
            paragraphInfo.setLevel(level);
            return paragraphInfo;
        }
        for (String chapter : chapterList) {
            if (!Objects.equals(chapter.replaceAll(" ", ""), text)) continue;
            WordParagraphInfo paragraphInfo = new WordParagraphInfo();
            paragraphInfo.setType("para");
            paragraphInfo.setText(text);
            paragraphInfo.setLevel(this.getChapterLevel(text));
            return paragraphInfo;
        }
        WordParagraphInfo paragraphInfo = new WordParagraphInfo();
        paragraphInfo.setType("para");
        paragraphInfo.setText(this.formatText(text));
        paragraphInfo.setPageNum(pdfContent.getPageNumber().intValue());
        paragraphInfo.setLevel(10);
        return paragraphInfo;
    }

    private int getChapterLevel(String text) {
        Matcher matcher = CHAPTER_PATTERN.matcher(text);
        if (matcher.find()) {
            String chapterNo = matcher.group(1);
            String[] chapterNoArr = chapterNo.split("\\.");
            return chapterNoArr.length == 0 ? 1 : chapterNoArr.length;
        }
        return 1;
    }

    private ContentPojo parserPdf(MultipartFile file) throws IOException {
        try (PDDocument pdDocument = PDDocument.load((byte[])file.getBytes());){
            PDFTextStripper textStripper = new PDFTextStripper();
            String text = textStripper.getText(pdDocument);
            if (StringUtils.isEmpty((CharSequence)text) || text.length() < 10) {
                ContentPojo contentPojo = null;
                return contentPojo;
            }
            this.parseBookMark(pdDocument);
            ContentPojo contentPojo = PdfParser.parsingUnTaggedPdfWithTableDetection((PDDocument)pdDocument, (boolean)true);
            MarkPdf.markTitleSep((ContentPojo)contentPojo);
            List<WordImageInfo> imageInfoList = this.extractImages(pdDocument);
            contentPojo.setImageInfoList(imageInfoList);
            ContentPojo contentPojo2 = contentPojo;
            return contentPojo2;
        }
    }

    private List<WordImageInfo> extractImages(PDDocument pdDocument) {
        try {
            ArrayList<WordImageInfo> imageList = new ArrayList<WordImageInfo>();
            int imageCount = 0;
            for (int pageIndex = 0; pageIndex < pdDocument.getNumberOfPages(); ++pageIndex) {
                Iterable objectNames;
                PDPage page = pdDocument.getPage(pageIndex);
                PDResources resources = page.getResources();
                if (resources == null || (objectNames = resources.getXObjectNames()) == null) continue;
                for (COSName objName : objectNames) {
                    PDXObject pdxObject = resources.getXObject(objName);
                    if (!(pdxObject instanceof PDImageXObject)) continue;
                    PDImageXObject image = (PDImageXObject)pdxObject;
                    String format = this.determineImageFormat(image);
                    String fileName = String.format("page-%03d-img-%03d.%s", pageIndex + 1, ++imageCount, format);
                    BufferedImage bufferedImage = image.getImage();
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    ImageIO.write((RenderedImage)bufferedImage, format, baos);
                    byte[] bytes = baos.toByteArray();
                    imageList.add(new WordImageInfo(bytes, fileName));
                }
            }
            return imageList;
        }
        catch (Exception e) {
            log.error("pdf \u83b7\u53d6\u56fe\u7247\u5931\u8d25");
            return null;
        }
    }

    private String determineImageFormat(PDImageXObject image) throws IOException {
        int colorComponents;
        String format = image.getSuffix();
        if (format != null && !format.isEmpty()) {
            if ("jpg".equals(format = format.toLowerCase()) || "jpeg".equals(format)) {
                return "jpg";
            }
            if ("bmp".equals(format)) {
                return "bmp";
            }
            if ("png".equals(format)) {
                return "png";
            }
        }
        if ((colorComponents = image.getColorSpace().getNumberOfComponents()) > 3) {
            return "png";
        }
        return "jpg";
    }

    private void parseBookMark(PDDocument pdDocument) throws IOException {
        Iterable iter;
        PDDocumentOutline documentOutline = pdDocument.getDocumentCatalog().getDocumentOutline();
        if (documentOutline != null && (iter = documentOutline.children()) != null) {
            for (PDOutlineItem outlineItem : iter) {
                this.printBookmark(outlineItem, 0, null);
            }
        }
    }

    private void printBookmark(PDOutlineItem bookmark, int level, PDFChapter parent) throws IOException {
        String title = bookmark.getTitle();
        PDFChapter pdfChapter = new PDFChapter(title.replaceAll(" ", "").trim(), parent, level);
        this.chapterCollection.put(title.replaceAll(" ", ""), pdfChapter);
        Iterable children = bookmark.children();
        if (children != null) {
            for (PDOutlineItem child : children) {
                this.printBookmark(child, level + 1, pdfChapter);
            }
        }
    }

    private List<WordChapterInfo> assembleChapter(List<WordElementInfo> elementInfos) {
        if (this.chapterCollection.size() > 0) {
            log.info("\u5f53\u524d\u5e94\u7528\u7684\u662f\u6807\u7b7e\u9875");
            return this.assembleChapterByBookMark(elementInfos);
        }
        if (this.chapterList.size() > 0) {
            log.info("\u5f53\u524d\u5e94\u7528\u7684\u662f\u76ee\u5f55");
            return this.assembleChapterByCatalog(elementInfos);
        }
        WordChapterInfo before = null;
        ArrayList<WordChapterInfo> chapterList = new ArrayList<WordChapterInfo>();
        HashMap<Integer, List> chapterInfoMap = new HashMap<Integer, List>();
        for (WordElementInfo elementInfo : elementInfos) {
            WordChapterInfo chapterInfo;
            boolean isChapter;
            if (Objects.equals(elementInfo.getType(), "table")) {
                if (before == null) {
                    WordChapterInfo chapterInfo2 = new WordChapterInfo();
                    chapterInfo2.setTitleName("virtual_chapter");
                    chapterInfo2.addParagraph(elementInfo);
                    chapterInfo2.setLevel(null);
                    chapterList.add(chapterInfo2);
                    continue;
                }
                before.addParagraph(elementInfo);
                elementInfo.setBelongChapter(before.getTitleName());
                continue;
            }
            WordParagraphInfo paragraphInfo = (WordParagraphInfo)elementInfo;
            String text = paragraphInfo.getText().replaceAll(" ", "").trim();
            Matcher matcher = CHAPTER_PATTERN.matcher(text);
            String chapterNo = "";
            if (matcher.find()) {
                chapterNo = matcher.group();
            }
            boolean bl = isChapter = !text.replaceAll(chapterNo, "").startsWith("\uff09");
            if (isChapter && this.isChapter(chapterNo, paragraphInfo, before)) {
                chapterInfo = new WordChapterInfo();
                chapterInfo.setTitleName(paragraphInfo.getText());
                String[] chapterNoArr = chapterNo.split("\\.");
                int level = chapterNoArr.length - 1;
                List chapterInfoList = (List)chapterInfoMap.get(level - 1);
                if (chapterInfoList == null) {
                    chapterList.add(chapterInfo);
                } else {
                    WordChapterInfo parent = (WordChapterInfo)chapterInfoList.get(chapterInfoList.size() - 1);
                    parent.addChildChapter(chapterInfo);
                    chapterInfo.setParent(parent);
                }
                chapterInfoMap.computeIfAbsent(level, k -> new ArrayList()).add(chapterInfo);
                before = chapterInfo;
                continue;
            }
            if (before == null) {
                chapterInfo = new WordChapterInfo();
                chapterInfo.setTitleName("virtual_chapter");
                chapterInfo.addParagraph(elementInfo);
                chapterInfo.setLevel(null);
                chapterList.add(chapterInfo);
                continue;
            }
            before.addParagraph(elementInfo);
        }
        return chapterList;
    }

    private boolean isChapter(String chapterNo, WordParagraphInfo paragraphInfo, WordChapterInfo before) {
        boolean chapterFlag;
        int bIndex;
        if (StringUtils.isEmpty((CharSequence)chapterNo)) {
            return false;
        }
        String text = paragraphInfo.getText();
        Matcher matcher = CAESURA_NOISE_PATTERN.matcher(text);
        if (matcher.find()) {
            return false;
        }
        matcher = MONTH_NOISE_PATTERN.matcher(text);
        if (matcher.find()) {
            return false;
        }
        String[] currentChapterNoArr = chapterNo.split("\\.");
        int level = currentChapterNoArr.length;
        if (text.length() > 15) {
            return false;
        }
        if (before == null) {
            return true;
        }
        String titleName = before.getTitleName();
        Matcher beforeMatch = CHAPTER_PATTERN.matcher(titleName);
        String beforeChapterNo = "";
        if (beforeMatch.find()) {
            beforeChapterNo = beforeMatch.group();
        }
        String[] beforeChapterNoArr = beforeChapterNo.split("\\.");
        int cIndex = 0;
        int cLen = level;
        int bLen = beforeChapterNoArr.length;
        for (bIndex = 0; cIndex < cLen && bIndex < bLen; ++cIndex, ++bIndex) {
            try {
                String currentFirst = currentChapterNoArr[cIndex];
                String beforeFirst = beforeChapterNoArr[bIndex];
                int cInt = Integer.parseInt(currentFirst);
                int bInt = Integer.parseInt(beforeFirst);
                if (cInt == bInt || cInt - bInt == 1) continue;
                return false;
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
        boolean bl = chapterFlag = cIndex == level || bIndex == beforeChapterNoArr.length;
        if (chapterFlag) {
            if (chapterNo.endsWith(".")) {
                chapterNo = chapterNo.substring(0, chapterNo.length() - 1);
                if (this.isSpot == null) {
                    return true;
                }
                if (!this.isSpot.booleanValue()) {
                    return false;
                }
            }
            if (this.chapterNoSet.contains(chapterNo)) {
                return false;
            }
            this.chapterNoSet.add(chapterNo);
            if (this.isSpot == null) {
                this.isSpot = chapterNo.endsWith(".");
            }
            return true;
        }
        return false;
    }

    private List<WordChapterInfo> assembleChapterByCatalog(List<WordElementInfo> elementInfos) {
        WordChapterInfo before = null;
        ArrayList<WordChapterInfo> chapterList = new ArrayList<WordChapterInfo>();
        for (WordElementInfo elementInfo : elementInfos) {
            WordChapterInfo chapterInfo;
            int level = elementInfo.getLevel();
            if (level == 0 || level == 10) {
                if (before == null) {
                    chapterInfo = new WordChapterInfo();
                    chapterInfo.setTitleName("virtual_chapter");
                    chapterInfo.addParagraph(elementInfo);
                    chapterInfo.setLevel(null);
                    chapterList.add(chapterInfo);
                    continue;
                }
                before.addParagraph(elementInfo);
                elementInfo.setBelongChapter(before.getTitleName());
                continue;
            }
            chapterInfo = new WordChapterInfo();
            WordParagraphInfo paragraphInfo = (WordParagraphInfo)elementInfo;
            chapterInfo.setTitleName(paragraphInfo.getText());
            chapterInfo.setLevel(Integer.valueOf(paragraphInfo.getLevel()));
            WordChapterInfo parent = this.getParent(before, level);
            if (parent == null) {
                chapterList.add(chapterInfo);
            } else {
                parent.addChildChapter(chapterInfo);
                chapterInfo.setParent(parent);
            }
            before = chapterInfo;
        }
        return chapterList;
    }

    private List<WordChapterInfo> assembleChapterByBookMark(List<WordElementInfo> elementInfos) {
        WordChapterInfo before = null;
        ArrayList<WordChapterInfo> chapterList = new ArrayList<WordChapterInfo>();
        for (WordElementInfo elementInfo : elementInfos) {
            WordChapterInfo chapterInfo;
            if (elementInfo instanceof WordTableInfo) {
                if (before == null) {
                    WordChapterInfo chapterInfo2 = new WordChapterInfo();
                    chapterInfo2.setTitleName("virtual_chapter");
                    chapterInfo2.addParagraph(elementInfo);
                    chapterInfo2.setLevel(null);
                    chapterList.add(chapterInfo2);
                    continue;
                }
                elementInfo.setBelongChapter(before.getTitleName());
                before.addParagraph(elementInfo);
                continue;
            }
            WordParagraphInfo paragraphInfo = (WordParagraphInfo)elementInfo;
            String text = paragraphInfo.getText();
            PDFChapter chapter = this.chapterCollection.get(text.replaceAll(" ", "").trim());
            if (chapter != null) {
                chapterInfo = new WordChapterInfo();
                chapterInfo.setTitleName(paragraphInfo.getText());
                chapter.setChapterInfo(chapterInfo);
                PDFChapter parent = chapter.getParent();
                if (parent != null && parent.getChapterInfo() != null) {
                    WordChapterInfo parentChapterInfo = parent.getChapterInfo();
                    parentChapterInfo.addChildChapter(chapterInfo);
                } else {
                    chapterList.add(chapterInfo);
                }
                before = chapterInfo;
                continue;
            }
            if (before == null) {
                chapterInfo = new WordChapterInfo();
                chapterInfo.setTitleName("virtual_chapter");
                chapterInfo.addParagraph(elementInfo);
                chapterInfo.setLevel(null);
                chapterList.add(chapterInfo);
                continue;
            }
            elementInfo.setBelongChapter(before.getTitleName());
            before.addParagraph(elementInfo);
        }
        return chapterList;
    }

    private WordChapterInfo getParent(WordChapterInfo before, int level) {
        if (before == null) {
            return null;
        }
        Integer beforeLevel = before.getLevel();
        WordChapterInfo parent = null;
        int minDistance = Integer.MAX_VALUE;
        if (beforeLevel < level) {
            return before;
        }
        if (beforeLevel == level) {
            return before.getParent();
        }
        for (WordChapterInfo cursor = before.getParent(); cursor != null; cursor = cursor.getParent()) {
            int distance = level - cursor.getLevel();
            if (distance <= 0 || minDistance <= distance) continue;
            parent = cursor;
            minDistance = distance;
        }
        return parent;
    }

    private class PDFChapter {
        private String chapterStr;
        private PDFChapter parent;
        private int level = 0;
        private WordChapterInfo chapterInfo;

        public PDFChapter(String chapterStr, PDFChapter parent, int level) {
            this.chapterStr = chapterStr;
            this.parent = parent;
            this.level = level;
        }

        public String getChapterStr() {
            return this.chapterStr;
        }

        public PDFChapter getParent() {
            return this.parent;
        }

        public int getLevel() {
            return this.level;
        }

        public WordChapterInfo getChapterInfo() {
            return this.chapterInfo;
        }

        public void setChapterStr(String chapterStr) {
            this.chapterStr = chapterStr;
        }

        public void setParent(PDFChapter parent) {
            this.parent = parent;
        }

        public void setLevel(int level) {
            this.level = level;
        }

        public void setChapterInfo(WordChapterInfo chapterInfo) {
            this.chapterInfo = chapterInfo;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PDFChapter)) {
                return false;
            }
            PDFChapter other = (PDFChapter)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getLevel() != other.getLevel()) {
                return false;
            }
            String this$chapterStr = this.getChapterStr();
            String other$chapterStr = other.getChapterStr();
            if (this$chapterStr == null ? other$chapterStr != null : !this$chapterStr.equals(other$chapterStr)) {
                return false;
            }
            PDFChapter this$parent = this.getParent();
            PDFChapter other$parent = other.getParent();
            if (this$parent == null ? other$parent != null : !((Object)this$parent).equals(other$parent)) {
                return false;
            }
            WordChapterInfo this$chapterInfo = this.getChapterInfo();
            WordChapterInfo other$chapterInfo = other.getChapterInfo();
            return !(this$chapterInfo == null ? other$chapterInfo != null : !this$chapterInfo.equals(other$chapterInfo));
        }

        protected boolean canEqual(Object other) {
            return other instanceof PDFChapter;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getLevel();
            String $chapterStr = this.getChapterStr();
            result = result * 59 + ($chapterStr == null ? 43 : $chapterStr.hashCode());
            PDFChapter $parent = this.getParent();
            result = result * 59 + ($parent == null ? 43 : ((Object)$parent).hashCode());
            WordChapterInfo $chapterInfo = this.getChapterInfo();
            result = result * 59 + ($chapterInfo == null ? 43 : $chapterInfo.hashCode());
            return result;
        }

        public String toString() {
            return "PdfDocumentHandler.PDFChapter(chapterStr=" + this.getChapterStr() + ", parent=" + this.getParent() + ", level=" + this.getLevel() + ", chapterInfo=" + this.getChapterInfo() + ")";
        }

        public PDFChapter() {
        }

        public PDFChapter(String chapterStr, PDFChapter parent, int level, WordChapterInfo chapterInfo) {
            this.chapterStr = chapterStr;
            this.parent = parent;
            this.level = level;
            this.chapterInfo = chapterInfo;
        }
    }
}

