/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.icpac.core.view.impl;

import com.jxdinfo.idp.icpac.core.utils.FilenameUtils;
import com.jxdinfo.idp.icpac.core.utils.TextToWord;
import com.jxdinfo.idp.icpac.core.view.HighlightLocation;
import com.jxdinfo.idp.icpac.core.view.impl.WordViewHandler;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Objects;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.multipart.MultipartFile;

public class TextViewHandler
extends WordViewHandler {
    @Override
    public boolean support(MultipartFile file) {
        if (file == null) {
            return false;
        }
        String filename = file.getOriginalFilename();
        String fileSuffix = FilenameUtils.getFileSuffix(filename);
        return Objects.equals("txt", fileSuffix);
    }

    @Override
    public void handleView(HttpServletResponse response, List<? extends HighlightLocation> locationList, MultipartFile file, String filePath, String pdfPath) throws Exception {
        file = TextToWord.strToWord(new String(file.getBytes(), StandardCharsets.UTF_8));
        super.handleView(response, locationList, file, filePath, pdfPath);
    }

    @Override
    public byte[] handleView(List<? extends HighlightLocation> locationList, MultipartFile file) throws Exception {
        file = TextToWord.strToWord(new String(file.getBytes(), StandardCharsets.UTF_8));
        return super.handleView(locationList, file);
    }
}

