/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.icpac.core.storage;

import com.jxdinfo.idp.common.util.SnowFlakeUtil;
import com.jxdinfo.idp.icpac.core.enmus.DuplicateCheckModelEnum;
import com.jxdinfo.idp.icpac.core.enmus.DuplicateCheckUpdateModelEnum;
import com.jxdinfo.idp.icpac.core.entity.DuplicateCheckChapterConfig;
import com.jxdinfo.idp.icpac.core.entity.DuplicateCheckGroupSimilarityResult;
import com.jxdinfo.idp.icpac.core.handler.DuplicateCheckCandidateElementPostProcessor;
import com.jxdinfo.idp.icpac.core.handler.DuplicateCheckResultHandler;
import com.jxdinfo.idp.icpac.core.handler.highrisk.DuplicateCheckHighRiskDetector;
import com.jxdinfo.idp.icpac.core.handler.resultfilter.DuplicateCheckResultFilter;
import com.jxdinfo.idp.icpac.core.handler.sentencehandler.DuplicateCheckCandidateElementExtractor;
import com.jxdinfo.idp.icpac.core.storage.DuplicateCheckCandidateDocument;
import com.jxdinfo.idp.icpac.core.storage.DuplicateCheckContext;
import com.jxdinfo.idp.icpac.core.storage.DuplicateCheckParamConfiguration;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class DuplicateCheckCandidateGroup {
    private String groupId;
    private String groupName;
    private DuplicateCheckParamConfiguration paramConfiguration;
    private List<DuplicateCheckCandidateDocument> candidateDocumentList = new ArrayList<DuplicateCheckCandidateDocument>();
    private Map<String, Map<String, Double>> groupSimilarityMap = new HashMap<String, Map<String, Double>>();
    private DuplicateCheckContext context;
    private List<String> excludeDocumentIdList = new ArrayList<String>();
    private List<String> chooseDocumentIdList = new ArrayList<String>();
    private Boolean textSegmentation;

    public void addSentenceSimilarity(String similarityGroupId, String sentenceId, Double similarity) {
        Map sentenceWithSimilarity = this.groupSimilarityMap.computeIfAbsent(similarityGroupId, k -> new HashMap());
        Double oldSimilarity = (Double)sentenceWithSimilarity.get(sentenceId);
        if (oldSimilarity == null || oldSimilarity < similarity) {
            sentenceWithSimilarity.put(sentenceId, similarity);
        }
    }

    public List<DuplicateCheckGroupSimilarityResult> getGroupResult() {
        ArrayList<DuplicateCheckGroupSimilarityResult> groupResultList = new ArrayList<DuplicateCheckGroupSimilarityResult>();
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isEmpty(this.groupSimilarityMap)) {
            return Collections.emptyList();
        }
        int groupCandidateSentenceNum = 0;
        for (DuplicateCheckCandidateDocument duplicateCheckCandidateDocument : this.candidateDocumentList) {
            groupCandidateSentenceNum += duplicateCheckCandidateDocument.getCandidateSentenceNum();
        }
        if (groupCandidateSentenceNum == 0) {
            return Collections.emptyList();
        }
        for (Map.Entry entry : this.groupSimilarityMap.entrySet()) {
            BigDecimal groupSimilaritySum = BigDecimal.ZERO;
            for (Map.Entry sentenceSimilarity : ((Map)entry.getValue()).entrySet()) {
                groupSimilaritySum = groupSimilaritySum.add(BigDecimal.valueOf((Double)sentenceSimilarity.getValue()));
            }
            double finalGroupSimilarity = groupSimilaritySum.divide(BigDecimal.valueOf(groupCandidateSentenceNum), 2, RoundingMode.HALF_UP).doubleValue();
            if (Double.compare(finalGroupSimilarity, 0.0) == 0) {
                finalGroupSimilarity = 0.01;
            }
            groupResultList.add(new DuplicateCheckGroupSimilarityResult(String.valueOf(SnowFlakeUtil.getFlowIdInstance().nextId()), this.groupId, (String)entry.getKey(), this.getLibId(), finalGroupSimilarity));
        }
        return groupResultList;
    }

    private String getLibId() {
        return this.getContext().getLibId();
    }

    public void addAllCandidateDocument(List<DuplicateCheckCandidateDocument> candidateDocumentList) {
        for (DuplicateCheckCandidateDocument candidateDocument : candidateDocumentList) {
            this.addCandidateDocument(candidateDocument);
        }
    }

    public void setContext(DuplicateCheckContext checkContext) {
        this.context = checkContext;
    }

    public DuplicateCheckModelEnum getCheckModel() {
        return this.context.getCheckModel();
    }

    public boolean isDuplicateImageFlag() {
        Boolean duplicateImageFlag;
        if (this.paramConfiguration != null && (duplicateImageFlag = this.paramConfiguration.getDuplicateImageFlag()) != null) {
            return duplicateImageFlag;
        }
        return this.context.isDuplicateImageFlag();
    }

    public Double getSimThresh() {
        Double simThresh;
        if (this.paramConfiguration != null && (simThresh = this.paramConfiguration.getSimThresh()) != null) {
            return simThresh;
        }
        return this.context.getSimThresh();
    }

    public DuplicateCheckUpdateModelEnum getUpdateModel() {
        DuplicateCheckUpdateModelEnum updateModel;
        if (this.paramConfiguration != null && (updateModel = this.paramConfiguration.getUpdateModel()) != null) {
            return updateModel;
        }
        return this.context.getUpdateModel();
    }

    public DuplicateCheckCandidateElementExtractor getCandidateElementExtractor() {
        DuplicateCheckCandidateElementExtractor candidateElementExtractor;
        if (this.paramConfiguration != null && (candidateElementExtractor = this.paramConfiguration.getCandidateElementExtractor()) != null) {
            return candidateElementExtractor;
        }
        return this.context.getCandidateElementExtractor();
    }

    public DuplicateCheckResultHandler getResultHandler() {
        DuplicateCheckResultHandler resultHandler;
        if (this.paramConfiguration != null && (resultHandler = this.paramConfiguration.getResultHandler()) != null) {
            return resultHandler;
        }
        return this.context.getResultHandler();
    }

    public List<DuplicateCheckCandidateElementPostProcessor> getCandidateElementPostProcessorList() {
        List<DuplicateCheckCandidateElementPostProcessor> csFilter;
        if (this.paramConfiguration != null && com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(csFilter = this.paramConfiguration.getCandidateElementPostProcessorList())) {
            return csFilter;
        }
        return this.context.getCandidateElementPostProcessorList();
    }

    public void addCandidateDocument(DuplicateCheckCandidateDocument candidateDocument) {
        candidateDocument.setCandidateGroup(this);
        this.candidateDocumentList.add(candidateDocument);
    }

    public List<DuplicateCheckResultFilter> getCheckResultFilter() {
        List<DuplicateCheckResultFilter> checkResultFilterList;
        if (this.paramConfiguration != null && CollectionUtils.isNotEmpty(checkResultFilterList = this.paramConfiguration.getCheckResultFilterList())) {
            return checkResultFilterList;
        }
        return this.context.getCheckResultFilter();
    }

    public List<DuplicateCheckHighRiskDetector> getHighRiskDetectorList() {
        List<DuplicateCheckHighRiskDetector> riskDetectorList;
        if (this.paramConfiguration != null && com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(riskDetectorList = this.paramConfiguration.getHighRiskDetectorList())) {
            return riskDetectorList;
        }
        return this.context.getHighRiskDetectorList();
    }

    public List<String> getTemplateTextList() {
        List<String> templateTextList;
        if (this.paramConfiguration != null && com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(templateTextList = this.paramConfiguration.getTemplateTextList())) {
            return templateTextList;
        }
        return this.context.getTemplateTextList();
    }

    public int getMinTextLength() {
        Integer minTextLength;
        if (this.paramConfiguration != null && (minTextLength = this.paramConfiguration.getMinTextLength()) != null) {
            return minTextLength;
        }
        return this.context.getMinTextLength();
    }

    public int getMinTableLength() {
        Integer minTableLength;
        if (this.paramConfiguration != null && (minTableLength = this.paramConfiguration.getMinTableLength()) != null) {
            return minTableLength;
        }
        return this.context.getMinTableLength();
    }

    public List<DuplicateCheckChapterConfig> getChapterConfig() {
        List<DuplicateCheckChapterConfig> chapterConfigList;
        if (this.paramConfiguration != null && (chapterConfigList = this.paramConfiguration.getChapterConfigList()) != null) {
            return chapterConfigList;
        }
        return this.context.getChapterConfig();
    }

    public Boolean isTextSegmentation() {
        Boolean textSegmentation;
        if (this.paramConfiguration != null && (textSegmentation = this.paramConfiguration.getTextSegmentation()) != null) {
            return textSegmentation;
        }
        return this.context.isTextSegmentation();
    }

    public String getChapterMatchType() {
        String chapterMatchType;
        if (this.paramConfiguration != null && StringUtils.isNotEmpty((CharSequence)(chapterMatchType = this.paramConfiguration.getChapterMatchType()))) {
            return chapterMatchType;
        }
        return this.context.getChapterMatchType();
    }

    public boolean isParamConfigurationNull() {
        if (this.paramConfiguration != null) {
            return false;
        }
        for (DuplicateCheckCandidateDocument candidateDocument : this.candidateDocumentList) {
            boolean result = candidateDocument.isParamConfigurationNull();
            if (!result) continue;
            return true;
        }
        return false;
    }

    public String getTemplateProjectId() {
        String templateProjectId;
        if (this.paramConfiguration != null && StringUtils.isNotEmpty((CharSequence)(templateProjectId = this.paramConfiguration.getTemplateLibId()))) {
            return templateProjectId;
        }
        return this.getContext().getTemplateProjectId();
    }

    public void addAllChooseDocumentId(List<String> chooseDocumentIdList) {
        this.chooseDocumentIdList.addAll(chooseDocumentIdList);
    }

    public void addChooseDocumentId(String chooseDocumentId) {
        this.chooseDocumentIdList.add(chooseDocumentId);
    }

    public void addExcludeDocumentId(String excludeDocumentId) {
        this.excludeDocumentIdList.add(excludeDocumentId);
    }

    public void addAllExcludeDocumentId(List<String> excludeDocumentId) {
        this.excludeDocumentIdList.addAll(excludeDocumentId);
    }

    public List<String> getExcludeLibList() {
        List<String> excludeRegList;
        if (this.paramConfiguration != null && com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(excludeRegList = this.paramConfiguration.getExcludeRegList())) {
            return excludeRegList;
        }
        return this.context.getExcludeLibList();
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public DuplicateCheckParamConfiguration getParamConfiguration() {
        return this.paramConfiguration;
    }

    public List<DuplicateCheckCandidateDocument> getCandidateDocumentList() {
        return this.candidateDocumentList;
    }

    public Map<String, Map<String, Double>> getGroupSimilarityMap() {
        return this.groupSimilarityMap;
    }

    public DuplicateCheckContext getContext() {
        return this.context;
    }

    public List<String> getExcludeDocumentIdList() {
        return this.excludeDocumentIdList;
    }

    public List<String> getChooseDocumentIdList() {
        return this.chooseDocumentIdList;
    }

    public Boolean getTextSegmentation() {
        return this.textSegmentation;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public void setGroupName(String groupName) {
        this.groupName = groupName;
    }

    public void setParamConfiguration(DuplicateCheckParamConfiguration paramConfiguration) {
        this.paramConfiguration = paramConfiguration;
    }

    public void setCandidateDocumentList(List<DuplicateCheckCandidateDocument> candidateDocumentList) {
        this.candidateDocumentList = candidateDocumentList;
    }

    public void setGroupSimilarityMap(Map<String, Map<String, Double>> groupSimilarityMap) {
        this.groupSimilarityMap = groupSimilarityMap;
    }

    public void setExcludeDocumentIdList(List<String> excludeDocumentIdList) {
        this.excludeDocumentIdList = excludeDocumentIdList;
    }

    public void setChooseDocumentIdList(List<String> chooseDocumentIdList) {
        this.chooseDocumentIdList = chooseDocumentIdList;
    }

    public void setTextSegmentation(Boolean textSegmentation) {
        this.textSegmentation = textSegmentation;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DuplicateCheckCandidateGroup)) {
            return false;
        }
        DuplicateCheckCandidateGroup other = (DuplicateCheckCandidateGroup)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$textSegmentation = this.getTextSegmentation();
        Boolean other$textSegmentation = other.getTextSegmentation();
        if (this$textSegmentation == null ? other$textSegmentation != null : !((Object)this$textSegmentation).equals(other$textSegmentation)) {
            return false;
        }
        String this$groupId = this.getGroupId();
        String other$groupId = other.getGroupId();
        if (this$groupId == null ? other$groupId != null : !this$groupId.equals(other$groupId)) {
            return false;
        }
        String this$groupName = this.getGroupName();
        String other$groupName = other.getGroupName();
        if (this$groupName == null ? other$groupName != null : !this$groupName.equals(other$groupName)) {
            return false;
        }
        DuplicateCheckParamConfiguration this$paramConfiguration = this.getParamConfiguration();
        DuplicateCheckParamConfiguration other$paramConfiguration = other.getParamConfiguration();
        if (this$paramConfiguration == null ? other$paramConfiguration != null : !((Object)this$paramConfiguration).equals(other$paramConfiguration)) {
            return false;
        }
        List<DuplicateCheckCandidateDocument> this$candidateDocumentList = this.getCandidateDocumentList();
        List<DuplicateCheckCandidateDocument> other$candidateDocumentList = other.getCandidateDocumentList();
        if (this$candidateDocumentList == null ? other$candidateDocumentList != null : !((Object)this$candidateDocumentList).equals(other$candidateDocumentList)) {
            return false;
        }
        Map<String, Map<String, Double>> this$groupSimilarityMap = this.getGroupSimilarityMap();
        Map<String, Map<String, Double>> other$groupSimilarityMap = other.getGroupSimilarityMap();
        if (this$groupSimilarityMap == null ? other$groupSimilarityMap != null : !((Object)this$groupSimilarityMap).equals(other$groupSimilarityMap)) {
            return false;
        }
        DuplicateCheckContext this$context = this.getContext();
        DuplicateCheckContext other$context = other.getContext();
        if (this$context == null ? other$context != null : !((Object)this$context).equals(other$context)) {
            return false;
        }
        List<String> this$excludeDocumentIdList = this.getExcludeDocumentIdList();
        List<String> other$excludeDocumentIdList = other.getExcludeDocumentIdList();
        if (this$excludeDocumentIdList == null ? other$excludeDocumentIdList != null : !((Object)this$excludeDocumentIdList).equals(other$excludeDocumentIdList)) {
            return false;
        }
        List<String> this$chooseDocumentIdList = this.getChooseDocumentIdList();
        List<String> other$chooseDocumentIdList = other.getChooseDocumentIdList();
        return !(this$chooseDocumentIdList == null ? other$chooseDocumentIdList != null : !((Object)this$chooseDocumentIdList).equals(other$chooseDocumentIdList));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DuplicateCheckCandidateGroup;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $textSegmentation = this.getTextSegmentation();
        result = result * 59 + ($textSegmentation == null ? 43 : ((Object)$textSegmentation).hashCode());
        String $groupId = this.getGroupId();
        result = result * 59 + ($groupId == null ? 43 : $groupId.hashCode());
        String $groupName = this.getGroupName();
        result = result * 59 + ($groupName == null ? 43 : $groupName.hashCode());
        DuplicateCheckParamConfiguration $paramConfiguration = this.getParamConfiguration();
        result = result * 59 + ($paramConfiguration == null ? 43 : ((Object)$paramConfiguration).hashCode());
        List<DuplicateCheckCandidateDocument> $candidateDocumentList = this.getCandidateDocumentList();
        result = result * 59 + ($candidateDocumentList == null ? 43 : ((Object)$candidateDocumentList).hashCode());
        Map<String, Map<String, Double>> $groupSimilarityMap = this.getGroupSimilarityMap();
        result = result * 59 + ($groupSimilarityMap == null ? 43 : ((Object)$groupSimilarityMap).hashCode());
        DuplicateCheckContext $context = this.getContext();
        result = result * 59 + ($context == null ? 43 : ((Object)$context).hashCode());
        List<String> $excludeDocumentIdList = this.getExcludeDocumentIdList();
        result = result * 59 + ($excludeDocumentIdList == null ? 43 : ((Object)$excludeDocumentIdList).hashCode());
        List<String> $chooseDocumentIdList = this.getChooseDocumentIdList();
        result = result * 59 + ($chooseDocumentIdList == null ? 43 : ((Object)$chooseDocumentIdList).hashCode());
        return result;
    }

    public String toString() {
        return "DuplicateCheckCandidateGroup(groupId=" + this.getGroupId() + ", groupName=" + this.getGroupName() + ", paramConfiguration=" + this.getParamConfiguration() + ", candidateDocumentList=" + this.getCandidateDocumentList() + ", groupSimilarityMap=" + this.getGroupSimilarityMap() + ", context=" + this.getContext() + ", excludeDocumentIdList=" + this.getExcludeDocumentIdList() + ", chooseDocumentIdList=" + this.getChooseDocumentIdList() + ", textSegmentation=" + this.getTextSegmentation() + ")";
    }
}

