/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.duplicatecheck.api.entity.dto;

import cn.hutool.core.util.ObjectUtil;
import com.jxdinfo.idp.duplicatecheck.api.entity.dto.GroupDuplicateDocResponseDto;
import com.jxdinfo.idp.duplicatecheck.api.entity.dto.GroupDuplicateRequestDto;
import com.jxdinfo.idp.duplicatecheck.api.entity.dto.SimilarGroupListDto;
import com.jxdinfo.idp.duplicatecheck.api.entity.dto.SimilarTextDto;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class GroupDuplicateCheckResponseDto {
    private String groupId;
    private Double maxSimilarity = 0.0;
    private List<SimilarGroupListDto> similarGroupList = new ArrayList<SimilarGroupListDto>();
    private Map<String, SimilarGroupListDto> similarGroupMap = new HashMap<String, SimilarGroupListDto>();
    private List<SimilarTextDto> similarSentenceList;
    private Map<String, GroupDuplicateDocResponseDto> docMap;

    public GroupDuplicateCheckResponseDto(String groupId) {
        this.groupId = groupId;
        this.similarGroupMap = new HashMap<String, SimilarGroupListDto>();
        this.similarSentenceList = new ArrayList<SimilarTextDto>();
        this.docMap = new HashMap<String, GroupDuplicateDocResponseDto>();
    }

    public static Map<String, GroupDuplicateCheckResponseDto> initList(GroupDuplicateRequestDto requestDto) {
        if (ObjectUtil.isNotNull(requestDto.getGroupQueryDtoList())) {
            return requestDto.getGroupQueryDtoList().stream().collect(HashMap::new, (m, v) -> m.put(v.getGroupId(), new GroupDuplicateCheckResponseDto(v.getGroupId())), HashMap::putAll);
        }
        return new HashMap<String, GroupDuplicateCheckResponseDto>();
    }

    public void setMaxSimilarity(Double maxSimilarity) {
        this.maxSimilarity = maxSimilarity;
    }

    public void setSimilarGroupMap(Map<String, SimilarGroupListDto> similarGroupMap) {
    }

    public void setSimilarGroupList(List<SimilarGroupListDto> similarGroupList) {
        this.similarGroupList = similarGroupList;
    }

    public void addSimilarityByGroup(String similarityGroupId, BigDecimal similarity, int size) {
        BigDecimal similarityBig = similarity.divide(BigDecimal.valueOf(size), 6, RoundingMode.HALF_UP);
        double finalSimilarity = similarityBig.doubleValue();
        SimilarGroupListDto similarGroupListDto = new SimilarGroupListDto();
        similarGroupListDto.setGroupId(similarityGroupId);
        similarGroupListDto.setSimilarityDouble(finalSimilarity);
        this.similarGroupMap.put(similarityGroupId, similarGroupListDto);
        if (this.maxSimilarity < finalSimilarity) {
            this.maxSimilarity = finalSimilarity;
        }
        this.similarGroupList.add(similarGroupListDto);
    }

    public String getGroupId() {
        return this.groupId;
    }

    public Double getMaxSimilarity() {
        return this.maxSimilarity;
    }

    public List<SimilarGroupListDto> getSimilarGroupList() {
        return this.similarGroupList;
    }

    public Map<String, SimilarGroupListDto> getSimilarGroupMap() {
        return this.similarGroupMap;
    }

    public List<SimilarTextDto> getSimilarSentenceList() {
        return this.similarSentenceList;
    }

    public Map<String, GroupDuplicateDocResponseDto> getDocMap() {
        return this.docMap;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public void setSimilarSentenceList(List<SimilarTextDto> similarSentenceList) {
        this.similarSentenceList = similarSentenceList;
    }

    public void setDocMap(Map<String, GroupDuplicateDocResponseDto> docMap) {
        this.docMap = docMap;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GroupDuplicateCheckResponseDto)) {
            return false;
        }
        GroupDuplicateCheckResponseDto other = (GroupDuplicateCheckResponseDto)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Double this$maxSimilarity = this.getMaxSimilarity();
        Double other$maxSimilarity = other.getMaxSimilarity();
        if (this$maxSimilarity == null ? other$maxSimilarity != null : !((Object)this$maxSimilarity).equals(other$maxSimilarity)) {
            return false;
        }
        String this$groupId = this.getGroupId();
        String other$groupId = other.getGroupId();
        if (this$groupId == null ? other$groupId != null : !this$groupId.equals(other$groupId)) {
            return false;
        }
        List<SimilarGroupListDto> this$similarGroupList = this.getSimilarGroupList();
        List<SimilarGroupListDto> other$similarGroupList = other.getSimilarGroupList();
        if (this$similarGroupList == null ? other$similarGroupList != null : !((Object)this$similarGroupList).equals(other$similarGroupList)) {
            return false;
        }
        Map<String, SimilarGroupListDto> this$similarGroupMap = this.getSimilarGroupMap();
        Map<String, SimilarGroupListDto> other$similarGroupMap = other.getSimilarGroupMap();
        if (this$similarGroupMap == null ? other$similarGroupMap != null : !((Object)this$similarGroupMap).equals(other$similarGroupMap)) {
            return false;
        }
        List<SimilarTextDto> this$similarSentenceList = this.getSimilarSentenceList();
        List<SimilarTextDto> other$similarSentenceList = other.getSimilarSentenceList();
        if (this$similarSentenceList == null ? other$similarSentenceList != null : !((Object)this$similarSentenceList).equals(other$similarSentenceList)) {
            return false;
        }
        Map<String, GroupDuplicateDocResponseDto> this$docMap = this.getDocMap();
        Map<String, GroupDuplicateDocResponseDto> other$docMap = other.getDocMap();
        return !(this$docMap == null ? other$docMap != null : !((Object)this$docMap).equals(other$docMap));
    }

    protected boolean canEqual(Object other) {
        return other instanceof GroupDuplicateCheckResponseDto;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Double $maxSimilarity = this.getMaxSimilarity();
        result = result * 59 + ($maxSimilarity == null ? 43 : ((Object)$maxSimilarity).hashCode());
        String $groupId = this.getGroupId();
        result = result * 59 + ($groupId == null ? 43 : $groupId.hashCode());
        List<SimilarGroupListDto> $similarGroupList = this.getSimilarGroupList();
        result = result * 59 + ($similarGroupList == null ? 43 : ((Object)$similarGroupList).hashCode());
        Map<String, SimilarGroupListDto> $similarGroupMap = this.getSimilarGroupMap();
        result = result * 59 + ($similarGroupMap == null ? 43 : ((Object)$similarGroupMap).hashCode());
        List<SimilarTextDto> $similarSentenceList = this.getSimilarSentenceList();
        result = result * 59 + ($similarSentenceList == null ? 43 : ((Object)$similarSentenceList).hashCode());
        Map<String, GroupDuplicateDocResponseDto> $docMap = this.getDocMap();
        result = result * 59 + ($docMap == null ? 43 : ((Object)$docMap).hashCode());
        return result;
    }

    public String toString() {
        return "GroupDuplicateCheckResponseDto(groupId=" + this.getGroupId() + ", maxSimilarity=" + this.getMaxSimilarity() + ", similarGroupList=" + this.getSimilarGroupList() + ", similarGroupMap=" + this.getSimilarGroupMap() + ", similarSentenceList=" + this.getSimilarSentenceList() + ", docMap=" + this.getDocMap() + ")";
    }

    public GroupDuplicateCheckResponseDto(String groupId, Double maxSimilarity, List<SimilarGroupListDto> similarGroupList, Map<String, SimilarGroupListDto> similarGroupMap, List<SimilarTextDto> similarSentenceList, Map<String, GroupDuplicateDocResponseDto> docMap) {
        this.groupId = groupId;
        this.maxSimilarity = maxSimilarity;
        this.similarGroupList = similarGroupList;
        this.similarGroupMap = similarGroupMap;
        this.similarSentenceList = similarSentenceList;
        this.docMap = docMap;
    }

    public GroupDuplicateCheckResponseDto() {
    }
}

