/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.dm.server.docmgmt.controller;

import com.jxdinfo.idp.common.response.ApiResponse;
import com.jxdinfo.idp.dm.server.controller.UniverController;
import com.jxdinfo.idp.dm.server.docmgmt.controller.NodeRelevancyController;
import com.jxdinfo.idp.dto.QueryDocInfoDto;
import com.jxdinfo.idp.interf.DocInfoService;
import com.jxdinfo.idp.vo.DocInfoVo;
import com.jxdinfo.idp.vo.DocTemplateVo;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/fileInfo"})
public class FileController {
    private static final Logger log = LoggerFactory.getLogger(FileController.class);
    @Resource
    private DocInfoService docInfoService;

    @RequestMapping(value={"/getFileStream"})
    public ApiResponse<Map<String, Object>> getFileStream(@RequestParam String docId) {
        return ApiResponse.success((Object)this.docInfoService.getFileStream(docId));
    }

    @GetMapping(value={"/getDocInfo"})
    public ApiResponse<DocInfoVo> getDocInfo(@RequestParam(value="docId") String docId) {
        return ApiResponse.success((Object)this.docInfoService.getDocInfo(docId));
    }

    @PostMapping(value={"/getFileHtml"})
    public ApiResponse<Map<String, Object>> getFileHtml(@RequestParam(value="docId") String docId) {
        try {
            return ApiResponse.success((Object)this.docInfoService.getFileHtml(docId));
        }
        catch (Exception a) {
            return ApiResponse.fail((String)new StringBuilder().insert(0, NodeRelevancyController.throws("\u5c2b\u001fB\u001aI\u8f04\u634f\u4e52E\u001c@\u0004\u591c\u8d4d\uff37")).append(a.getMessage()).toString());
        }
    }

    @PostMapping(value={"/queryFileInfo"})
    public ApiResponse<Map<String, Object>> queryFileInfo(@RequestBody QueryDocInfoDto queryDocInfoDto) {
        return ApiResponse.success((Object)this.docInfoService.queryFileInfo(queryDocInfoDto));
    }

    @RequestMapping(value={"/updateFileInfo"})
    public ApiResponse<Boolean> updateFileInfo(@RequestBody List<Map<String, String>> list) {
        return ApiResponse.success((Object)this.docInfoService.updateFileInfo(list));
    }

    @GetMapping(value={"/getDocInfoWithMapper"})
    public ApiResponse<DocInfoVo> getDocInfoWithMapper(@RequestParam(value="docId") String docId) {
        return ApiResponse.success((Object)this.docInfoService.getDocInfoWithMapper(docId));
    }

    @RequestMapping(value={"/deleteFileForce"})
    public ApiResponse<Boolean> deleteFileForce(@RequestParam Long id) {
        try {
            return ApiResponse.success((Object)this.docInfoService.deleteFileForce(id));
        }
        catch (Exception a) {
            return ApiResponse.fail((String)new StringBuilder().insert(0, NodeRelevancyController.throws("\u520d\u960c\u65aa\u4e9e\u591c\u8d4d\uff37")).append(a.getMessage()).toString());
        }
    }

    /*
     * WARNING - void declaration
     */
    @RequestMapping(value={"/getDocTemplateList"})
    public ApiResponse<List<DocTemplateVo>> deleteFileInfo(@RequestParam String string, @RequestParam String string2) {
        void docName;
        void docId;
        return ApiResponse.success((Object)this.docInfoService.getDocTemplate((String)docId, (String)docName));
    }

    @RequestMapping(value={"/deleteFileInfo"})
    public ApiResponse<Object> deleteFileInfo(@RequestParam Long id) {
        try {
            Map a = this.docInfoService.deleteFileInfo(id);
            return ApiResponse.data((Object)a);
        }
        catch (Exception a) {
            return ApiResponse.fail((String)new StringBuilder().insert(0, UniverController.strictfp("\u5271\u964b\u65d6\u4ed9\u5960\u8d0a\uff4b")).append(a.getMessage()).toString());
        }
    }

    @GetMapping(value={"/getDocTotal"})
    public ApiResponse<Long> getDocTotal() {
        return ApiResponse.success((Object)this.docInfoService.getDocTotal());
    }

    @PostMapping(value={"/searchResult"})
    public ApiResponse<Map<String, Object>> searchResult(@RequestBody QueryDocInfoDto queryDocInfoDto) {
        return ApiResponse.success((Object)this.docInfoService.searchResult(queryDocInfoDto));
    }

    @PostMapping(value={"/getFileHtmlNew"})
    public void getFileHtmlNew(HttpServletResponse response, @RequestParam(value="docId") String docId) {
        try {
            this.docInfoService.getFileHtmlNew(response, docId);
            return;
        }
        catch (Exception a) {
            log.error(UniverController.strictfp("6J%i8C4g%B=a4X\u5c57X>]5\u8f43\u6333\u4e159[<C\u5960\u8d0a\uff4b"), (Throwable)a);
            return;
        }
    }

    @PostMapping(value={"/queryFileByFold"})
    public ApiResponse<Map<String, Object>> queryFileByFold(@RequestBody QueryDocInfoDto queryDocInfoDto) {
        return ApiResponse.success((Object)this.docInfoService.queryFileByFold(queryDocInfoDto));
    }

    @PostMapping(value={"/struFile"})
    public ApiResponse<Map<String, Object>> struFile(@RequestParam(value="docId") String docId) {
        try {
            return ApiResponse.success((Object)this.docInfoService.struFile(docId));
        }
        catch (Exception a) {
            return ApiResponse.fail((String)new StringBuilder().insert(0, UniverController.strictfp("\u7efc\u67d5\u5339\u65d6\u684c\u5960\u8d0a\uff4b")).append(a.getMessage()).toString());
        }
    }
}

