/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.dm.server.schedule;

import com.jxdinfo.idp.common.exception.BusinessException;
import com.jxdinfo.idp.dm.server.docmgmt.controller.NodeRelevancyController;
import com.jxdinfo.idp.dm.server.doctypes.controller.NodeTypeRelevancyController;
import com.jxdinfo.idp.dm.server.util.TimeConverterUtil;
import com.jxdinfo.idp.interf.DocExtractService;
import com.jxdinfo.idp.po.DocExtractPo;
import java.io.IOException;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Component
public class MultipleScheduledTasks {
    private static final ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(2);
    @Autowired
    private DocExtractService docExtractServices;
    @Value(value="${docbase.docextratOn}")
    private String docextratOn;
    private static DocExtractService docExtractService;

    public MultipleScheduledTasks() {
        MultipleScheduledTasks a;
    }

    public static void docExtractTaskThreadPool() {
        for (Object object : docExtractService.list()) {
            if (object.getExecutWay() != 0) continue;
            DocExtractPo docExtractPo = object;
            object = TimeConverterUtil.convertToSeconds(object.getIntervalTime(), docExtractPo.getUnit());
            Runnable runnable = () -> {
                docExtractPo.setResults(2);
                docExtractService.updateById((Object)docExtractPo);
                try {
                    docExtractService.docExtractHandle(docExtractPo);
                    docExtractPo.setResults(0);
                    return;
                }
                catch (IOException iOException) {
                    docExtractPo.setResults(1);
                    throw new BusinessException(NodeTypeRelevancyController.static("\u76a0\u5f77\u6225\u63ed\u5f4c\u5e1a\uff42\u68e2\u67ab\u65a5\u4eb8\u660d\u5468\u6b41\u5e76\u89c1\u53c5"), (Throwable)iOException);
                }
                finally {
                    docExtractPo.setCreateTime(LocalDateTime.now());
                    docExtractService.updateById((Object)docExtractPo);
                }
            };
            object = scheduler.scheduleWithFixedDelay(runnable, 1L, (Long)object, TimeUnit.SECONDS);
        }
        Runtime.getRuntime().addShutdownHook(new Thread(scheduler::shutdownNow));
    }

    public static void addDocExtractTaskThreadPool(DocExtractPo docExtractPo) {
        DocExtractPo a;
        if (a.getExecutWay() == 0) {
            DocExtractPo docExtractPo2 = a;
            Comparable<Long> comparable = TimeConverterUtil.convertToSeconds(a.getIntervalTime(), docExtractPo2.getUnit());
            Runnable runnable = () -> {
                docExtractPo2.setResults(2);
                docExtractService.updateById((Object)docExtractPo2);
                try {
                    docExtractService.docExtractHandle(docExtractPo2);
                    docExtractPo2.setResults(0);
                    return;
                }
                catch (IOException iOException) {
                    docExtractPo2.setResults(1);
                    throw new BusinessException(NodeRelevancyController.short("\u76c3\u5f3d\u6246\u63a7\u5f2f\u5e50\uff21\u68a8\u67c8\u65ef\u4edb\u6647\u540b\u6b0b\u5e15\u898b\u53a6"), (Throwable)iOException);
                }
                finally {
                    docExtractPo2.setCreateTime(LocalDateTime.now());
                    docExtractService.updateById((Object)docExtractPo2);
                }
            };
            comparable = scheduler.scheduleWithFixedDelay(runnable, 1L, (long)comparable, TimeUnit.SECONDS);
        }
    }

    public void staticInit() {
        MultipleScheduledTasks a;
        docExtractService = a.docExtractServices;
        if (NodeTypeRelevancyController.static("V<W+").equals(a.docextratOn)) {
            MultipleScheduledTasks.docExtractTaskThreadPool();
        }
    }

    public static boolean handleDocExtractTask(Long a) throws IOException {
        DocExtractPo docExtractPo = (DocExtractPo)docExtractService.getById((Serializable)a);
        docExtractPo.setResults(2);
        docExtractService.updateById((Object)docExtractPo);
        docExtractService.docExtractHandle(docExtractPo);
        docExtractPo.setResults(0);
        docExtractService.updateById((Object)docExtractPo);
        return true;
    }
}

