/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.dm.server.schedule;

import com.jxdinfo.idp.common.exception.BusinessException;
import com.jxdinfo.idp.dm.server.controller.NodeTypeRelevancyController;
import com.jxdinfo.idp.dm.server.controller.UniverController;
import com.jxdinfo.idp.dm.server.util.TimeConverterUtil;
import com.jxdinfo.idp.interf.DocExtractService;
import com.jxdinfo.idp.po.DocExtractPo;
import java.io.IOException;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Component
public class MultipleScheduledTasks {
    @Autowired
    private DocExtractService docExtractServices;
    @Value(value="${docbase.docextratOn}")
    private String docextratOn;
    private static DocExtractService docExtractService;
    private static final ScheduledExecutorService scheduler;

    @PostConstruct
    public void staticInit() {
        MultipleScheduledTasks a;
        docExtractService = a.docExtractServices;
        if (NodeTypeRelevancyController.synchronized("QlHc").equals(a.docextratOn)) {
            MultipleScheduledTasks.docExtractTaskThreadPool();
        }
    }

    public MultipleScheduledTasks() {
        MultipleScheduledTasks a;
    }

    public static void addDocExtractTaskThreadPool(DocExtractPo a) {
        if (a.getExecutWay() == 0) {
            DocExtractPo docExtractPo = a;
            Comparable<Long> comparable = TimeConverterUtil.convertToSeconds(a.getIntervalTime(), docExtractPo.getUnit());
            Runnable runnable = () -> {
                docExtractPo.setResults(2);
                docExtractService.updateById((Object)docExtractPo);
                try {
                    docExtractService.docExtractHandle(docExtractPo);
                    docExtractPo.setResults(0);
                    return;
                }
                catch (IOException iOException) {
                    docExtractPo.setResults(1);
                    throw new BusinessException(UniverController.const("\u76ec\u5f37\u6270\u63a4\u5f10\u5e52\uff1f\u689a\u67c6\u65e8\u4ee0\u6652\u5422\u6b06\u5e24\u899e\u538f"), (Throwable)iOException);
                }
                finally {
                    docExtractPo.setCreateTime(LocalDateTime.now());
                    docExtractService.updateById((Object)docExtractPo);
                }
            };
            comparable = scheduler.scheduleWithFixedDelay(runnable, 1L, (long)comparable, TimeUnit.SECONDS);
        }
    }

    public static boolean handleDocExtractTask(Long a) throws IOException {
        DocExtractPo docExtractPo = (DocExtractPo)docExtractService.getById((Serializable)a);
        docExtractPo.setResults(2);
        docExtractService.updateById((Object)docExtractPo);
        docExtractService.docExtractHandle(docExtractPo);
        docExtractPo.setResults(0);
        docExtractService.updateById((Object)docExtractPo);
        return true;
    }

    public static void docExtractTaskThreadPool() {
        for (Object object : docExtractService.list()) {
            if (object.getExecutWay() != 0) continue;
            DocExtractPo docExtractPo = object;
            object = TimeConverterUtil.convertToSeconds(object.getIntervalTime(), docExtractPo.getUnit());
            Runnable runnable = () -> {
                docExtractPo.setResults(2);
                docExtractService.updateById((Object)docExtractPo);
                try {
                    docExtractService.docExtractHandle(docExtractPo);
                    docExtractPo.setResults(0);
                    return;
                }
                catch (IOException iOException) {
                    docExtractPo.setResults(1);
                    throw new BusinessException(NodeTypeRelevancyController.synchronized("\u76ee\u5f77\u6272\u63e4\u5f12\u5e12\uff1d\u68da\u67c4\u65a8\u4ee2\u6612\u5420\u6b46\u5e26\u89de\u538d"), (Throwable)iOException);
                }
                finally {
                    docExtractPo.setCreateTime(LocalDateTime.now());
                    docExtractService.updateById((Object)docExtractPo);
                }
            };
            object = scheduler.scheduleWithFixedDelay(runnable, 1L, (Long)object, TimeUnit.SECONDS);
        }
        Runtime.getRuntime().addShutdownHook(new Thread(scheduler::shutdownNow));
    }

    static {
        scheduler = Executors.newScheduledThreadPool(2);
    }
}

