/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.dm.server.schedule;

import com.jxdinfo.idp.common.exception.BusinessException;
import com.jxdinfo.idp.dm.server.controller.UniverController;
import com.jxdinfo.idp.dm.server.util.TimeConverterUtil;
import com.jxdinfo.idp.interf.DocExtractService;
import com.jxdinfo.idp.po.DocExtractPo;
import java.io.IOException;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Component
public class MultipleScheduledTasks {
    private static final ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(2);
    @Value(value="${docbase.docextratOn}")
    private String docextratOn;
    @Autowired
    private DocExtractService docExtractServices;
    private static DocExtractService docExtractService;

    public static boolean handleDocExtractTask(Long a) throws IOException {
        DocExtractPo docExtractPo = (DocExtractPo)docExtractService.getById((Serializable)a);
        docExtractPo.setResults(2);
        docExtractService.updateById((Object)docExtractPo);
        docExtractService.docExtractHandle(docExtractPo);
        docExtractPo.setResults(0);
        docExtractService.updateById((Object)docExtractPo);
        return true;
    }

    @PostConstruct
    public void staticInit() {
        MultipleScheduledTasks a;
        docExtractService = a.docExtractServices;
        if (UniverController.native("]\u0011D\u001e").equals(a.docextratOn)) {
            MultipleScheduledTasks.docExtractTaskThreadPool();
        }
    }

    public static void addDocExtractTaskThreadPool(DocExtractPo a) {
        if (a.getExecutWay() == 0) {
            DocExtractPo docExtractPo = a;
            Comparable<Long> comparable = TimeConverterUtil.convertToSeconds(a.getIntervalTime(), docExtractPo.getUnit());
            Runnable runnable = () -> {
                docExtractPo.setResults(2);
                docExtractService.updateById((Object)docExtractPo);
                try {
                    docExtractService.docExtractHandle(docExtractPo);
                    docExtractPo.setResults(0);
                    return;
                }
                catch (IOException iOException) {
                    docExtractPo.setResults(1);
                    throw new BusinessException(UniverController.native("\u7693\u5f7b\u620f\u63e8\u5f6f\u5e1e\uff60\u68d6\u67b9\u65a4\u4e9f\u661e\u545d\u6b4a\u5e5b\u89d2\u53f0"), (Throwable)iOException);
                }
                finally {
                    docExtractPo.setCreateTime(LocalDateTime.now());
                    docExtractService.updateById((Object)docExtractPo);
                }
            };
            comparable = scheduler.scheduleWithFixedDelay(runnable, 1L, (long)comparable, TimeUnit.SECONDS);
        }
    }

    public MultipleScheduledTasks() {
        MultipleScheduledTasks a;
    }

    public static void docExtractTaskThreadPool() {
        for (Object object : docExtractService.list()) {
            if (object.getExecutWay() != 0) continue;
            DocExtractPo docExtractPo = object;
            object = TimeConverterUtil.convertToSeconds(object.getIntervalTime(), docExtractPo.getUnit());
            Runnable runnable = () -> {
                docExtractPo.setResults(2);
                docExtractService.updateById((Object)docExtractPo);
                try {
                    docExtractService.docExtractHandle(docExtractPo);
                    docExtractPo.setResults(0);
                    return;
                }
                catch (IOException iOException) {
                    docExtractPo.setResults(1);
                    throw new BusinessException(UniverController.native("\u7693\u5f7b\u620f\u63e8\u5f6f\u5e1e\uff60\u68d6\u67b9\u65a4\u4e9f\u661e\u545d\u6b4a\u5e5b\u89d2\u53f0"), (Throwable)iOException);
                }
                finally {
                    docExtractPo.setCreateTime(LocalDateTime.now());
                    docExtractService.updateById((Object)docExtractPo);
                }
            };
            object = scheduler.scheduleWithFixedDelay(runnable, 1L, (Long)object, TimeUnit.SECONDS);
        }
        Runtime.getRuntime().addShutdownHook(new Thread(scheduler::shutdownNow));
    }
}

