/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.dm.server.platformapiimpl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.idp.common.dtobase.IDPApiResponseDto;
import com.jxdinfo.idp.common.exception.IDPExcepttion;
import com.jxdinfo.idp.docmanger.file.dto.DeleteDocumentRequestDto;
import com.jxdinfo.idp.docmanger.file.dto.DocumentRequestDto;
import com.jxdinfo.idp.docmanger.file.dto.DocumentUploadRequestDto;
import com.jxdinfo.idp.docmanger.file.dto.DownloadDocumentResponseDto;
import com.jxdinfo.idp.docmanger.file.dto.QueryDocumentRequestDto;
import com.jxdinfo.idp.docmanger.file.dto.UploadDocumentResponseDto;
import com.jxdinfo.idp.docmanger.file.service.IDPDocMangerFileService;
import com.jxdinfo.idp.dto.QueryDocInfoDto;
import com.jxdinfo.idp.dto.UploadDto;
import com.jxdinfo.idp.interf.DocService;
import com.jxdinfo.idp.interf.FileSliceUploadService;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.codec.digest.DigestUtils;
import org.springframework.context.annotation.Primary;
import org.springframework.mock.web.MockMultipartFile;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;
import org.springframework.web.multipart.MultipartFile;

@Service
@Primary
public class IDPDocMangerFileServiceImpl
implements IDPDocMangerFileService {
    @Resource
    private FileSliceUploadService fileSliceUploadService;
    @Resource
    private DocService docService;

    public UploadDocumentResponseDto uploadDocument(DocumentUploadRequestDto documentRequestDto) {
        try {
            this.fileSliceUploadService.saveChunck(documentRequestDto.getFile(), "1", DigestUtils.md5Hex((byte[])documentRequestDto.getFile().getBytes()), Long.valueOf(documentRequestDto.getFile().getSize() + 0x100000L), "1");
        }
        catch (IOException e) {
            throw new IDPExcepttion("\u6587\u4ef6MD5\u751f\u6210\u5931\u8d25");
        }
        UploadDto uploadDto = new UploadDto();
        uploadDto.setFileName(documentRequestDto.getDocumentName());
        uploadDto.setFile(documentRequestDto.getFile());
        uploadDto.setPid(documentRequestDto.getDirectoryId());
        try {
            uploadDto.setMd5(DigestUtils.md5Hex((byte[])documentRequestDto.getFile().getBytes()));
        }
        catch (IOException e) {
            throw new IDPExcepttion("\u6587\u4ef6MD5\u751f\u6210\u5931\u8d25");
        }
        uploadDto.setChunkNumber("1");
        uploadDto.setTotalChunks("1");
        uploadDto.setCurrentChunkSize(Long.valueOf(documentRequestDto.getFile().getSize() + 0x100000L));
        uploadDto.setFsType(String.valueOf(documentRequestDto.getFileType()));
        uploadDto.setFormat(documentRequestDto.getFile().getOriginalFilename().substring(documentRequestDto.getFile().getOriginalFilename().lastIndexOf(".") + 1));
        JSONObject re = this.fileSliceUploadService.upload(uploadDto);
        HashMap<String, String> requestBody = new HashMap<String, String>();
        requestBody.put("docId", "");
        JSONArray jsonArray = new JSONArray();
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("id", re.get((Object)"fileId"));
        jsonObject.put("fsType", (Object)"");
        jsonArray.add((Object)jsonObject);
        requestBody.put("docInfo", (String)jsonArray);
        if (this.fileSliceUploadService.submitDoc(requestBody)) {
            UploadDocumentResponseDto dto = new UploadDocumentResponseDto();
            dto.setDocumentId(Long.valueOf(Long.parseLong(re.getString("fileId"))));
            return dto;
        }
        UploadDocumentResponseDto dto = new UploadDocumentResponseDto();
        dto.setStatus(Boolean.valueOf(false));
        dto.setErrorMessage("\u4e0a\u4f20\u5931\u8d25");
        return dto;
    }

    public DownloadDocumentResponseDto downloadDocument(DocumentRequestDto documentRequestDto) {
        if (ObjectUtils.isEmpty((Object)documentRequestDto.getDocumentId())) {
            DownloadDocumentResponseDto dto = new DownloadDocumentResponseDto();
            dto.setStatus(Boolean.valueOf(false));
            dto.setErrorMessage("\u6587\u4ef6ID\u4e0d\u80fd\u4e3a\u7a7a");
            return dto;
        }
        Map map = this.docService.getFileStream(String.valueOf(documentRequestDto.getDocumentId()));
        MockMultipartFile file = new MockMultipartFile(String.valueOf(map.get("docName")), (byte[])map.get("fileStream"));
        DownloadDocumentResponseDto dto = new DownloadDocumentResponseDto();
        dto.setFile((MultipartFile)file);
        dto.setFormat(String.valueOf(map.get("format")));
        dto.setDocumentName(String.valueOf(map.get("docName")));
        return dto;
    }

    public Page<DownloadDocumentResponseDto> queryDocument(QueryDocumentRequestDto queryDocumentRequestDto) {
        QueryDocInfoDto dto = new QueryDocInfoDto();
        dto.setPid(queryDocumentRequestDto.getDirectoryId());
        dto.setDocName(queryDocumentRequestDto.getDocumentName());
        ArrayList<String> format = new ArrayList<String>();
        format.add(queryDocumentRequestDto.getFormat());
        dto.setFormat(format);
        ArrayList<String> fsType = new ArrayList<String>();
        if (!ObjectUtils.isEmpty((Object)queryDocumentRequestDto.getFileType())) {
            fsType.add(String.valueOf(queryDocumentRequestDto.getFileType()));
        }
        dto.setFsType(fsType);
        Map map = this.docService.queryFileByFold(dto);
        Page page = new Page();
        page.setTotal(Long.parseLong(String.valueOf(map.get("total"))));
        page.setSize(queryDocumentRequestDto.getSize());
        page.setCurrent(queryDocumentRequestDto.getCurrent());
        page.setRecords(((List)map.get("fileInfoVoList")).stream().map(i -> {
            DownloadDocumentResponseDto documentResponseDto = new DownloadDocumentResponseDto();
            documentResponseDto.setFileId(i.getId());
            documentResponseDto.setDocumentName(i.getName());
            documentResponseDto.setFormat(i.getFormat());
            if (!ObjectUtils.isEmpty((Object)i.getFsType())) {
                documentResponseDto.setFileType(Long.valueOf(Long.parseLong(i.getFsType())));
            }
            documentResponseDto.setDirectoryId(i.getPid());
            documentResponseDto.setDirectoryName(i.getFoldName());
            return documentResponseDto;
        }).collect(Collectors.toList()));
        return page;
    }

    public IDPApiResponseDto updateDocumentInfo(DocumentRequestDto documentRequestDto) {
        if (ObjectUtils.isEmpty((Object)documentRequestDto.getDocumentId())) {
            return new IDPApiResponseDto(Boolean.valueOf(false), "\u66f4\u65b0\u6587\u4ef6\u5931\u8d25\uff0c\u672a\u4f20\u5165id");
        }
        ArrayList list = new ArrayList();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("id", String.valueOf(documentRequestDto.getDocumentId()));
        map.put("docName", documentRequestDto.getDocumentName());
        if (!ObjectUtils.isEmpty((Object)documentRequestDto.getFileType())) {
            map.put("fsType", String.valueOf(documentRequestDto.getFileType()));
        }
        list.add(map);
        if (this.docService.updateFileInfo(list)) {
            return new IDPApiResponseDto();
        }
        return new IDPApiResponseDto(Boolean.valueOf(false), "\u4fee\u6539\u6587\u4ef6\u57fa\u672c\u4fe1\u606f\u5931\u8d25");
    }

    public IDPApiResponseDto deleteDocumentInfo(DeleteDocumentRequestDto deleteDocumentRequestDto) {
        if (ObjectUtils.isEmpty((Object)deleteDocumentRequestDto.getDocumentId())) {
            return new IDPApiResponseDto(Boolean.valueOf(false), "\u5220\u9664\u6587\u4ef6\u5931\u8d25\uff0c\u672a\u4f20\u5165id");
        }
        if (this.docService.deleteFileInfo(deleteDocumentRequestDto.getDocumentId())) {
            return new IDPApiResponseDto();
        }
        return new IDPApiResponseDto(Boolean.valueOf(false), "\u5220\u9664\u6587\u4ef6\u5931\u8d25");
    }
}

