/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.dm.server.schedule;

import cn.hutool.core.thread.ThreadUtil;
import com.jxdinfo.idp.common.exception.BusinessException;
import com.jxdinfo.idp.common.util.file.FileUtil;
import com.jxdinfo.idp.dm.server.util.DocUtil;
import com.jxdinfo.idp.dto.DocInfoDto;
import java.io.File;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThreadPoolToPdf {
    private static final Logger log = LoggerFactory.getLogger(ThreadPoolToPdf.class);

    public static void ThreadPool(List<DocInfoDto> docInfoDtoList) {
        try {
            log.info("====================\u538b\u7f29\u5305\u6587\u4ef6\u5f00\u59cbpdf\u8f6c\u6362===================");
            long time1 = System.currentTimeMillis();
            for (DocInfoDto docInfoDto : docInfoDtoList) {
                if (docInfoDto.getIsToPdf() == 1) continue;
                File file = new File(docInfoDto.getPdfPath());
                FileUtil.createFilePath((File)file);
                ThreadUtil.execute(() -> DocUtil.toPdfThread(docInfoDto.getId(), new File(docInfoDto.getFilePath()), file));
            }
            long time2 = System.currentTimeMillis();
            log.info("=========================\u6587\u4ef6\u8f6c\u6362pdf\u5b8c\u6210\uff0c\u7528\u65f6" + (time2 - time1) + "\u6beb\u79d2==========================");
        }
        catch (Exception e) {
            throw new BusinessException("\u6587\u4ef6\u8f6c\u6362\u7ebf\u7a0b\u6c60\u5f02\u5e38", (Throwable)e);
        }
    }
}

