/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.dm.server.schedule;

import com.jxdinfo.idp.common.exception.BusinessException;
import com.jxdinfo.idp.dm.server.util.TimeConverterUtil;
import com.jxdinfo.idp.interf.DocExtractService;
import com.jxdinfo.idp.po.DocExtractPo;
import java.io.IOException;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class MultipleScheduledTasks {
    @Autowired
    private DocExtractService docExtractServices;
    @Value(value="${docbase.docextratOn}")
    private String docextratOn;
    private static DocExtractService docExtractService;
    private static final ScheduledExecutorService scheduler;

    @PostConstruct
    public void staticInit() {
        docExtractService = this.docExtractServices;
        if ("true".equals(this.docextratOn)) {
            MultipleScheduledTasks.docExtractTaskThreadPool();
        }
    }

    public static void docExtractTaskThreadPool() {
        List list = docExtractService.list();
        for (DocExtractPo docExtractPo : list) {
            if (docExtractPo.getExecutWay() != 0) continue;
            Long seconds = TimeConverterUtil.convertToSeconds(docExtractPo.getIntervalTime(), docExtractPo.getUnit());
            Runnable timePrinter = () -> {
                docExtractPo.setResults(2);
                docExtractService.updateById((Object)docExtractPo);
                try {
                    docExtractService.docExtractHandle(docExtractPo);
                    docExtractPo.setResults(0);
                }
                catch (IOException e) {
                    docExtractPo.setResults(1);
                    throw new BusinessException("\u76ee\u5f55\u626b\u63cf\u5f02\u5e38\uff0c\u68c0\u67e5\u6587\u4ef6\u662f\u5426\u6b63\u5e38\u89e3\u538b", (Throwable)e);
                }
                finally {
                    docExtractPo.setCreateTime(LocalDateTime.now());
                    docExtractService.updateById((Object)docExtractPo);
                }
            };
            ScheduledFuture<?> scheduledFuture = scheduler.scheduleWithFixedDelay(timePrinter, 1L, seconds, TimeUnit.SECONDS);
        }
        Runtime.getRuntime().addShutdownHook(new Thread(scheduler::shutdownNow));
    }

    public static void addDocExtractTaskThreadPool(DocExtractPo docExtractPo) {
        if (docExtractPo.getExecutWay() == 0) {
            Long seconds = TimeConverterUtil.convertToSeconds(docExtractPo.getIntervalTime(), docExtractPo.getUnit());
            Runnable timePrinter = () -> {
                docExtractPo.setResults(2);
                docExtractService.updateById((Object)docExtractPo);
                try {
                    docExtractService.docExtractHandle(docExtractPo);
                    docExtractPo.setResults(0);
                }
                catch (IOException e) {
                    docExtractPo.setResults(1);
                    throw new BusinessException("\u76ee\u5f55\u626b\u63cf\u5f02\u5e38\uff0c\u68c0\u67e5\u6587\u4ef6\u662f\u5426\u6b63\u5e38\u89e3\u538b", (Throwable)e);
                }
                finally {
                    docExtractPo.setCreateTime(LocalDateTime.now());
                    docExtractService.updateById((Object)docExtractPo);
                }
            };
            ScheduledFuture<?> scheduledFuture = scheduler.scheduleWithFixedDelay(timePrinter, 1L, seconds, TimeUnit.SECONDS);
        }
    }

    public static boolean handleDocExtractTask(Long id) throws IOException {
        DocExtractPo docExtractPo = (DocExtractPo)docExtractService.getById((Serializable)id);
        docExtractPo.setResults(2);
        docExtractService.updateById((Object)docExtractPo);
        docExtractService.docExtractHandle(docExtractPo);
        docExtractPo.setResults(0);
        docExtractService.updateById((Object)docExtractPo);
        return true;
    }

    static {
        scheduler = Executors.newScheduledThreadPool(2);
    }
}

